/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.common.ui.slicing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import uk.ac.gda.doe.DOEField;
import uk.ac.gda.doe.DOEUtils;

public class DimsData
implements Serializable {
    private static final long serialVersionUID = -6889488003603498855L;
    @DOEField(value=1, type=Integer.class)
    private String sliceRange;
    private int dimension = -1;
    private int axis = -1;
    private int slice = 0;

    public DimsData() {
    }

    public DimsData(int n) {
        this.dimension = n;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.axis;
        n = 31 * n + this.dimension;
        n = 31 * n + this.slice;
        n = 31 * n + (this.sliceRange == null ? 0 : this.sliceRange.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DimsData dimsData = (DimsData)object;
        if (this.axis != dimsData.axis) {
            return false;
        }
        if (this.dimension != dimsData.dimension) {
            return false;
        }
        if (this.slice != dimsData.slice) {
            return false;
        }
        return !(this.sliceRange == null ? dimsData.sliceRange != null : !this.sliceRange.equals(dimsData.sliceRange));
    }

    public String getSliceRange() {
        if (this.axis > -1) {
            return null;
        }
        return this.sliceRange;
    }

    public void setSliceRange(String string) {
        this.sliceRange = string;
    }

    public int getDimension() {
        return this.dimension;
    }

    public void setDimension(int n) {
        this.dimension = n;
    }

    public int getAxis() {
        return this.axis;
    }

    public void setAxis(int n) {
        this.axis = n;
    }

    public int getSlice() {
        if (this.axis > -1) {
            return -1;
        }
        return this.slice;
    }

    public void setSlice(int n) {
        this.slice = n;
    }

    public String toString() {
        try {
            return BeanUtils.describe((Object)this).toString();
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    public String getUserString(int n) {
        if (this.axis > -1) {
            if (this.axis == 0) {
                return "X";
            }
            if (this.axis == 1) {
                return "Y";
            }
            if (this.axis == 2) {
                return "Z";
            }
        }
        if (this.sliceRange != null) {
            return this.sliceRange;
        }
        if (n > 0) {
            return String.valueOf(this.slice) + ";" + (n - 1) + ";1";
        }
        return String.valueOf(this.slice);
    }

    public List<DimsData> expand(int n) {
        ArrayList<DimsData> arrayList = new ArrayList<DimsData>(7);
        if (this.axis > -1) {
            arrayList.add(this);
            return arrayList;
        }
        if (this.sliceRange != null) {
            List list = DOEUtils.expand((String)this.sliceRange);
            for (Number number : list) {
                DimsData dimsData = new DimsData(this.dimension);
                dimsData.setSlice(number.intValue());
                arrayList.add(dimsData);
            }
            return arrayList;
        }
        int n2 = this.slice;
        while (n2 < n) {
            DimsData dimsData = new DimsData(this.dimension);
            dimsData.setSlice(n2);
            arrayList.add(dimsData);
            ++n2;
        }
        return arrayList;
    }
}

