/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.common.ui.project;

import java.util.Map;
import org.dawb.common.util.xml.XSDChecker;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.xml.sax.SAXException;

public class XMLBuilder
extends IncrementalProjectBuilder {
    public static String ID = "org.dawb.common.ui.DataBuilder";
    public static final String MARKER_ID = "org.dawb.common.ui.XMLValidationMarker";

    protected IProject[] build(int n, Map map, IProgressMonitor iProgressMonitor) throws CoreException {
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                XMLBuilder.this.validateXML(iProgressMonitor);
            }
        }, iProgressMonitor);
        return null;
    }

    protected void validateXML(IProgressMonitor iProgressMonitor) throws CoreException {
        if (!this.deleteMarkers()) {
            return;
        }
        try {
            IProject iProject = this.getProject();
            IResource[] iResourceArray = iProject.members();
            iProgressMonitor.beginTask("Validating Scan Configurations", iResourceArray.length);
            int n = 0;
            while (n < iResourceArray.length) {
                if (iResourceArray[n] instanceof IFile) {
                    this.validateFile((IFile)iResourceArray[n]);
                    iProgressMonitor.worked(1);
                }
                ++n;
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    private void validateFile(IFile iFile) throws CoreException {
        if (iFile.getLocation().getFileExtension() == null) {
            return;
        }
        if (!iFile.getLocation().getFileExtension().toLowerCase().endsWith("xml")) {
            return;
        }
        try {
            XSDChecker.validateFile((String)iFile.getLocation().toOSString());
        }
        catch (SAXException sAXException) {
            this.createMarker(iFile, sAXException.getMessage().split(":")[1]);
        }
        catch (Exception exception) {
            this.createMarker(iFile, exception.getMessage());
        }
    }

    private void createMarker(IFile iFile, String string) throws CoreException {
        IMarker iMarker = iFile.createMarker(MARKER_ID);
        iMarker.setAttribute("message", (Object)string);
        iMarker.setAttribute("severity", 2);
        iMarker.setAttribute("location", (Object)iFile.getFullPath().toString());
    }

    private boolean deleteMarkers() {
        try {
            this.getProject().deleteMarkers(MARKER_ID, false, 2);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

