/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.common.ui.project;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.dawb.common.ui.project.DawbResourcePage;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderLinkWizard
extends Wizard
implements IImportWizard {
    private static Logger logger = LoggerFactory.getLogger(FolderLinkWizard.class);
    private DawbResourcePage page;
    private IStructuredSelection selection;

    public FolderLinkWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new DawbResourcePage("Folder Import", this.selection, DawbResourcePage.RESOURCE_CHOICE.PROJECT_AND_EXTERNAL_FOLDER, "Sequence.xml");
        this.page.setWizard((IWizard)this);
        this.addPage((IWizardPage)this.page);
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.selection = iStructuredSelection;
    }

    public boolean performFinish() {
        try {
            final IContainer iContainer = this.page.getProjectContainer();
            final File file = this.page.getExternalFolder();
            final IFolder iFolder = iContainer.getFolder((IPath)new Path(file.getName()));
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            iProgressMonitor.beginTask("Creating link to " + iFolder.getName(), 10);
                            iFolder.createLink(file.toURI(), 1, iProgressMonitor);
                            iContainer.refreshLocal(1, iProgressMonitor);
                        }
                        catch (ResourceException resourceException) {
                            MessageDialog.openError((Shell)FolderLinkWizard.this.getShell(), (String)"Cannot Import Folder", (String)resourceException.getMessage());
                            logger.error("Cannot create link folder " + iFolder.getName(), (Throwable)resourceException);
                            iProgressMonitor.done();
                        }
                        catch (CoreException coreException) {
                            logger.error("Cannot create link folder " + iFolder.getName(), (Throwable)coreException);
                            iProgressMonitor.done();
                        }
                    }
                    finally {
                        iProgressMonitor.done();
                    }
                }
            });
        }
        catch (Exception exception) {
            logger.error("Cannot create link", (Throwable)exception);
            return false;
        }
        return true;
    }
}

