/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.common.ui.project;

import java.lang.reflect.InvocationTargetException;
import org.dawb.common.ui.project.DawbResourcePage;
import org.dawb.common.ui.util.EclipseUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DADWizard
extends Wizard
implements INewWizard {
    private static Logger logger = LoggerFactory.getLogger(DADWizard.class);
    private DawbResourcePage page;
    private IStructuredSelection selection;

    public DADWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new DawbResourcePage("Folder for Sequence File", this.selection, DawbResourcePage.RESOURCE_CHOICE.PROJECT_AND_NAME, "DADSequence.xml");
        this.addPage((IWizardPage)this.page);
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.selection = iStructuredSelection;
    }

    public boolean performFinish() {
        final IContainer iContainer = this.page.getProjectContainer();
        final String string = this.page.getSequenceName();
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                try {
                    try {
                        DADWizard.this.doFinish(iContainer, string, iProgressMonitor);
                    }
                    catch (Exception exception) {
                        throw new InvocationTargetException(exception);
                    }
                }
                finally {
                    iProgressMonitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, iRunnableWithProgress);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)throwable.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(IContainer iContainer, String string, IProgressMonitor iProgressMonitor) {
        try {
            iProgressMonitor.beginTask("Create " + string, 5);
            final IFile iFile = iContainer instanceof IFolder ? ((IFolder)iContainer).getFile(string) : ((IProject)iContainer).getFile(string);
            iFile.create(DADWizard.class.getResourceAsStream("sequence.xml"), true, iProgressMonitor);
            iProgressMonitor.worked(1);
            iContainer.refreshLocal(1, iProgressMonitor);
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        EclipseUtils.openEditor(iFile);
                    }
                    catch (PartInitException partInitException) {
                        logger.error("Cannot open editor", (Throwable)partInitException);
                    }
                }
            });
        }
        catch (Exception exception) {
            logger.error("Cannot create sequence", (Throwable)exception);
        }
    }
}

