/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.common.ui.preferences;

import org.dawb.common.ui.Activator;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class TangoPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.dawb.common.ui.views.tangoPreferences";
    private BooleanFieldEditor mockMode;
    private StringFieldEditor serverEd;
    private StringFieldEditor beamlineName;
    private StringFieldEditor specSessionName;
    private IntegerFieldEditor portEd;

    public TangoPreferencePage() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription("Preferences for talking to a tango server.");
    }

    protected void createFieldEditors() {
        this.mockMode = new BooleanFieldEditor("org.dawb.remote.session.mock", "Mock Connection", this.getFieldEditorParent());
        this.addField((FieldEditor)this.mockMode);
        this.mockMode.setPreferenceName("org.dawb.remote.session.mock");
        this.serverEd = new StringFieldEditor("org.dawb.server.name", "Database Name", this.getFieldEditorParent());
        this.serverEd.setEmptyStringAllowed(false);
        this.addField((FieldEditor)this.serverEd);
        this.portEd = new IntegerFieldEditor("org.dawb.server.port", "Database Port", this.getFieldEditorParent());
        this.portEd.setEmptyStringAllowed(false);
        this.addField((FieldEditor)this.portEd);
        this.beamlineName = new StringFieldEditor("org.dawb.beamline.name", "Beamline Name", this.getFieldEditorParent());
        this.beamlineName.setEmptyStringAllowed(false);
        this.addField((FieldEditor)this.beamlineName);
        this.specSessionName = new StringFieldEditor("org.dawb.spec.session.name", "Spec Session Name", this.getFieldEditorParent());
        this.specSessionName.setEmptyStringAllowed(false);
        this.addField((FieldEditor)this.specSessionName);
        this.setValid(true);
    }

    protected void initialize() {
        super.initialize();
        this.updateMockEnabled();
        this.mockMode.getDescriptionControl(this.getFieldEditorParent()).setToolTipText("In mock mode no connection is made to tango and instead a local value repository is used. This mode applies to all tango connections from the workbench, workflow actors, spec console, monitoring etc.");
    }

    private void updateMockEnabled() {
        this.serverEd.setEnabled(!this.mockMode.getBooleanValue(), this.getFieldEditorParent());
        this.portEd.setEnabled(!this.mockMode.getBooleanValue(), this.getFieldEditorParent());
        this.beamlineName.setEnabled(!this.mockMode.getBooleanValue(), this.getFieldEditorParent());
        this.specSessionName.setEnabled(!this.mockMode.getBooleanValue(), this.getFieldEditorParent());
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        if (this.getFieldEditorParent() == null || this.getFieldEditorParent().isDisposed()) {
            return;
        }
        if (propertyChangeEvent.getSource() == this.mockMode) {
            this.updateMockEnabled();
            System.setProperty("org.dawb.test.session", new Boolean(this.mockMode.getBooleanValue()).toString());
        }
    }

    protected void checkState() {
        super.checkState();
        if (this.beamlineName.getStringValue() == null || "".equals(this.beamlineName.getStringValue())) {
            this.setErrorMessage("Please set a beamline name to be used in the url to tango devices.");
            return;
        }
        if (this.specSessionName.getStringValue() == null || "".equals(this.specSessionName.getStringValue())) {
            this.setErrorMessage("Please set a spec session name to be used in the url to tango spec session.");
            return;
        }
        this.setErrorMessage(null);
        this.setValid(true);
    }

    public void init(IWorkbench iWorkbench) {
    }
}

