/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.common.ui.preferences;

import java.net.InetAddress;
import java.util.Collection;
import java.util.HashSet;
import org.dawb.common.ui.Activator;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;

public class CommonUIPreferenceInitializer
extends AbstractPreferenceInitializer {
    private Collection<String> integerPrefs;
    private Collection<String> booleanPrefs;

    public void initializeDefaultPreferences() {
        IPreferenceStore iPreferenceStore = Activator.getDefault().getPreferenceStore();
        this.booleanPrefs = new HashSet<String>(7);
        iPreferenceStore.setDefault("org.dawb.dashboard.bounds", false);
        this.booleanPrefs.add("org.dawb.dashboard.bounds");
        iPreferenceStore.setDefault("org.dawb.dashboard.dummy", false);
        this.booleanPrefs.add("org.dawb.dashboard.dummy");
        iPreferenceStore.setDefault("org.dawb.dashboard.format", "#0.00");
        this.integerPrefs = new HashSet<String>(7);
        iPreferenceStore.setDefault("org.dawb.remote.session.mock", true);
        iPreferenceStore.setDefault("org.dawb.server.name", this.getTangoHostName());
        iPreferenceStore.setDefault("org.dawb.server.port", this.getTangoHostPort());
        this.integerPrefs.add("org.dawb.server.port");
        iPreferenceStore.setDefault("org.dawb.beamline.name", this.getBeamlineName());
        iPreferenceStore.setDefault("org.dawb.spec.session.name", "SPEC");
    }

    private String getTangoHostName() {
        String string = System.getenv("TANGO_HOST");
        if (string != null) {
            return string.split(":")[0];
        }
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            return "<unknown>";
        }
    }

    private int getTangoHostPort() {
        String string = System.getenv("TANGO_HOST");
        if (string != null) {
            return Integer.parseInt(string.split(":")[1]);
        }
        return 20000;
    }

    private String getBeamlineName() {
        String string = System.getenv("BEAMLINENAME");
        if (string != null) {
            return string.toLowerCase();
        }
        return "<unknown>";
    }

    private boolean isInt(String string) {
        return this.integerPrefs.contains(string);
    }

    private boolean isBoolean(String string) {
        return this.booleanPrefs.contains(string);
    }
}

