/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.common.ui.plot.region;

import java.text.DecimalFormat;
import java.util.Arrays;
import org.dawb.common.util.text.NumberUtils;

public class RegionBounds {
    protected double[] centre;
    protected double[] p1;
    protected double[] p2;
    private DecimalFormat format;

    public RegionBounds() {
    }

    public RegionBounds(double[] dArray, double[] dArray2) {
        this.p1 = dArray;
        this.p2 = dArray2;
        this.format = new DecimalFormat("##0.00E0");
    }

    public double[] getP1() {
        return this.p1;
    }

    public void setP1(double[] dArray) {
        this.p1 = dArray;
    }

    public double[] getP2() {
        return this.p2;
    }

    public void setP2(double[] dArray) {
        this.p2 = dArray;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Arrays.hashCode(this.centre);
        n = 31 * n + Arrays.hashCode(this.p1);
        n = 31 * n + Arrays.hashCode(this.p2);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RegionBounds regionBounds = (RegionBounds)object;
        if (!Arrays.equals(this.centre, regionBounds.centre)) {
            return false;
        }
        if (!Arrays.equals(this.p1, regionBounds.p1)) {
            return false;
        }
        return Arrays.equals(this.p2, regionBounds.p2);
    }

    public String toString() {
        if (this.p1 == null || this.p2 == null) {
            return "Empty region";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        stringBuilder.append(this.format.format(this.p1[0]));
        stringBuilder.append(", ");
        stringBuilder.append(this.format.format(this.p1[1]));
        stringBuilder.append(") to (");
        stringBuilder.append(this.format.format(this.p2[0]));
        stringBuilder.append(", ");
        stringBuilder.append(this.format.format(this.p2[1]));
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public RegionBounds getDiff(RegionBounds regionBounds) {
        return new RegionBounds(new double[]{this.p1[0] - regionBounds.p1[0], this.p1[1] - regionBounds.p1[1]}, new double[]{this.p2[0] - regionBounds.p2[0], this.p2[1] - regionBounds.p2[1]});
    }

    public boolean equalsTolerance(RegionBounds regionBounds, double d, double d2) {
        if (this == regionBounds) {
            return true;
        }
        if (regionBounds == null) {
            return false;
        }
        if (!NumberUtils.equalsTolerance((Number)this.p1[0], (Number)regionBounds.p1[0], (Number)d)) {
            return false;
        }
        if (!NumberUtils.equalsTolerance((Number)this.p2[0], (Number)regionBounds.p2[0], (Number)d)) {
            return false;
        }
        if (!NumberUtils.equalsTolerance((Number)this.p1[1], (Number)regionBounds.p1[1], (Number)d2)) {
            return false;
        }
        return NumberUtils.equalsTolerance((Number)this.p2[1], (Number)regionBounds.p2[1], (Number)d2);
    }

    public double[] getCentre() {
        if (this.centre == null) {
            return new double[]{this.getP2()[0] - this.getP1()[0], this.getP2()[1] - this.getP1()[1]};
        }
        return this.centre;
    }

    public void setCentre(double[] dArray) {
        this.centre = dArray;
    }

    public double getDx() {
        return this.p2[0] - this.p1[0];
    }

    public double getDy() {
        return this.p2[1] - this.p1[1];
    }

    public double getLength() {
        return Math.pow(Math.pow(this.getDx(), 2.0) + Math.pow(this.getDy(), 2.0), 0.5);
    }

    public double getY() {
        return Math.min(this.p1[1], this.p2[1]);
    }

    public double getX() {
        return Math.min(this.p1[0], this.p2[0]);
    }

    public double getWidth() {
        return Math.max(this.p1[0], this.p2[0]) - Math.min(this.p1[0], this.p2[0]);
    }

    public double getHeight() {
        return Math.max(this.p1[1], this.p2[1]) - Math.min(this.p1[1], this.p2[1]);
    }
}

