/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.common.ui.plot.region;

import java.util.ArrayList;
import java.util.List;
import org.dawb.common.ui.plot.region.IRegionBoundsListener;
import org.dawb.common.ui.plot.region.RegionBounds;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public interface IRegion {
    public String getName();

    public void setName(String var1);

    public Color getRegionColor();

    public void setRegionColor(Color var1);

    public boolean isShowPosition();

    public void setShowPosition(boolean var1);

    public int getAlpha();

    public void setAlpha(int var1);

    public boolean isVisible();

    public void setVisible(boolean var1);

    public boolean isMotile();

    public void setMotile(boolean var1);

    public boolean isShowLabel();

    public void setShowLabel(boolean var1);

    public RegionBounds getRegionBounds();

    public void setRegionBounds(RegionBounds var1);

    public boolean addRegionBoundsListener(IRegionBoundsListener var1);

    public boolean removeRegionBoundsListener(IRegionBoundsListener var1);

    public void remove();

    public int getLineWidth();

    public void setLineWidth(int var1);

    public RegionType getRegionType();

    public boolean isTrackMouse();

    public void setTrackMouse(boolean var1);

    public boolean isUserRegion();

    public void setUserRegion(boolean var1);

    public void addMouseListener(MouseListener var1);

    public void removeMouseListener(MouseListener var1);

    public void addMouseMotionListener(MouseMotionListener var1);

    public void removeMouseMotionListener(MouseMotionListener var1);

    public static enum RegionType {
        LINE("Line", 0, Display.getDefault().getSystemColor(13)),
        BOX("Box", 1, Display.getDefault().getSystemColor(5)),
        XAXIS("X-Axis", 2, Display.getDefault().getSystemColor(9)),
        YAXIS("Y-Axis", 3, Display.getDefault().getSystemColor(9)),
        SECTOR("Sector", 4, Display.getDefault().getSystemColor(3)),
        XAXIS_LINE("X-Axis Line", 5, Display.getDefault().getSystemColor(9)),
        YAXIS_LINE("Y-Axis Line", 6, Display.getDefault().getSystemColor(9));

        private int index;
        private String name;
        private Color defaultColor;
        public static List<RegionType> ALL_TYPES;

        static {
            ALL_TYPES = new ArrayList<RegionType>(5);
            ALL_TYPES.add(LINE);
            ALL_TYPES.add(BOX);
            ALL_TYPES.add(XAXIS);
            ALL_TYPES.add(YAXIS);
            ALL_TYPES.add(SECTOR);
            ALL_TYPES.add(XAXIS_LINE);
            ALL_TYPES.add(YAXIS_LINE);
        }

        private RegionType(String string2, int n2, Color color) {
            this.name = string2;
            this.index = n2;
            this.defaultColor = color;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public Color getDefaultColor() {
            return this.defaultColor;
        }

        public static RegionType getRegion(int n) {
            for (RegionType regionType : ALL_TYPES) {
                if (regionType.getIndex() != n) continue;
                return regionType;
            }
            return null;
        }
    }
}

