/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.common.ui.plot.region;

import java.util.Collection;
import java.util.HashSet;
import org.dawb.common.ui.plot.region.IRegion;
import org.dawb.common.ui.plot.region.IRegionBoundsListener;
import org.dawb.common.ui.plot.region.RegionBounds;
import org.dawb.common.ui.plot.region.RegionBoundsEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;

public abstract class AbstractRegion
implements IRegion {
    private Collection<IRegionBoundsListener> regionBoundsListeners;
    private boolean regionEventsActive = true;
    protected RegionBounds regionBounds;
    protected boolean trackMouse;
    private boolean userRegion = true;

    @Override
    public boolean addRegionBoundsListener(IRegionBoundsListener iRegionBoundsListener) {
        if (this.regionBoundsListeners == null) {
            this.regionBoundsListeners = new HashSet<IRegionBoundsListener>(11);
        }
        return this.regionBoundsListeners.add(iRegionBoundsListener);
    }

    @Override
    public boolean removeRegionBoundsListener(IRegionBoundsListener iRegionBoundsListener) {
        if (this.regionBoundsListeners == null) {
            return false;
        }
        return this.regionBoundsListeners.remove(iRegionBoundsListener);
    }

    protected void clearListeners() {
        if (this.regionBoundsListeners == null) {
            return;
        }
        this.regionBoundsListeners.clear();
    }

    protected void fireRegionBoundsDragged(RegionBounds regionBounds) {
        if (this.regionBoundsListeners == null) {
            return;
        }
        if (!this.regionEventsActive) {
            return;
        }
        RegionBoundsEvent regionBoundsEvent = new RegionBoundsEvent(this, regionBounds);
        for (IRegionBoundsListener iRegionBoundsListener : this.regionBoundsListeners) {
            iRegionBoundsListener.regionBoundsDragged(regionBoundsEvent);
        }
    }

    protected void fireRegionBoundsChanged(RegionBounds regionBounds) {
        if (this.regionBoundsListeners == null) {
            return;
        }
        if (!this.regionEventsActive) {
            return;
        }
        RegionBoundsEvent regionBoundsEvent = new RegionBoundsEvent(this, regionBounds);
        for (IRegionBoundsListener iRegionBoundsListener : this.regionBoundsListeners) {
            iRegionBoundsListener.regionBoundsChanged(regionBoundsEvent);
        }
    }

    @Override
    public RegionBounds getRegionBounds() {
        return this.regionBounds;
    }

    @Override
    public void setRegionBounds(RegionBounds regionBounds) {
        this.regionBounds = regionBounds;
        this.updateRegionBounds();
        this.fireRegionBoundsChanged(regionBounds);
    }

    protected abstract RegionBounds createRegionBounds(boolean var1);

    protected void updateRegionBounds() {
        if (this.regionBounds != null) {
            try {
                this.regionEventsActive = false;
                this.updateRegionBounds(this.regionBounds);
            }
            finally {
                this.regionEventsActive = true;
            }
        }
    }

    protected abstract void updateRegionBounds(RegionBounds var1);

    public String toString() {
        if (this.getName() != null) {
            return this.getName();
        }
        return super.toString();
    }

    @Override
    public boolean isTrackMouse() {
        return this.trackMouse;
    }

    @Override
    public void setTrackMouse(boolean bl) {
        this.trackMouse = bl;
    }

    @Override
    public boolean isUserRegion() {
        return this.userRegion;
    }

    @Override
    public void setUserRegion(boolean bl) {
        this.userRegion = bl;
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
    }
}

