/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.common.ui.plot;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;

public class PlottingSelectionProvider
implements ISelectionProvider {
    private Set<ISelectionChangedListener> listeners;
    private ISelection currentSelection = new StructuredSelection();
    private BlockingDeque<ISelection> selectionQueue;
    private Thread selectionJob;

    public PlottingSelectionProvider() {
        this.listeners = new HashSet<ISelectionChangedListener>(11);
        this.selectionQueue = new LinkedBlockingDeque<ISelection>(1);
        this.selectionJob = new Thread("Plot selection thread"){

            @Override
            public void run() {
                while (PlottingSelectionProvider.this.listeners != null && PlottingSelectionProvider.this.selectionQueue != null) {
                    try {
                        PlottingSelectionProvider.this.currentSelection = (ISelection)PlottingSelectionProvider.this.selectionQueue.take();
                        if (PlottingSelectionProvider.this.currentSelection instanceof DoneSelection) {
                            return;
                        }
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)PlottingSelectionProvider.this, PlottingSelectionProvider.this.currentSelection);
                                for (ISelectionChangedListener iSelectionChangedListener : PlottingSelectionProvider.this.listeners) {
                                    iSelectionChangedListener.selectionChanged(selectionChangedEvent);
                                }
                            }
                        });
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        this.selectionJob.setDaemon(true);
        this.selectionJob.setPriority(1);
        this.selectionJob.start();
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.listeners.add(iSelectionChangedListener);
    }

    public ISelection getSelection() {
        return this.currentSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.listeners.remove(iSelectionChangedListener);
    }

    public void setSelection(ISelection iSelection) {
        this.selectionQueue.clear();
        this.selectionQueue.add(iSelection);
    }

    public void clear() {
        if (this.listeners != null) {
            this.listeners.clear();
        }
        this.selectionQueue.clear();
        this.selectionQueue.add((ISelection)new DoneSelection());
    }

    private final class DoneSelection
    extends StructuredSelection {
        private DoneSelection() {
        }
    }
}

