/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.common.ui.plot;

import java.net.URL;
import java.util.List;
import org.dawb.common.ui.Activator;
import org.dawb.common.ui.menu.MenuAction;
import org.dawb.common.ui.plot.AbstractPlottingSystem;
import org.dawb.common.ui.plot.tool.IToolChangeListener;
import org.dawb.common.ui.plot.tool.IToolPage;
import org.dawb.common.ui.plot.tool.IToolPageSystem;
import org.dawb.common.ui.plot.tool.ToolChangeEvent;
import org.dawb.common.ui.util.EclipseUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlottingActionBarManager {
    private static final Logger logger = LoggerFactory.getLogger(PlottingActionBarManager.class);
    protected List<IAction> extraImageActions;
    protected List<IAction> extra1DActions;
    protected AbstractPlottingSystem system;
    private boolean isToolsRequired = true;

    public PlottingActionBarManager(AbstractPlottingSystem abstractPlottingSystem) {
        this.system = abstractPlottingSystem;
    }

    public List<IAction> getExtraImageActions() {
        return this.extraImageActions;
    }

    public void setExtraImageActions(List<IAction> list) {
        this.extraImageActions = list;
    }

    public List<IAction> getExtra1DActions() {
        return this.extra1DActions;
    }

    public void setExtra1DActions(List<IAction> list) {
        this.extra1DActions = list;
    }

    public void dispose() {
        if (this.extraImageActions != null) {
            this.extraImageActions.clear();
        }
        this.extraImageActions = null;
        if (this.extra1DActions != null) {
            this.extra1DActions.clear();
        }
        this.extra1DActions = null;
    }

    public void setToolsRequired(boolean bl) {
        this.isToolsRequired = bl;
    }

    protected MenuAction createToolActions(final IToolPage.ToolPageRole toolPageRole, final String string) throws Exception {
        Object object;
        if (!this.isToolsRequired) {
            return null;
        }
        IWorkbenchPart iWorkbenchPart = this.system.getPart();
        if (iWorkbenchPart == null || iWorkbenchPart.getAdapter(IToolPageSystem.class) == null) {
            return null;
        }
        final MenuAction menuAction = new MenuAction(toolPageRole.getLabel());
        menuAction.setToolTipText(toolPageRole.getTooltip());
        menuAction.setImageDescriptor(Activator.getImageDescriptor(toolPageRole.getImagePath()));
        menuAction.setId(toolPageRole.getId());
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.dawb.common.ui.toolPage");
        boolean bl = false;
        IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray;
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = iConfigurationElementArray2[n2];
            final IToolPage iToolPage = (IToolPage)object.createExecutableExtension("class");
            if (iToolPage.getToolPageRole() == toolPageRole) {
                String string2;
                bl = true;
                String string3 = object.getAttribute("label");
                iToolPage.setToolSystem(this.system);
                iToolPage.setPlottingSystem(this.system);
                iToolPage.setTitle(string3);
                iToolPage.setPart(this.system.getPart());
                Action action = new Action(string3){

                    public void run() {
                        IViewPart iViewPart = null;
                        try {
                            iViewPart = EclipseUtils.getActivePage().showView(string);
                            if (iViewPart != null && iViewPart instanceof IToolChangeListener) {
                                PlottingActionBarManager.this.system.addToolChangeListener((IToolChangeListener)iViewPart);
                            }
                        }
                        catch (PartInitException partInitException) {
                            logger.error("Cannot find a view with id org.dawb.workbench.plotting.views.ToolPageView", (Throwable)partInitException);
                        }
                        IToolPage iToolPage2 = PlottingActionBarManager.this.system.getCurrentToolPage(toolPageRole);
                        PlottingActionBarManager.this.system.setCurrentToolPage(iToolPage);
                        PlottingActionBarManager.this.system.clearRegionTool();
                        PlottingActionBarManager.this.system.fireToolChangeListeners(new ToolChangeEvent((Object)this, iToolPage2, iToolPage, PlottingActionBarManager.this.system.getPart()));
                        menuAction.setSelectedAction((IAction)this);
                    }
                };
                action.setId(object.getAttribute("id"));
                String string4 = object.getAttribute("icon");
                if (string4 != null) {
                    string2 = object.getContributor().getName();
                    Bundle bundle = Platform.getBundle((String)string2);
                    URL uRL = bundle.getEntry(string4);
                    ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)uRL);
                    action.setImageDescriptor(imageDescriptor);
                    iToolPage.setImageDescriptor(imageDescriptor);
                }
                if ((string2 = object.getAttribute("tooltip")) != null) {
                    action.setToolTipText(string2);
                }
                menuAction.add((IAction)action);
            }
            ++n2;
        }
        if (!bl) {
            return null;
        }
        object = new Action("Clear tool"){

            public void run() {
                IToolPage iToolPage = PlottingActionBarManager.this.system.getCurrentToolPage(toolPageRole);
                PlottingActionBarManager.this.system.setCurrentToolPage(PlottingActionBarManager.this.system.getEmptyTool());
                PlottingActionBarManager.this.system.clearRegionTool();
                PlottingActionBarManager.this.system.fireToolChangeListeners(new ToolChangeEvent((Object)this, iToolPage, PlottingActionBarManager.this.system.getEmptyTool(), PlottingActionBarManager.this.system.getPart()));
                menuAction.setSelectedAction((IAction)this);
            }
        };
        object.setImageDescriptor(Activator.getImageDescriptor("icons/axis.png"));
        object.setToolTipText("Clear tool previously used if any.");
        menuAction.add((IAction)object);
        return menuAction;
    }
}

