/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.common.ui.plot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.dawb.common.services.ISystemService;
import org.dawb.common.ui.plot.EmptyTool;
import org.dawb.common.ui.plot.IAxis;
import org.dawb.common.ui.plot.IPlottingSystem;
import org.dawb.common.ui.plot.PlotType;
import org.dawb.common.ui.plot.PlottingActionBarManager;
import org.dawb.common.ui.plot.PlottingSelectionProvider;
import org.dawb.common.ui.plot.annotation.IAnnotation;
import org.dawb.common.ui.plot.region.IRegion;
import org.dawb.common.ui.plot.region.IRegionListener;
import org.dawb.common.ui.plot.region.RegionEvent;
import org.dawb.common.ui.plot.tool.IToolChangeListener;
import org.dawb.common.ui.plot.tool.IToolPage;
import org.dawb.common.ui.plot.tool.IToolPageSystem;
import org.dawb.common.ui.plot.tool.ToolChangeEvent;
import org.dawb.common.ui.plot.trace.IImageTrace;
import org.dawb.common.ui.plot.trace.ILineTrace;
import org.dawb.common.ui.plot.trace.ITrace;
import org.dawb.common.ui.plot.trace.ITraceListener;
import org.dawb.common.ui.plot.trace.TraceEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;

public abstract class AbstractPlottingSystem
implements IPlottingSystem,
IToolPageSystem {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPlottingSystem.class);
    protected boolean rescale = true;
    protected boolean xfirst = true;
    protected PlottingActionBarManager actionBarManager;
    protected Text pointControls;
    protected ColorOption colorOption = ColorOption.BY_DATA;
    protected String rootName;
    private List<ITraceListener> traceListeners;
    protected IWorkbenchPart part;
    protected PlotType defaultPlotType;
    protected PlottingSelectionProvider selectionProvider;
    private Collection<IRegionListener> regionListeners;
    private Map<IToolPage.ToolPageRole, IToolPage> currentToolPageMap;
    private Collection<IToolChangeListener> toolChangeListeners;
    private EmptyTool emptyTool;

    public AbstractPlottingSystem() {
        this.actionBarManager = this.createActionBarManager();
        this.currentToolPageMap = new HashMap<IToolPage.ToolPageRole, IToolPage>(3);
    }

    public void setPointControls(Text text) {
        this.pointControls = text;
    }

    public void setRootName(String string) {
        this.rootName = string;
    }

    public Color get1DPlotColor(Object object) {
        return null;
    }

    public ColorOption getColorOption() {
        return this.colorOption;
    }

    public void setColorOption(ColorOption colorOption) {
        this.colorOption = colorOption;
    }

    public boolean isRescale() {
        return this.rescale;
    }

    public void setRescale(boolean bl) {
        this.rescale = bl;
    }

    protected PlottingActionBarManager createActionBarManager() {
        return new PlottingActionBarManager(this);
    }

    @Override
    public void dispose() {
        ISystemService iSystemService;
        if (this.part != null && (iSystemService = (ISystemService)PlatformUI.getWorkbench().getService(ISystemService.class)) != null) {
            iSystemService.removeSystem(this.part.getTitle());
            logger.debug("Plotting sytem for '" + this.part.getTitle() + "' removed.");
        }
        this.actionBarManager.dispose();
        if (this.traceListeners != null) {
            this.traceListeners.clear();
        }
        this.traceListeners = null;
        this.pointControls = null;
        if (this.selectionProvider != null) {
            this.selectionProvider.clear();
        }
        this.selectionProvider = null;
        this.currentToolPageMap.clear();
        this.currentToolPageMap = null;
    }

    public void setDefaultPlotType(PlotType plotType) {
    }

    public boolean isXfirst() {
        return this.xfirst;
    }

    public void setXfirst(boolean bl) {
        this.xfirst = bl;
    }

    @Override
    public Collection<ITrace> getTraces() {
        return null;
    }

    @Override
    public void addTraceListener(ITraceListener iTraceListener) {
        if (this.traceListeners == null) {
            this.traceListeners = new ArrayList<ITraceListener>(7);
        }
        this.traceListeners.add(iTraceListener);
    }

    @Override
    public void removeTraceListener(ITraceListener iTraceListener) {
        if (this.traceListeners == null) {
            return;
        }
        this.traceListeners.remove(iTraceListener);
    }

    public void fireTracesAltered(TraceEvent traceEvent) {
        if (this.traceListeners == null) {
            return;
        }
        for (ITraceListener iTraceListener : this.traceListeners) {
            iTraceListener.tracesAltered(traceEvent);
        }
    }

    protected void fireTraceCreated(TraceEvent traceEvent) {
        if (this.traceListeners == null) {
            return;
        }
        for (ITraceListener iTraceListener : this.traceListeners) {
            iTraceListener.traceCreated(traceEvent);
        }
    }

    protected void fireTraceAdded(TraceEvent traceEvent) {
        if (this.traceListeners == null) {
            return;
        }
        for (ITraceListener iTraceListener : this.traceListeners) {
            iTraceListener.traceAdded(traceEvent);
        }
    }

    protected void fireTraceRemoved(TraceEvent traceEvent) {
        if (this.traceListeners == null) {
            return;
        }
        for (ITraceListener iTraceListener : this.traceListeners) {
            iTraceListener.traceRemoved(traceEvent);
        }
    }

    protected void fireTracesCleared(TraceEvent traceEvent) {
        if (this.traceListeners == null) {
            return;
        }
        for (ITraceListener iTraceListener : this.traceListeners) {
            iTraceListener.tracesCleared(traceEvent);
        }
    }

    public void fireTracesPlotted(TraceEvent traceEvent) {
        if (this.traceListeners == null) {
            return;
        }
        for (ITraceListener iTraceListener : this.traceListeners) {
            iTraceListener.tracesPlotted(traceEvent);
        }
    }

    public void setDatasetChoosingRequired(boolean bl) {
    }

    public void setTitle(String string) {
    }

    public Image getImage(Rectangle rectangle) {
        return null;
    }

    @Override
    public void append(String string, Number number, Number number2, IProgressMonitor iProgressMonitor) throws Exception {
        throw new Exception("updatePlot not implemented for " + this.getClass().getName());
    }

    @Override
    public void repaint() {
    }

    @Override
    public void createPlotPart(Composite composite, String string, IActionBars iActionBars, PlotType plotType, IWorkbenchPart iWorkbenchPart) {
        ISystemService iSystemService;
        this.defaultPlotType = plotType;
        this.part = iWorkbenchPart;
        if (iWorkbenchPart != null && (iSystemService = (ISystemService)PlatformUI.getWorkbench().getService(ISystemService.class)) != null) {
            iSystemService.putSystem(iWorkbenchPart.getTitle(), (Object)this);
            logger.debug("Plotting sytem for '" + iWorkbenchPart.getTitle() + "' registered.");
        }
    }

    @Override
    public List<ITrace> createPlot1D(AbstractDataset abstractDataset, List<AbstractDataset> list, IProgressMonitor iProgressMonitor) {
        return this.createPlot(abstractDataset, list, PlotType.PT1D, iProgressMonitor);
    }

    @Override
    public ITrace createPlot2D(AbstractDataset abstractDataset, List<AbstractDataset> list, IProgressMonitor iProgressMonitor) {
        List<ITrace> list2 = this.createPlot(abstractDataset, list, PlotType.IMAGE, iProgressMonitor);
        if (list2 != null) {
            return list2.get(0);
        }
        return null;
    }

    protected abstract List<ITrace> createPlot(AbstractDataset var1, List<AbstractDataset> var2, PlotType var3, IProgressMonitor var4);

    @Override
    public IAxis createAxis(String string, boolean bl, int n) {
        throw new RuntimeException("Cannot create an axis with " + this.getClass().getName());
    }

    @Override
    public IAxis getSelectedYAxis() {
        throw new RuntimeException("Cannot have multiple axes with " + this.getClass().getName());
    }

    @Override
    public void setSelectedYAxis(IAxis iAxis) {
        throw new RuntimeException("Cannot have multiple axes with " + this.getClass().getName());
    }

    @Override
    public IAxis getSelectedXAxis() {
        throw new RuntimeException("Cannot have multiple axes with " + this.getClass().getName());
    }

    @Override
    public void setSelectedXAxis(IAxis iAxis) {
        throw new RuntimeException("Cannot have multiple axes with " + this.getClass().getName());
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        if (this.selectionProvider == null) {
            this.selectionProvider = new PlottingSelectionProvider();
        }
        return this.selectionProvider;
    }

    @Override
    public IRegion createRegion(String string, IRegion.RegionType regionType) throws Exception {
        return null;
    }

    protected void fireRegionCreated(RegionEvent regionEvent) {
        if (this.regionListeners == null) {
            return;
        }
        for (IRegionListener iRegionListener : this.regionListeners) {
            iRegionListener.regionCreated(regionEvent);
        }
    }

    @Override
    public void addRegion(IRegion iRegion) {
        this.fireRegionAdded(new RegionEvent(iRegion));
    }

    protected void fireRegionAdded(RegionEvent regionEvent) {
        if (this.regionListeners == null) {
            return;
        }
        for (IRegionListener iRegionListener : this.regionListeners) {
            iRegionListener.regionAdded(regionEvent);
        }
    }

    @Override
    public void removeRegion(IRegion iRegion) {
        this.fireRegionRemoved(new RegionEvent(iRegion));
    }

    @Override
    public void clearRegions() {
    }

    @Override
    public IRegion getRegion(String string) {
        return null;
    }

    @Override
    public Collection<IRegion> getRegions() {
        return null;
    }

    protected void fireRegionRemoved(RegionEvent regionEvent) {
        if (this.regionListeners == null) {
            return;
        }
        for (IRegionListener iRegionListener : this.regionListeners) {
            iRegionListener.regionRemoved(regionEvent);
        }
    }

    @Override
    public boolean addRegionListener(IRegionListener iRegionListener) {
        if (this.regionListeners == null) {
            this.regionListeners = new HashSet<IRegionListener>(7);
        }
        return this.regionListeners.add(iRegionListener);
    }

    @Override
    public boolean removeRegionListener(IRegionListener iRegionListener) {
        if (this.regionListeners == null) {
            return true;
        }
        return this.regionListeners.remove(iRegionListener);
    }

    @Override
    public IAnnotation createAnnotation(String string) throws Exception {
        return null;
    }

    @Override
    public void addAnnotation(IAnnotation iAnnotation) {
    }

    @Override
    public void removeAnnotation(IAnnotation iAnnotation) {
    }

    @Override
    public IAnnotation getAnnotation(String string) {
        return null;
    }

    @Override
    public void clearAnnotations() {
    }

    @Override
    public IToolPage getCurrentToolPage(IToolPage.ToolPageRole toolPageRole) {
        IToolPage iToolPage = this.currentToolPageMap.get((Object)toolPageRole);
        if (iToolPage == null) {
            iToolPage = this.getEmptyTool();
            this.currentToolPageMap.put(toolPageRole, iToolPage);
        }
        return iToolPage;
    }

    protected void setCurrentToolPage(IToolPage iToolPage) {
        this.currentToolPageMap.put(iToolPage.getToolPageRole(), iToolPage);
    }

    @Override
    public void addToolChangeListener(IToolChangeListener iToolChangeListener) {
        if (this.toolChangeListeners == null) {
            this.toolChangeListeners = new HashSet<IToolChangeListener>(7);
        }
        this.toolChangeListeners.add(iToolChangeListener);
    }

    @Override
    public void removeToolChangeListener(IToolChangeListener iToolChangeListener) {
        if (this.toolChangeListeners == null) {
            return;
        }
        this.toolChangeListeners.remove(iToolChangeListener);
    }

    protected void fireToolChangeListeners(ToolChangeEvent toolChangeEvent) {
        if (this.toolChangeListeners == null) {
            return;
        }
        if (toolChangeEvent.getOldPage() != null) {
            toolChangeEvent.getOldPage().deactivate();
        }
        if (toolChangeEvent.getNewPage() != null) {
            toolChangeEvent.getNewPage().activate();
        }
        for (IToolChangeListener iToolChangeListener : this.toolChangeListeners) {
            iToolChangeListener.toolChanged(toolChangeEvent);
        }
    }

    protected EmptyTool getEmptyTool() {
        if (this.emptyTool == null) {
            this.emptyTool = new EmptyTool();
            this.emptyTool.setToolSystem(this);
            this.emptyTool.setPlottingSystem(this);
            this.emptyTool.setTitle("No tool");
            this.emptyTool.setPart(this.part);
        }
        return this.emptyTool;
    }

    protected void clearRegionTool() {
    }

    @Override
    public ILineTrace createLineTrace(String string) {
        return null;
    }

    @Override
    public IImageTrace createImageTrace(String string) {
        return null;
    }

    @Override
    public ITrace getTrace(String string) {
        return null;
    }

    @Override
    public void addTrace(ITrace iTrace) {
        this.fireTraceAdded(new TraceEvent(iTrace));
    }

    @Override
    public void removeTrace(ITrace iTrace) {
        this.fireTraceRemoved(new TraceEvent(iTrace));
    }

    protected IWorkbenchPart getPart() {
        return this.part;
    }

    @Override
    public boolean is2D() {
        Collection<ITrace> collection = this.getTraces();
        if (collection == null) {
            return false;
        }
        for (ITrace iTrace : collection) {
            if (!(iTrace instanceof IImageTrace)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void autoscaleAxes() {
    }

    @Override
    public Collection<ITrace> getTraces(Class<? extends ITrace> clazz) {
        Collection<ITrace> collection = this.getTraces();
        if (collection == null) {
            return null;
        }
        ArrayList<ITrace> arrayList = new ArrayList<ITrace>();
        for (ITrace iTrace : collection) {
            if (!clazz.isInstance(iTrace)) continue;
            arrayList.add(iTrace);
        }
        return arrayList;
    }

    public static enum ColorOption {
        BY_DATA,
        BY_NAME,
        NONE;

    }
}

