/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.common.ui.menu;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class MenuAction
extends Action
implements IMenuCreator {
    private Menu fMenu;
    private List<IAction> actions;
    private Action selectedAction;

    public MenuAction(String string) {
        super(string, 4);
        this.setMenuCreator(this);
        this.actions = new ArrayList<IAction>(7);
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
    }

    public Menu getMenu(Menu menu) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(menu);
        for (IAction iAction : this.actions) {
            this.addActionToMenu(this.fMenu, iAction);
        }
        return this.fMenu;
    }

    public void add(IAction iAction) {
        this.actions.add(iAction);
    }

    public Menu getMenu(Control control) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(control);
        for (IAction iAction : this.actions) {
            this.addActionToMenu(this.fMenu, iAction);
        }
        return this.fMenu;
    }

    protected void addActionToMenu(Menu menu, IAction iAction) {
        ActionContributionItem actionContributionItem = new ActionContributionItem(iAction);
        actionContributionItem.fill(menu, -1);
    }

    public void clear() {
        this.actions.clear();
    }

    public void setSelectedAction(int n) {
        this.setSelectedAction(this.actions.get(n));
    }

    public void setCheckedAction(int n, boolean bl) {
        this.actions.get(n).setChecked(bl);
    }

    public IAction getAction(int n) {
        return this.actions.get(n);
    }

    public void setSelectedAction(IAction iAction) {
        if (iAction.getImageDescriptor() != null) {
            this.setImageDescriptor(iAction.getImageDescriptor());
        }
        this.setText(iAction.getText());
        this.selectedAction = (Action)iAction;
    }

    public void run() {
        if (this.selectedAction != null) {
            this.selectedAction.run();
        }
    }
}

