/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyClass;
import org.python.core.PyComplex;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PyTuple;

public class PyFloat
extends PyObject {
    public static PyClass __class__;
    private double value;
    private static /* synthetic */ Class class$Ljava$lang$Number;
    private static /* synthetic */ Class class$Ljava$lang$Double;
    private static /* synthetic */ Class class$Ljava$lang$Object;
    private static /* synthetic */ Class class$Ljava$io$Serializable;
    private static /* synthetic */ Class class$Ljava$lang$Float;

    public String safeRepr() throws PyIgnoreMethodTag {
        return "'float' object";
    }

    public double getValue() {
        return this.value;
    }

    public String toString() {
        String s = Double.toString(this.value);
        if (s.indexOf(69) == -1) {
            int n;
            while ((n = s.length()) > 2 && s.charAt(n - 1) == '0' && s.charAt(n - 2) != '.') {
                s = s.substring(0, n - 1);
            }
        }
        return s;
    }

    public int hashCode() {
        double intPart = Math.floor(this.value);
        double fractPart = this.value - intPart;
        if (fractPart == 0.0) {
            if (intPart <= 2.147483647E9 && intPart >= -2.147483648E9) {
                return (int)this.value;
            }
            return this.__long__().hashCode();
        }
        long v = Double.doubleToLongBits(this.value);
        return (int)v ^ (int)(v >> 32);
    }

    public boolean __nonzero__() {
        return this.value != 0.0;
    }

    public Object __tojava__(Class c) {
        if (c == Double.TYPE || c == (class$Ljava$lang$Number != null ? class$Ljava$lang$Number : (class$Ljava$lang$Number = PyFloat.class$("java.lang.Number"))) || c == (class$Ljava$lang$Double != null ? class$Ljava$lang$Double : (class$Ljava$lang$Double = PyFloat.class$("java.lang.Double"))) || c == (class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = PyFloat.class$("java.lang.Object"))) || c == (class$Ljava$io$Serializable != null ? class$Ljava$io$Serializable : (class$Ljava$io$Serializable = PyFloat.class$("java.io.Serializable")))) {
            return new Double(this.value);
        }
        if (c == Float.TYPE || c == (class$Ljava$lang$Float != null ? class$Ljava$lang$Float : (class$Ljava$lang$Float = PyFloat.class$("java.lang.Float")))) {
            return new Float(this.value);
        }
        return super.__tojava__(c);
    }

    public int __cmp__(PyObject other) {
        double v = ((PyFloat)other).value;
        return this.value < v ? -1 : (this.value > v ? 1 : 0);
    }

    public Object __coerce_ex__(PyObject other) {
        if (other instanceof PyFloat) {
            return other;
        }
        if (other instanceof PyInteger) {
            return new PyFloat((double)((PyInteger)other).getValue());
        }
        if (other instanceof PyLong) {
            return new PyFloat(((PyLong)other).doubleValue());
        }
        return Py.None;
    }

    private static final boolean canCoerce(PyObject other) {
        return other instanceof PyFloat || other instanceof PyInteger || other instanceof PyLong;
    }

    private static final double coerce(PyObject other) {
        if (other instanceof PyFloat) {
            return ((PyFloat)other).value;
        }
        if (other instanceof PyInteger) {
            return ((PyInteger)other).getValue();
        }
        if (other instanceof PyLong) {
            return ((PyLong)other).doubleValue();
        }
        throw Py.TypeError("xxx");
    }

    public PyObject __add__(PyObject right) {
        if (!PyFloat.canCoerce(right)) {
            return null;
        }
        double rightv = PyFloat.coerce(right);
        return new PyFloat(this.value + rightv);
    }

    public PyObject __radd__(PyObject left) {
        return this.__add__(left);
    }

    public PyObject __sub__(PyObject right) {
        if (!PyFloat.canCoerce(right)) {
            return null;
        }
        double rightv = PyFloat.coerce(right);
        return new PyFloat(this.value - rightv);
    }

    public PyObject __rsub__(PyObject left) {
        if (!PyFloat.canCoerce(left)) {
            return null;
        }
        double leftv = PyFloat.coerce(left);
        return new PyFloat(leftv - this.value);
    }

    public PyObject __mul__(PyObject right) {
        if (!PyFloat.canCoerce(right)) {
            return null;
        }
        double rightv = PyFloat.coerce(right);
        return new PyFloat(this.value * rightv);
    }

    public PyObject __rmul__(PyObject left) {
        return this.__mul__(left);
    }

    public PyObject __div__(PyObject right) {
        if (!PyFloat.canCoerce(right)) {
            return null;
        }
        double rightv = PyFloat.coerce(right);
        if (rightv == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        return new PyFloat(this.value / rightv);
    }

    public PyObject __rdiv__(PyObject left) {
        if (!PyFloat.canCoerce(left)) {
            return null;
        }
        double leftv = PyFloat.coerce(left);
        if (this.value == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        return new PyFloat(leftv / this.value);
    }

    private static final double modulo(double x, double y) {
        if (y == 0.0) {
            throw Py.ZeroDivisionError("float modulo");
        }
        double z = Math.IEEEremainder(x, y);
        if (z * y < 0.0) {
            z += y;
        }
        return z;
    }

    public PyObject __mod__(PyObject right) {
        if (!PyFloat.canCoerce(right)) {
            return null;
        }
        double rightv = PyFloat.coerce(right);
        return new PyFloat(PyFloat.modulo(this.value, rightv));
    }

    public PyObject __rmod__(PyObject left) {
        if (!PyFloat.canCoerce(left)) {
            return null;
        }
        double leftv = PyFloat.coerce(left);
        return new PyFloat(PyFloat.modulo(leftv, this.value));
    }

    public PyObject __divmod__(PyObject right) {
        if (!PyFloat.canCoerce(right)) {
            return null;
        }
        double rightv = PyFloat.coerce(right);
        if (rightv == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        double z = Math.floor(this.value / rightv);
        return new PyTuple(new PyObject[]{new PyFloat(z), new PyFloat(this.value - z * rightv)});
    }

    public PyObject __rdivmod__(PyObject left) {
        if (!PyFloat.canCoerce(left)) {
            return null;
        }
        double leftv = PyFloat.coerce(left);
        if (this.value == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        double z = Math.floor(leftv / this.value);
        return new PyTuple(new PyObject[]{new PyFloat(z), new PyFloat(leftv - z * this.value)});
    }

    public PyObject __pow__(PyObject right, PyObject modulo) {
        if (!PyFloat.canCoerce(right)) {
            return null;
        }
        if (modulo != null && !PyFloat.canCoerce(modulo)) {
            return null;
        }
        return PyFloat._pow(this.value, PyFloat.coerce(right), modulo);
    }

    public PyObject __rpow__(PyObject left) {
        if (!PyFloat.canCoerce(left)) {
            return null;
        }
        return PyFloat._pow(PyFloat.coerce(left), this.value, null);
    }

    private static final PyFloat _pow(double value, double iw, PyObject modulo) {
        if (iw == 0.0) {
            if (modulo != null) {
                return new PyFloat(PyFloat.modulo(1.0, PyFloat.coerce(modulo)));
            }
            return new PyFloat(1.0);
        }
        if (value == 0.0) {
            if (iw < 0.0) {
                throw Py.ZeroDivisionError("0.0 cannot be raised to a negative power");
            }
            return new PyFloat(0.0f);
        }
        double ret = Math.pow(value, iw);
        if (modulo == null) {
            return new PyFloat(ret);
        }
        return new PyFloat(PyFloat.modulo(ret, PyFloat.coerce(modulo)));
    }

    public PyObject __neg__() {
        return new PyFloat(-this.value);
    }

    public PyObject __pos__() {
        return this;
    }

    public PyObject __abs__() {
        if (this.value >= 0.0) {
            return this;
        }
        return this.__neg__();
    }

    public PyInteger __int__() {
        if (this.value <= 2.147483647E9 && this.value >= -2.147483648E9) {
            return new PyInteger((int)this.value);
        }
        throw Py.OverflowError("float too large to convert");
    }

    public PyLong __long__() {
        return new PyLong(this.value);
    }

    public PyFloat __float__() {
        return this;
    }

    public PyComplex __complex__() {
        return new PyComplex(this.value, 0.0);
    }

    public boolean isMappingType() {
        return false;
    }

    public boolean isSequenceType() {
        return false;
    }

    protected PyClass getPyClass() {
        return __class__;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public PyFloat(double v) {
        this.value = v;
    }

    public PyFloat(float v) {
        this((double)v);
    }
}

