/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.views;

import fable.framework.toolbox.FableUtils;
import fable.imageviewer.views.IImageSizeProvider;
import fable.imageviewer.views.ReliefView;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.opengl.GLCanvas;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SceneGrip
extends MouseAdapter
implements MouseMoveListener,
Listener,
KeyListener {
    private static Logger logger = LoggerFactory.getLogger(SceneGrip.class);
    private int canvasWidth = 0;
    private int canvasHeight = 0;
    private GLCanvas canvas;
    private float xrot;
    private float yrot;
    private float zoff;
    private float xoff;
    private float yoff;
    private float xcpy;
    private float ycpy;
    private float xscale;
    private float yscale;
    private boolean move;
    private int xdown;
    private int ydown;
    private int mouseDown;
    private IImageSizeProvider prov;

    public SceneGrip(GLCanvas gLCanvas, IImageSizeProvider iImageSizeProvider) {
        this.canvas = gLCanvas;
        this.prov = iImageSizeProvider;
        this.init();
    }

    protected void init() {
        this.canvas.setCurrent();
        Rectangle rectangle = this.canvas.getBounds();
        this.canvasWidth = rectangle.width;
        this.canvasHeight = rectangle.height;
        this.yrot = 0.0f;
        this.xrot = 0.0f;
        this.yoff = 0.0f;
        this.xoff = 0.0f;
        if (this.prov.getImageWidth() != 0) {
            this.xscale = this.canvasWidth / this.prov.getImageWidth();
        }
        if (this.prov.getImageHeight() != 0) {
            this.yscale = this.canvasHeight / this.prov.getImageHeight();
        }
        this.zoff = 1.0f;
        this.zoff = this.xscale < this.yscale ? this.xscale : this.yscale;
        logger.debug("xscale = " + this.xscale + " yscale = " + this.yscale + " zoff = " + this.zoff);
    }

    public void mouseDown(MouseEvent mouseEvent) {
        if (++this.mouseDown == 1) {
            this.move = mouseEvent.button == 3;
            if (this.move) {
                this.xcpy = this.xoff;
                this.ycpy = this.yoff;
                ((Control)mouseEvent.widget).setCursor(mouseEvent.widget.getDisplay().getSystemCursor(21));
            } else {
                this.xcpy = this.xrot;
                this.ycpy = this.yrot;
                ((Control)mouseEvent.widget).setCursor(mouseEvent.widget.getDisplay().getSystemCursor(5));
            }
            this.xdown = mouseEvent.x;
            this.ydown = mouseEvent.y;
        }
    }

    public void mouseUp(MouseEvent mouseEvent) {
        if (--this.mouseDown == 0) {
            ((Control)mouseEvent.widget).setCursor(mouseEvent.widget.getDisplay().getSystemCursor(0));
        }
    }

    public void mouseMove(MouseEvent mouseEvent) {
        Point point = ((Control)mouseEvent.widget).getSize();
        if (this.mouseDown > 0) {
            int n = mouseEvent.x - this.xdown;
            int n2 = mouseEvent.y - this.ydown;
            if (this.move) {
                this.yoff = this.ycpy + (float)this.canvasHeight / 2.0f * (float)n2 / (2.0f * (float)point.y);
                this.xoff = this.xcpy + (float)this.canvasWidth / 2.0f * (float)n / (2.0f * (float)point.x);
            } else {
                this.xrot = this.xcpy + (float)n2 / 2.0f;
                this.yrot = this.ycpy + (float)n / 2.0f;
            }
        }
    }

    public void handleEvent(Event event) {
        this.zoff *= 1.1f;
    }

    public void zoomIn() {
        this.zoff *= 1.05f;
    }

    public void zoomOut() {
        this.zoff *= 0.95f;
    }

    public void rotate(int n) {
        switch (n) {
            case 0x1000001: {
                this.xrot -= 5.0f;
                break;
            }
            case 0x1000002: {
                this.xrot += 5.0f;
                break;
            }
            case 0x1000003: {
                this.yrot += 5.0f;
                break;
            }
            case 0x1000004: {
                this.yrot -= 5.0f;
                break;
            }
            default: {
                return;
            }
        }
    }

    public void translate(int n) {
        switch (n) {
            case 0x1000001: {
                this.yoff -= (float)this.canvasHeight / 10.0f;
                break;
            }
            case 0x1000002: {
                this.yoff += (float)this.canvasHeight / 10.0f;
                break;
            }
            case 0x1000003: {
                this.xoff -= (float)this.canvasWidth / 10.0f;
                break;
            }
            case 0x1000004: {
                this.xoff += (float)this.canvasWidth / 10.0f;
                break;
            }
            default: {
                return;
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if ((keyEvent.stateMask & 0x40000) != 0) {
            this.rotate(keyEvent.keyCode);
            return;
        }
        this.translate(keyEvent.keyCode);
        switch (keyEvent.keyCode) {
            case 0x1000005: {
                this.zoomIn();
                break;
            }
            case 0x1000006: {
                this.zoomOut();
                break;
            }
            case 0x1000007: {
                this.init();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void adjust() {
        this.canvas.setCurrent();
        try {
            GLContext.useContext((Object)this.canvas);
        }
        catch (LWJGLException lWJGLException) {
            FableUtils.excMsg(ReliefView.class, (String)"Error in adjust using GLContext.useContext", (Throwable)lWJGLException);
        }
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)this.canvasWidth, (double)this.canvasHeight, (double)0.0, (double)-100000.0, (double)100000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)((float)(this.canvasWidth / 2) + this.xoff), (float)((float)(this.canvasHeight / 2) + this.yoff), (float)0.0f);
        GL11.glScalef((float)this.zoff, (float)this.zoff, (float)this.zoff);
        GL11.glRotatef((float)this.xrot, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)this.yrot, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)(-this.prov.getImageWidth() / 2), (float)(-this.prov.getImageHeight() / 2), (float)0.0f);
    }

    public void setOffsets(float f, float f2, float f3) {
        this.xoff = f;
        this.yoff = f2;
        this.zoff = f3;
    }

    public void setRotation(float f, float f2) {
        this.xrot = f;
        this.yrot = f2;
    }

    public void setBounds(Rectangle rectangle) {
        this.canvasWidth = rectangle.width;
        this.canvasHeight = rectangle.height;
    }
}

