/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.views;

import fable.framework.toolbox.FableUtils;
import fable.framework.toolbox.GridUtils;
import fable.imageviewer.rcp.Activator;
import fable.imageviewer.views.IImageSizeProvider;
import fable.imageviewer.views.SceneGrip;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.opengl.GLCanvas;
import org.eclipse.swt.opengl.GLData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.part.ViewPart;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.glu.GLU;

public class ReliefView
extends ViewPart
implements IImageSizeProvider {
    public static final String ID = "fable.imageviewer.views.ReliefView";
    private static float[] blue = new float[]{1.0f, 0.333f, 0.666f, 0.999f, 0.833f, 0.666f, 0.5f, 0.333f, 0.166f, 0.0f, 0.0f};
    private static float[] green = new float[]{1.0f, 0.0f, 0.111f, 0.222f, 0.333f, 0.666f, 0.999f, 0.666f, 0.333f, 0.0f, 0.0f};
    private static float[] red = new float[]{1.0f, 0.0f, 0.055f, 0.11f, 0.165f, 0.22f, 0.275f, 0.333f, 0.666f, 0.999f, 1.0f};
    public ReliefView thisView = null;
    public GLContext context;
    public GLU glu = new GLU();
    private SceneGrip grip;
    private GLCanvas canvas;
    private Spinner minimumSpinner;
    private Spinner maximumSpinner;
    private Action freezeButton;
    private Action autoscaleButton;
    private boolean freeze = false;
    private boolean autoscale = true;
    private Action updateButton;
    private Action highZReset;
    private int colorIndexMax = 10;
    private float scaleMinimum;
    private float scaleMaximum;
    private int pointSize = 4;
    private float[] image = null;
    private float[] imageAsFloat = null;
    private float minimum;
    private float mean;
    private String fileName;
    private float zscale;
    private boolean reliefListFirst = true;
    private int reliefList;
    private boolean firstImage = true;
    private int imageWidth = 0;
    private int imageHeight = 0;

    private void drawRelief() {
        this.canvas.setCurrent();
        try {
            GLContext.useContext((Object)this.canvas);
        }
        catch (LWJGLException lWJGLException) {
            FableUtils.excMsg(ReliefView.class, (String)"Error in drawRelief using GLContext.useContext", (Throwable)lWJGLException);
        }
        GL11.glClear((int)16640);
        if (!this.freeze) {
            this.grip.adjust();
        }
        if (this.image != null) {
            GL11.glClear((int)16640);
            GL11.glDisable((int)2896);
            GL11.glCallList((int)this.reliefList);
            GL11.glEnable((int)2896);
        }
    }

    private void drawReliefList() {
        int n;
        int n2;
        if (!this.reliefListFirst) {
            GL11.glDeleteLists((int)this.reliefList, (int)1);
        }
        this.reliefListFirst = false;
        this.reliefList = GL11.glGenLists((int)1);
        GL11.glNewList((int)this.reliefList, (int)4864);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPointSize((float)this.pointSize);
        int n3 = 0;
        while (n3 < this.imageWidth) {
            GL11.glBegin((int)3);
            n2 = 0;
            while (n2 < this.imageHeight) {
                n = (int)this.image[n2 * this.imageWidth + n3];
                if (n < 0) {
                    n = 0;
                }
                if (n > this.colorIndexMax) {
                    n = this.colorIndexMax;
                }
                GL11.glColor3f((float)red[n], (float)green[n], (float)blue[n]);
                GL11.glVertex3f((float)n3, (float)n2, (float)this.image[n2 * this.imageWidth + n3]);
                ++n2;
            }
            GL11.glEnd();
            ++n3;
        }
        n3 = 0;
        while (n3 < this.imageHeight) {
            GL11.glBegin((int)3);
            n2 = 0;
            while (n2 < this.imageWidth) {
                n = (int)this.image[n3 * this.imageWidth + n2];
                if (n < 0) {
                    n = 0;
                }
                if (n > this.colorIndexMax) {
                    n = this.colorIndexMax;
                }
                GL11.glColor3f((float)red[n], (float)green[n], (float)blue[n]);
                GL11.glVertex3f((float)n2, (float)n3, (float)this.image[n3 * this.imageWidth + n2]);
                ++n2;
            }
            GL11.glEnd();
            ++n3;
        }
        GL11.glEndList();
    }

    public void setImageAsFloat(float[] fArray, int n, int n2, float f, float f2, float f3, String string) {
        this.imageAsFloat = fArray;
        this.image = new float[n * n2];
        this.imageWidth = n;
        this.imageHeight = n2;
        this.minimum = f;
        this.mean = f3;
        if (this.autoscale) {
            this.scaleMinimum = f;
            this.scaleMaximum = f3;
        }
        this.fileName = string;
        this.setPartName("Relief " + this.fileName);
        if (this.firstImage) {
            this.grip.init();
            this.firstImage = false;
        }
        this.scaleImage();
        this.drawReliefList();
        this.drawRelief();
    }

    public void scaleImage() {
        if (this.autoscale) {
            this.scaleMinimum = this.minimum;
            this.scaleMaximum = this.mean;
            this.minimumSpinner.setSelection((int)this.scaleMinimum);
            this.maximumSpinner.setSelection((int)this.scaleMaximum);
        } else {
            this.scaleMinimum = this.minimumSpinner.getSelection();
            this.scaleMaximum = this.maximumSpinner.getSelection();
        }
        if (this.scaleMinimum == this.scaleMaximum) {
            this.scaleMaximum = this.scaleMinimum + 1.0f;
        }
        this.zscale = 10.0f / (2.0f * (this.scaleMaximum - this.scaleMinimum));
        int n = 0;
        while (n < this.imageWidth) {
            int n2 = 0;
            while (n2 < this.imageHeight) {
                int n3 = n2 * this.imageWidth + n;
                float f = this.imageAsFloat[n2 * this.imageWidth + n];
                this.image[n3] = (f - this.scaleMinimum) * this.zscale;
                ++n2;
            }
            ++n;
        }
    }

    public void createPartControl(Composite composite) {
        this.thisView = this;
        composite.setLayout((Layout)new GridLayout(1, false));
        GridUtils.removeMargins((Composite)composite);
        this.createActions();
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        composite2.setLayout((Layout)new FillLayout());
        GLData gLData = new GLData();
        gLData.doubleBuffer = true;
        this.canvas = new GLCanvas(composite2, 0, gLData);
        this.canvas.setSize(composite2.getSize());
        this.canvas.setCurrent();
        try {
            GLContext.useContext((Object)this.canvas);
        }
        catch (LWJGLException lWJGLException) {
            FableUtils.excMsg(ReliefView.class, (String)"Error in createPartControl using GLContext.useContext", (Throwable)lWJGLException);
        }
        this.canvas.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Rectangle rectangle = ReliefView.this.canvas.getBounds();
                ReliefView.this.canvas.setCurrent();
                try {
                    GLContext.useContext((Object)ReliefView.this.canvas);
                }
                catch (LWJGLException lWJGLException) {
                    FableUtils.excMsg(ReliefView.class, (String)"Error in resize listener using GLContext.useContext", (Throwable)lWJGLException);
                }
                GL11.glViewport((int)0, (int)0, (int)rectangle.width, (int)rectangle.height);
                GL11.glMatrixMode((int)5889);
                GL11.glLoadIdentity();
                GL11.glMatrixMode((int)5888);
                GL11.glLoadIdentity();
                ReliefView.this.drawRelief();
                ReliefView.this.canvas.swapBuffers();
            }
        });
        this.canvas.setCurrent();
        try {
            GLContext.useContext((Object)this.canvas);
        }
        catch (LWJGLException lWJGLException) {
            FableUtils.excMsg(ReliefView.class, (String)"Error in createPartControl using GLContext.useContext", (Throwable)lWJGLException);
        }
        GL11.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glHint((int)3152, (int)4354);
        GL11.glClearDepth((double)1.0);
        GL11.glLineWidth((float)2.0f);
        GL11.glEnable((int)2929);
        this.grip = new SceneGrip(this.canvas, this);
        this.canvas.addMouseListener((MouseListener)this.grip);
        this.canvas.addMouseMoveListener((MouseMoveListener)this.grip);
        this.canvas.addListener(37, (Listener)this.grip);
        this.canvas.addKeyListener((KeyListener)this.grip);
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ReliefView.this.canvas == null) {
                    return;
                }
                if (!ReliefView.this.canvas.isDisposed()) {
                    ReliefView.this.canvas.setCurrent();
                    Rectangle rectangle = ReliefView.this.canvas.getBounds();
                    ReliefView.this.grip.setBounds(rectangle);
                    ReliefView.this.canvas.setCurrent();
                    try {
                        GLContext.useContext((Object)ReliefView.this.canvas);
                    }
                    catch (LWJGLException lWJGLException) {
                        FableUtils.excMsg(ReliefView.class, (String)"Error in createPartControl using GLContext.useContext", (Throwable)lWJGLException);
                    }
                    GL11.glClear((int)16640);
                    GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    ReliefView.this.drawRelief();
                    ReliefView.this.canvas.swapBuffers();
                    Display.getCurrent().timerExec(200, (Runnable)this);
                }
            }
        });
        this.createImageInformationPanel(composite);
    }

    public void dispose() {
        super.dispose();
        this.canvas = null;
    }

    private void createImageInformationPanel(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(4, false));
        composite2.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        Label label = new Label(composite2, 0);
        label.setText("Minimum");
        this.minimumSpinner = new Spinner(composite2, 0);
        this.minimumSpinner.setLayoutData((Object)new GridData(4, 0, true, false));
        this.minimumSpinner.setMinimum(0);
        this.minimumSpinner.setMaximum(Integer.MAX_VALUE);
        this.minimumSpinner.setEnabled(false);
        Label label2 = new Label(composite2, 0);
        label2.setText("Maximum");
        this.maximumSpinner = new Spinner(composite2, 0);
        this.maximumSpinner.setLayoutData((Object)new GridData(4, 0, true, false));
        this.maximumSpinner.setMinimum(0);
        this.maximumSpinner.setMaximum(Integer.MAX_VALUE);
        this.maximumSpinner.setEnabled(false);
    }

    private void createActions() {
        IToolBarManager iToolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        this.freezeButton = new Action("Freeze", 2){

            public void run() {
                ReliefView.this.freeze = ReliefView.this.freezeButton.isChecked();
            }
        };
        this.freezeButton.setToolTipText("Freeze 3d relief, disable rotation");
        this.freezeButton.setImageDescriptor(Activator.getImageDescriptor("/icons/freeze.png"));
        iToolBarManager.add((IAction)this.freezeButton);
        iToolBarManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + ".zoom"));
        Action action = new Action("Zoom In", 1){

            public void run() {
                ReliefView.this.grip.zoomIn();
            }
        };
        action.setToolTipText("Zoom in (Page Up)");
        action.setImageDescriptor(Activator.getImageDescriptor("/icons/magnifier_zoom_in.png"));
        iToolBarManager.add((IAction)action);
        Action action2 = new Action("Zoom Out", 1){

            public void run() {
                ReliefView.this.grip.zoomOut();
            }
        };
        action2.setToolTipText("Zoom out (Page Down)");
        action2.setImageDescriptor(Activator.getImageDescriptor("/icons/magnifier_zoom_out.png"));
        iToolBarManager.add((IAction)action2);
        iToolBarManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + ".translate"));
        Action action3 = new Action("Translate up", 1){

            public void run() {
                ReliefView.this.grip.translate(0x1000001);
            }
        };
        action3.setToolTipText("Translate up (Up Arrow)");
        action3.setImageDescriptor(Activator.getImageDescriptor("/icons/arrow_up.png"));
        iToolBarManager.add((IAction)action3);
        action3 = new Action("Translate down", 1){

            public void run() {
                ReliefView.this.grip.translate(0x1000002);
            }
        };
        action3.setToolTipText("Translate down (Down Arrow)");
        action3.setImageDescriptor(Activator.getImageDescriptor("/icons/arrow_down.png"));
        iToolBarManager.add((IAction)action3);
        action3 = new Action("Translate left", 1){

            public void run() {
                ReliefView.this.grip.translate(0x1000003);
            }
        };
        action3.setToolTipText("Translate left (Left Arrow)");
        action3.setImageDescriptor(Activator.getImageDescriptor("/icons/arrow_left.png"));
        iToolBarManager.add((IAction)action3);
        action3 = new Action("Translate right", 1){

            public void run() {
                ReliefView.this.grip.translate(0x1000004);
            }
        };
        action3.setToolTipText("Translate right (Right Arrow)");
        action3.setImageDescriptor(Activator.getImageDescriptor("/icons/arrow_right.png"));
        iToolBarManager.add((IAction)action3);
        iToolBarManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + ".rotate"));
        action3 = new Action("Rotate X, high Y", 1){

            public void run() {
                ReliefView.this.grip.rotate(0x1000001);
            }
        };
        action3.setToolTipText("Rotate X, high Y (Control + Up Arrow)");
        action3.setImageDescriptor(Activator.getImageDescriptor("/icons/rotate_up.png"));
        iToolBarManager.add((IAction)action3);
        action3 = new Action("Rotate X, low Y", 1){

            public void run() {
                ReliefView.this.grip.rotate(0x1000002);
            }
        };
        action3.setToolTipText("Rotate X, low Y (Contol + Down Arrow)");
        action3.setImageDescriptor(Activator.getImageDescriptor("/icons/rotate_down.png"));
        iToolBarManager.add((IAction)action3);
        action3 = new Action("Rotate Y, low X", 1){

            public void run() {
                ReliefView.this.grip.rotate(0x1000003);
            }
        };
        action3.setToolTipText("Rotate Y, low X (Control + Left Arrow)");
        action3.setImageDescriptor(Activator.getImageDescriptor("/icons/rotate_left.png"));
        iToolBarManager.add((IAction)action3);
        action3 = new Action("Rotate Y, high X", 1){

            public void run() {
                ReliefView.this.grip.rotate(0x1000004);
            }
        };
        action3.setToolTipText("Rotate Y, high X (Control + Right Arrow)");
        action3.setImageDescriptor(Activator.getImageDescriptor("/icons/rotate_right.png"));
        iToolBarManager.add((IAction)action3);
        iToolBarManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + ".reset"));
        this.highZReset = new Action("Reset", 1){

            public void run() {
                ReliefView.this.grip.init();
            }
        };
        this.highZReset.setText("Reset");
        this.highZReset.setToolTipText("Reset 3d projection to be flat and fill the canvas and use X/Y view.");
        this.highZReset.setImageDescriptor(Activator.getImageDescriptor("/icons/z-high.png"));
        iToolBarManager.add((IAction)this.highZReset);
        this.autoscaleButton = new Action("Autoscale", 2){

            public void run() {
                if (ReliefView.this.autoscaleButton.isChecked()) {
                    if (!ReliefView.this.autoscale) {
                        ReliefView.this.autoscale = true;
                        ReliefView.this.scaleImage();
                        ReliefView.this.drawReliefList();
                    }
                    ReliefView.this.minimumSpinner.setEnabled(false);
                    ReliefView.this.maximumSpinner.setEnabled(false);
                } else {
                    if (ReliefView.this.autoscale) {
                        ReliefView.this.autoscale = false;
                        ReliefView.this.scaleImage();
                        ReliefView.this.drawReliefList();
                    }
                    ReliefView.this.minimumSpinner.setEnabled(true);
                    ReliefView.this.maximumSpinner.setEnabled(true);
                }
            }
        };
        this.autoscaleButton.setText("Autoscale");
        this.autoscaleButton.setToolTipText("Autoscale 3d relief between minimum and mean");
        this.autoscaleButton.setImageDescriptor(Activator.getImageDescriptor("/icons/autoscale.png"));
        this.autoscaleButton.setChecked(true);
        iToolBarManager.add((IAction)this.autoscaleButton);
        this.updateButton = new Action("Refresh", 1){

            public void run() {
                ReliefView.this.scaleImage();
                ReliefView.this.drawReliefList();
                ReliefView.this.drawRelief();
            }
        };
        this.updateButton.setText("Refresh");
        this.updateButton.setToolTipText("Redraw 3d relief plot");
        this.updateButton.setImageDescriptor(Activator.getImageDescriptor("/icons/update.png"));
        iToolBarManager.add((IAction)this.updateButton);
    }

    public void setFocus() {
        if (this.canvas != null && !this.canvas.isDisposed()) {
            try {
                this.canvas.setFocus();
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public int getImageWidth() {
        return this.imageWidth;
    }

    @Override
    public int getImageHeight() {
        return this.imageHeight;
    }
}

