/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.views;

import fable.framework.navigator.controller.SampleController;
import java.util.ArrayList;
import org.dawb.common.ui.plot.AbstractPlottingSystem;
import org.dawb.common.ui.plot.PlotType;
import org.dawb.common.ui.plot.PlottingFactory;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;

public class ProfileView
extends ViewPart {
    public static final String ID = "fable.imageviewer.views.ProfileView";
    public static ProfileView view;
    public SampleController controller = SampleController.getController();
    private static final Logger logger;
    private AbstractPlottingSystem plottingSystem_x;
    private AbstractPlottingSystem plottingSystem_y;
    private String title = "Profile Line Plot";

    static {
        logger = LoggerFactory.getLogger(ProfileView.class);
    }

    public ProfileView() {
        try {
            this.plottingSystem_x = PlottingFactory.getPlottingSystem();
            this.plottingSystem_x.setColorOption(AbstractPlottingSystem.ColorOption.NONE);
            this.plottingSystem_x.setDatasetChoosingRequired(false);
            this.plottingSystem_y = PlottingFactory.getPlottingSystem();
            this.plottingSystem_y.setColorOption(AbstractPlottingSystem.ColorOption.NONE);
            this.plottingSystem_y.setDatasetChoosingRequired(false);
        }
        catch (Exception exception) {
            logger.error("Cannot locate any plotting systems!", (Throwable)exception);
        }
    }

    public void createPartControl(Composite composite) {
        view = this;
        composite.setLayout((Layout)new GridLayout());
        Composite composite2 = new Composite(composite, 0);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 512;
        composite2.setLayout((Layout)fillLayout);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        try {
            IActionBars iActionBars = this.getViewSite().getActionBars();
            this.plottingSystem_x.createPlotPart(composite2, this.title, iActionBars, PlotType.PT1D, (IWorkbenchPart)this);
            this.plottingSystem_y.createPlotPart(composite2, this.title, iActionBars, PlotType.PT1D, (IWorkbenchPart)this);
            iActionBars.getToolBarManager().removeAll();
            iActionBars.getMenuManager().removeAll();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setFocus() {
    }

    public void setData(String string, String string2, String string3, boolean bl, boolean bl2, float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        double[] dArray = new double[fArray.length];
        double[] dArray2 = new double[fArray.length];
        int n = 0;
        while (n < fArray.length) {
            dArray[n] = fArray[n];
            dArray2[n] = bl ? (double)fArray2[fArray.length - 1 - n] : (double)fArray2[n];
            ++n;
        }
        DoubleDataset doubleDataset = new DoubleDataset(dArray, new int[]{fArray.length});
        DoubleDataset doubleDataset2 = new DoubleDataset(dArray2, new int[]{fArray.length});
        doubleDataset.setName("X pixel");
        doubleDataset2.setName("Intensity");
        ArrayList<DoubleDataset> arrayList = new ArrayList<DoubleDataset>(1);
        arrayList.add(doubleDataset2);
        this.plottingSystem_x.clear();
        this.plottingSystem_x.createPlot1D((AbstractDataset)doubleDataset, arrayList, null);
        double[] dArray3 = new double[fArray3.length];
        double[] dArray4 = new double[fArray3.length];
        int n2 = 0;
        while (n2 < fArray3.length) {
            dArray3[n2] = fArray3[n2];
            dArray4[n2] = bl2 ? (double)fArray4[fArray3.length - 1 - n2] : (double)fArray4[n2];
            ++n2;
        }
        DoubleDataset doubleDataset3 = new DoubleDataset(dArray3, new int[]{fArray3.length});
        DoubleDataset doubleDataset4 = new DoubleDataset(dArray4, new int[]{fArray3.length});
        doubleDataset3.setName("Y pixel");
        doubleDataset4.setName("Intensity");
        ArrayList<DoubleDataset> arrayList2 = new ArrayList<DoubleDataset>(1);
        arrayList2.add(doubleDataset4);
        this.plottingSystem_y.createPlot1D((AbstractDataset)doubleDataset3, arrayList2, null);
    }
}

