/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.views;

import fable.framework.navigator.controller.SampleController;
import java.util.ArrayList;
import org.dawb.common.ui.plot.AbstractPlottingSystem;
import org.dawb.common.ui.plot.PlotType;
import org.dawb.common.ui.plot.PlottingFactory;
import org.dawb.common.ui.plot.tool.IToolPageSystem;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;

public class LineView
extends ViewPart {
    public static final String ID = "fable.imageviewer.views.LineView";
    private AbstractPlottingSystem plottingSystem;
    public static LineView view;
    private String title = "Zoom Line Plot";
    public SampleController controller = SampleController.getController();
    private static final Logger logger;
    Composite parent;

    static {
        logger = LoggerFactory.getLogger(LineView.class);
    }

    public LineView() {
        try {
            this.plottingSystem = PlottingFactory.getPlottingSystem();
            this.plottingSystem.setColorOption(AbstractPlottingSystem.ColorOption.NONE);
            this.plottingSystem.setDatasetChoosingRequired(false);
        }
        catch (Exception exception) {
            logger.error("Cannot locate any plotting systems!", (Throwable)exception);
        }
    }

    public Object getAdapter(Class clazz) {
        if (clazz == IToolPageSystem.class) {
            return this.plottingSystem;
        }
        return super.getAdapter(clazz);
    }

    public void createPartControl(Composite composite) {
        view = this;
        this.parent = composite;
        composite.setLayout((Layout)new GridLayout());
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        composite2.setLayout((Layout)new FillLayout());
        try {
            IActionBars iActionBars = this.getViewSite().getActionBars();
            this.plottingSystem.createPlotPart(composite2, this.title, iActionBars, PlotType.PT1D, (IWorkbenchPart)this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setFocus() {
    }

    public void setData(String string, String string2, boolean bl, float[] fArray, String string3, float[] fArray2) {
        double[] dArray = new double[fArray.length];
        double[] dArray2 = new double[fArray.length];
        int n = 0;
        while (n < fArray.length) {
            dArray[n] = fArray[n];
            dArray2[n] = bl ? (double)fArray2[fArray.length - 1 - n] : (double)fArray2[n];
            ++n;
        }
        DoubleDataset doubleDataset = new DoubleDataset(dArray, new int[]{fArray.length});
        DoubleDataset doubleDataset2 = new DoubleDataset(dArray2, new int[]{fArray.length});
        doubleDataset.setName("pixel");
        doubleDataset2.setName("Intensity");
        ArrayList<DoubleDataset> arrayList = new ArrayList<DoubleDataset>(1);
        arrayList.add(doubleDataset2);
        this.plottingSystem.clear();
        this.plottingSystem.createPlot1D((AbstractDataset)doubleDataset, arrayList, null);
        this.plottingSystem.setTitle(string);
    }

    public void dispose() {
        if (this.plottingSystem != null) {
            this.plottingSystem.dispose();
        }
        this.plottingSystem = null;
        super.dispose();
    }
}

