/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.views;

import fable.framework.toolbox.FableUtils;
import fable.framework.toolbox.GridUtils;
import fable.imageviewer.component.ActionsProvider;
import fable.imageviewer.component.ImageComponent;
import fable.imageviewer.component.ImageComponentImage;
import fable.imageviewer.component.ImagePlay;
import fable.imageviewer.internal.IImagesVarKeys;
import fable.imageviewer.internal.ZoomSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart3;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class ImageView
extends ViewPart
implements IImagesVarKeys,
ActionsProvider {
    public static final String ID = "fable.imageviewer.views.ImageView";
    private ImageComponent imageComponent;

    public void createPartControl(Composite composite) {
        String string = this.getSecondaryId();
        if (string == null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage iWorkbenchPage = ImageView.this.getViewSite().getPage();
                    if (iWorkbenchPage == null) {
                        return;
                    }
                    iWorkbenchPage.hideView((IViewPart)ImageView.this);
                    try {
                        iWorkbenchPage.showView(ImageView.ID, "Main", 3);
                    }
                    catch (PartInitException partInitException) {
                        FableUtils.excMsg((Object)this, (String)"Error creating view with known secondary ID", (Throwable)partInitException);
                    }
                }
            });
            return;
        }
        this.setPartName(String.valueOf(string) + " Image View");
        this.imageComponent = new ImageComponent((IWorkbenchPart3)this);
        this.imageComponent.createPartControl(composite);
        GridUtils.removeMargins((Composite)composite);
        if (string.equals("Main")) {
            ImagePlay.setView(this.imageComponent);
        }
    }

    public void setFocus() {
        if (this.imageComponent != null) {
            this.imageComponent.setFocus();
        }
    }

    public void dispose() {
        if (this.imageComponent != null) {
            this.imageComponent.dispose();
        }
    }

    public String getSecondaryId() {
        String string = null;
        try {
            string = this.getViewSite().getSecondaryId();
        }
        catch (Exception exception) {}
        return string;
    }

    public ImageComponentImage getImage() {
        return this.imageComponent.getImage();
    }

    public void setPartName(String string) {
        super.setPartName(string);
    }

    public void transferSelectedSettings(ImageComponent imageComponent) {
        this.imageComponent.transferSelectedSettings(imageComponent);
    }

    public ImageComponent getImageComponent() {
        return this.imageComponent;
    }

    @Override
    public IActionBars getActionBars() {
        return this.getViewSite().getActionBars();
    }

    public void setZoomSelection(ZoomSelection zoomSelection) {
        this.getImageComponent().setZoomSelection(zoomSelection);
    }
}

