/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.views;

import fable.framework.navigator.controller.SampleController;
import fable.framework.toolbox.FableUtils;
import fable.imageviewer.rcp.Activator;
import fable.python.Sample;
import fable.python.SampleException;
import fr.esrf.tangoatk.widget.util.chart.IJLChartListener;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLChartEvent;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.SwingUtilities;
import org.dawb.fabio.FabioFile;
import org.dawb.fabio.FabioFileException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class HeaderPlotView
extends ViewPart
implements IPropertyChangeListener,
IJLChartListener {
    private static final long serialVersionUID = 1L;
    public static HeaderPlotView view;
    public static final String ID = "fable.imageviewer.views.HeaderPlotView";
    HashMap<String, JLDataView> dataToPlot = new HashMap();
    SampleController controller;
    private static Composite swtAwtComponent;
    private static Frame chartFrame;
    private static JApplet chartContainer;
    private JLChart chart;
    private HashMap<Sample, HashMap<JLAxis, ArrayList<JLDataView>>> sampleAndItsData = new HashMap();
    private JLDataView currentdataview;
    private String chartName;
    private String syAxisLabel;
    private String sxAxisLabel;
    static int iDataColor;
    Combo sampleCombo;
    Combo xKeysCombo;
    Combo yKeysCombo;
    Combo y1dataviews;
    Combo y2dataviews;
    public Button plotDiff;
    public Button resetButton;
    public Button removeDataViewY1;
    public Button removeDataViewY2;
    Group grpPlot;
    int currentXIndex = 0;
    int currentYIndex = 0;
    Button y1Button;
    Button y2Button;
    double[] currentXData;
    double[] currentYData;
    private Sample currentSample;
    int[] dataMarkers = new int[]{2, 9, 8, 4, 1, 5};
    static int iDataMarker;
    Color[] dataColors = new Color[]{Color.RED, Color.BLUE, Color.CYAN, Color.GREEN, Color.MAGENTA, Color.ORANGE, Color.YELLOW};
    ImageDescriptor img = Activator.imageDescriptorFromPlugin((String)"org.dawb.fable.imageviewer", (String)"icons/subtractplot.gif");
    ImageDescriptor imgchartDataviewOptions = Activator.imageDescriptorFromPlugin((String)"org.dawb.fable.imageviewer", (String)"icons/graphView.gif");
    Image imagePlotsubtract;
    Image imagePlotsubtractY2;
    Image imageDataViewOptions1;
    Image imageDataViewOptions2;
    ImageDescriptor imgadd = Activator.imageDescriptorFromPlugin((String)"org.dawb.fable.imageviewer", (String)"icons/addplot.gif");
    Image imagePlotadd;
    ImageDescriptor imgClear = Activator.imageDescriptorFromPlugin((String)"org.dawb.fable.imageviewer", (String)"icons/delete.gif");
    Image imagePlotclear;

    static {
        iDataColor = 0;
        iDataMarker = 0;
    }

    public void createPartControl(Composite composite) {
        Vector vector;
        view = this;
        this.createHeaderPlot(composite, "Header keys", "X", "Y");
        this.controller = SampleController.getController();
        this.controller.addPropertyChangeListener((IPropertyChangeListener)this);
        this.currentSample = this.controller.getCurrentsample();
        if (this.currentSample != null) {
            this.populateListsKeys();
        }
        if ((vector = this.controller.getSamples()) != null && vector.size() > 0) {
            for (Sample sample : vector) {
                this.sampleAndItsData.put(sample, null);
            }
        }
        this.populateCombosample();
        this.enableGroupDataViews();
    }

    private void createHeaderPlot(Composite composite, String string, String string2, String string3) {
        this.chartName = string;
        this.syAxisLabel = string3;
        this.sxAxisLabel = string2;
        composite.setLayoutData((Object)new GridData());
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 6));
        HeaderPlotView.createChartFrame(composite);
        this.createChart();
        this.createOptionsGroup(composite);
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty() != null) {
                    String string = (String)propertyChangeEvent.getNewValue();
                    if (propertyChangeEvent.getProperty().equals("xLabelPreference")) {
                        if (string != null && !string.equals("")) {
                            HeaderPlotView.this.setSxAxisLabel(string);
                        }
                    } else if (propertyChangeEvent.getProperty().equals("xLabelPreference") && string != null && !string.equals("")) {
                        HeaderPlotView.this.setSyAxisLabel(string);
                    }
                }
            }
        });
    }

    public void createChart() {
        this.chart = new JLChart();
        this.chart.setToolTipText("Zoom: Ctrl + select zone with mouse ");
        this.chart.setHeader(this.chartName);
        this.chart.setHeaderFont(new Font("Dialog", 1, 18));
        this.chart.getY1Axis().setName(this.syAxisLabel);
        this.chart.getY1Axis().setAutoScale(true);
        this.chart.getY1Axis().setGridVisible(true);
        this.chart.getY1Axis().setSubGridVisible(true);
        this.chart.getY2Axis().setName(this.syAxisLabel);
        this.chart.getY2Axis().setAutoScale(true);
        this.chart.getY2Axis().setGridVisible(true);
        this.chart.getY2Axis().setSubGridVisible(true);
        this.chart.getXAxis().setName(this.sxAxisLabel);
        this.chart.getXAxis().setGridVisible(true);
        this.chart.getXAxis().setSubGridVisible(true);
        this.chart.getXAxis().setAnnotation(2);
        this.chart.getXAxis().setAutoScale(true);
        chartContainer.add((Component)this.chart);
        this.chart.setJLChartListener((IJLChartListener)this);
    }

    private static void createChartFrame(Composite composite) {
        swtAwtComponent = new Composite(composite, 0x1040000);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.verticalSpan = 6;
        gridData.horizontalSpan = 2;
        swtAwtComponent.setLayout((Layout)new GridLayout());
        swtAwtComponent.setLayoutData((Object)gridData);
        chartFrame = SWT_AWT.new_Frame((Composite)swtAwtComponent);
        chartContainer = new JApplet();
        chartFrame.add(chartContainer);
    }

    private void createOptionsGroup(Composite composite) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(composite, 768);
        Composite composite2 = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)composite2);
        scrolledComposite.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData());
        composite2.pack();
        Group group = new Group(composite2, 0);
        group.setLayout((Layout)new GridLayout(5, false));
        GridData gridData = new GridData(4, 4, true, false);
        gridData.verticalSpan = 1;
        gridData.horizontalSpan = 1;
        group.setLayoutData((Object)gridData);
        group.setText("Samples");
        new Label((Composite)group, 0).setText("Samples");
        this.sampleCombo = new Combo((Composite)group, 8);
        this.sampleCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ((GridData)this.sampleCombo.getLayoutData()).horizontalSpan = 4;
        this.sampleCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                super.widgetSelected(selectionEvent);
                Combo combo = (Combo)selectionEvent.widget;
                String string = combo.getText();
                if (string != null) {
                    HeaderPlotView.this.currentSample = (Sample)combo.getData(string);
                }
                HeaderPlotView.this.populateJLDataViews(HeaderPlotView.this.currentSample);
                HeaderPlotView.this.populateListsKeys();
            }
        });
        this.createListsKeys_X((Composite)group);
        this.createListsKeys_Y((Composite)group);
        this.plotDiff = new Button((Composite)group, 32);
        this.plotDiff.setText("Difference");
        this.plotDiff.setToolTipText("plot of the difference between the adjacent values");
        this.plotDiff.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        ((GridData)this.plotDiff.getLayoutData()).horizontalSpan = 1;
        this.plotDiff.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                HeaderPlotView.this.repaint();
            }
        });
        this.grpPlot = new Group(composite2, 0);
        this.grpPlot.setText("Data");
        this.grpPlot.setLayout((Layout)new GridLayout(5, false));
        GridData gridData2 = new GridData(4, 0x1000000, true, false);
        this.grpPlot.setLayoutData((Object)gridData2);
        this.y1Button = new Button((Composite)this.grpPlot, 8);
        this.imagePlotadd = this.imgadd.createImage();
        this.y1Button.setImage(this.imagePlotadd);
        this.y1Button.setToolTipText("add next plot to Y1 axis");
        this.y1Button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (HeaderPlotView.this.imagePlotadd != null && !HeaderPlotView.this.imagePlotadd.isDisposed()) {
                    HeaderPlotView.this.imagePlotadd.dispose();
                }
            }
        });
        this.y1Button.setSelection(true);
        this.y1Button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (HeaderPlotView.this.currentSample == null) {
                    HeaderPlotView.this.currentSample = HeaderPlotView.this.getSelectedSample();
                }
                HeaderPlotView.this.addDataView(HeaderPlotView.this.currentSample, HeaderPlotView.this.y1dataviews, HeaderPlotView.this.chart.getY1Axis());
                HeaderPlotView.this.repaint();
            }
        });
        this.y1dataviews = new Combo((Composite)this.grpPlot, 8);
        GridData gridData3 = new GridData(4, 0x1000000, true, false);
        gridData3.horizontalSpan = 1;
        this.y1dataviews.setLayoutData((Object)gridData3);
        this.removeDataViewY1 = new Button((Composite)this.grpPlot, 8);
        this.removeDataViewY1.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.imagePlotsubtract = this.img.createImage();
        this.removeDataViewY1.setToolTipText("Remove from plot");
        this.removeDataViewY1.setImage(this.imagePlotsubtract);
        this.removeDataViewY1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = HeaderPlotView.this.y1dataviews.getSelectionIndex();
                HeaderPlotView.this.currentSample = HeaderPlotView.this.getSelectedSample();
                ArrayList arrayList = HeaderPlotView.this.getJLdataView(HeaderPlotView.this.currentSample, HeaderPlotView.this.chart.getY1Axis());
                if (arrayList != null && n >= 0) {
                    HeaderPlotView.this.removeDataViewFromChart(HeaderPlotView.this.chart.getY1Axis(), (JLDataView)arrayList.get(n));
                    arrayList.remove(n);
                    HeaderPlotView.this.y1dataviews.remove(n);
                    if (iDataMarker > 0) {
                        --iDataMarker;
                    }
                    if (iDataColor > 0) {
                        --iDataColor;
                    }
                }
                if (n < HeaderPlotView.this.y1dataviews.getItemCount()) {
                    HeaderPlotView.this.y1dataviews.select(n);
                } else if (HeaderPlotView.this.y1dataviews.getItemCount() > 0) {
                    HeaderPlotView.this.y1dataviews.select(0);
                }
            }
        });
        this.removeDataViewY1.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (HeaderPlotView.this.imagePlotsubtract != null && !HeaderPlotView.this.imagePlotsubtract.isDisposed()) {
                    HeaderPlotView.this.imagePlotsubtract.dispose();
                }
            }
        });
        Button button = new Button((Composite)this.grpPlot, 8);
        this.imageDataViewOptions1 = this.imgchartDataviewOptions.createImage();
        button.setToolTipText("Show data view options");
        GridData gridData4 = new GridData(16384, 0x1000000, true, false);
        gridData4.horizontalSpan = 2;
        button.setLayoutData((Object)gridData4);
        button.setImage(this.imageDataViewOptions1);
        button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (HeaderPlotView.this.imageDataViewOptions1 != null && !HeaderPlotView.this.imageDataViewOptions1.isDisposed()) {
                    HeaderPlotView.this.imageDataViewOptions1.dispose();
                }
            }
        });
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = HeaderPlotView.this.y1dataviews.getSelectionIndex();
                HeaderPlotView.this.currentSample = HeaderPlotView.this.getSelectedSample();
                ArrayList arrayList = HeaderPlotView.this.getJLdataView(HeaderPlotView.this.currentSample, HeaderPlotView.this.chart.getY1Axis());
                if (arrayList != null && n >= 0) {
                    final JLDataView jLDataView = (JLDataView)arrayList.get(n);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            HeaderPlotView.this.chart.showDataOptionDialog(jLDataView);
                        }
                    });
                }
            }
        });
        this.y2Button = new Button((Composite)this.grpPlot, 8);
        this.y2Button.setImage(this.imagePlotadd);
        this.y2Button.setToolTipText("add next plot to Y2 axis");
        this.y2Button.setSelection(false);
        this.y2Button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (HeaderPlotView.this.currentSample == null) {
                    HeaderPlotView.this.currentSample = HeaderPlotView.this.getSelectedSample();
                }
                HeaderPlotView.this.addDataView(HeaderPlotView.this.currentSample, HeaderPlotView.this.y2dataviews, HeaderPlotView.this.chart.getY2Axis());
                HeaderPlotView.this.repaint();
            }
        });
        this.y2Button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (HeaderPlotView.this.imagePlotadd != null && !HeaderPlotView.this.imagePlotadd.isDisposed()) {
                    HeaderPlotView.this.imagePlotadd.dispose();
                }
            }
        });
        GridData gridData5 = new GridData(4, 0x1000000, true, false);
        gridData5.horizontalSpan = 1;
        this.y2dataviews = new Combo((Composite)this.grpPlot, 8);
        this.y2dataviews.setLayoutData((Object)gridData5);
        this.removeDataViewY2 = new Button((Composite)this.grpPlot, 8);
        this.removeDataViewY2.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.imagePlotsubtractY2 = this.img.createImage();
        this.removeDataViewY2.setToolTipText("Remove from plot");
        this.removeDataViewY2.setImage(this.imagePlotsubtract);
        this.removeDataViewY2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = HeaderPlotView.this.y2dataviews.getSelectionIndex();
                HeaderPlotView.this.currentSample = HeaderPlotView.this.getSelectedSample();
                ArrayList arrayList = HeaderPlotView.this.getJLdataView(HeaderPlotView.this.currentSample, HeaderPlotView.this.chart.getY2Axis());
                if (arrayList != null && n >= 0) {
                    HeaderPlotView.this.removeDataViewFromChart(HeaderPlotView.this.chart.getY2Axis(), (JLDataView)arrayList.get(n));
                    arrayList.remove(n);
                    HeaderPlotView.this.y2dataviews.remove(n);
                    if (iDataMarker > 0) {
                        --iDataMarker;
                    }
                    if (iDataColor > 0) {
                        --iDataColor;
                    }
                }
                if (n < HeaderPlotView.this.y2dataviews.getItemCount()) {
                    HeaderPlotView.this.y2dataviews.select(n);
                } else if (HeaderPlotView.this.y2dataviews.getItemCount() > 0) {
                    HeaderPlotView.this.y2dataviews.select(0);
                }
            }
        });
        this.removeDataViewY2.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (HeaderPlotView.this.imagePlotsubtractY2 != null && !HeaderPlotView.this.imagePlotsubtractY2.isDisposed()) {
                    HeaderPlotView.this.imagePlotsubtractY2.dispose();
                }
            }
        });
        Button button2 = new Button((Composite)this.grpPlot, 8);
        button2.setToolTipText("Show data view options");
        this.imageDataViewOptions2 = this.imgchartDataviewOptions.createImage();
        button2.setImage(this.imageDataViewOptions1);
        button2.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (HeaderPlotView.this.imageDataViewOptions2 != null && !HeaderPlotView.this.imageDataViewOptions2.isDisposed()) {
                    HeaderPlotView.this.imageDataViewOptions2.dispose();
                }
            }
        });
        button2.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = HeaderPlotView.this.y2dataviews.getSelectionIndex();
                HeaderPlotView.this.currentSample = HeaderPlotView.this.getSelectedSample();
                ArrayList arrayList = HeaderPlotView.this.getJLdataView(HeaderPlotView.this.currentSample, HeaderPlotView.this.chart.getY2Axis());
                if (arrayList != null && n >= 0) {
                    final JLDataView jLDataView = (JLDataView)arrayList.get(n);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            HeaderPlotView.this.chart.showDataOptionDialog(jLDataView);
                        }
                    });
                }
            }
        });
        this.resetButton = new Button((Composite)this.grpPlot, 8);
        GridData gridData6 = new GridData(131072, 0x1000000, false, false);
        gridData6.verticalSpan = 1;
        this.resetButton.setLayoutData((Object)gridData6);
        this.imagePlotclear = this.imgClear.createImage();
        this.resetButton.setImage(this.imagePlotclear);
        this.resetButton.setToolTipText("Clear plot");
        this.resetButton.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        this.resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                HeaderPlotView.this.clearAllPlots();
            }
        });
        this.resetButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (HeaderPlotView.this.imagePlotclear != null && !HeaderPlotView.this.imagePlotclear.isDisposed()) {
                    HeaderPlotView.this.imagePlotclear.dispose();
                }
            }
        });
        scrolledComposite.setMinHeight(Display.getDefault().getPrimaryMonitor().getBounds().height);
        scrolledComposite.setMinWidth(Display.getDefault().getPrimaryMonitor().getBounds().width);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setMinSize(composite2.computeSize(-1, -1));
    }

    private void createListsKeys_X(Composite composite) {
        new Label(composite, 0).setText("X axis");
        this.xKeysCombo = new Combo(composite, 2560);
        GridData gridData = new GridData(16384, 2, true, false);
        this.xKeysCombo.setLayoutData((Object)gridData);
        this.xKeysCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String[] stringArray = ((Combo)selectionEvent.widget).getItems();
                HeaderPlotView.this.currentXIndex = ((Combo)selectionEvent.widget).getSelectionIndex();
                if (HeaderPlotView.this.currentXIndex < 0) {
                    HeaderPlotView.this.currentXIndex = 0;
                }
                HeaderPlotView.this.sxAxisLabel = stringArray[HeaderPlotView.this.currentXIndex];
                HeaderPlotView.this.chart.getXAxis().setName(HeaderPlotView.this.sxAxisLabel);
            }
        });
    }

    private void createListsKeys_Y(Composite composite) {
        new Label(composite, 0).setText("Y axis");
        this.yKeysCombo = new Combo(composite, 2560);
        GridData gridData = new GridData(16384, 2, true, false);
        this.yKeysCombo.setLayoutData((Object)gridData);
        this.yKeysCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String[] stringArray = ((Combo)selectionEvent.widget).getItems();
                HeaderPlotView.this.currentYIndex = ((Combo)selectionEvent.widget).getSelectionIndex();
                if (HeaderPlotView.this.currentYIndex < 0) {
                    HeaderPlotView.this.currentYIndex = 1;
                }
                HeaderPlotView.this.syAxisLabel = stringArray[HeaderPlotView.this.currentYIndex];
            }
        });
    }

    public void setFocus() {
    }

    public void dispose() {
        this.controller.removePropertyChangeListener((IPropertyChangeListener)this);
        iDataMarker = 0;
        iDataColor = 0;
        super.dispose();
    }

    private Sample getSelectedSample() {
        String string = this.sampleCombo.getText();
        return (Sample)this.sampleCombo.getData(string);
    }

    public void setData(Sample sample, JLDataView jLDataView) {
        try {
            double[] dArray = sample.getHeaderValues(this.sxAxisLabel);
            double[] dArray2 = this.plotDiff.getSelection() ? sample.getHeaderValuesDiff(this.syAxisLabel) : sample.getHeaderValues(this.syAxisLabel);
            if (dArray != null && dArray2 != null) {
                jLDataView.setXDataSorted(false);
                jLDataView.setData(dArray, dArray2);
            }
        }
        catch (SampleException sampleException) {
            FableUtils.excMsg((Object)((Object)this), (String)"Error setting header vlaues", (Throwable)sampleException);
        }
    }

    public void setSyAxisLabel(String string) {
        if (string != null) {
            this.syAxisLabel = string;
            this.selectLabelinYCombo(string);
        }
    }

    public void setSxAxisLabel(String string) {
        if (string != null) {
            this.sxAxisLabel = string;
            this.selectLabelinXCombo(string);
        }
    }

    public void populateListsKeys() {
        this.xKeysCombo.removeAll();
        this.yKeysCombo.removeAll();
        if (this.currentSample != null) {
            try {
                String[] stringArray = this.currentSample.getKeys();
                int n = 0;
                while (stringArray != null && n < stringArray.length) {
                    String string = stringArray[n];
                    this.xKeysCombo.add(string);
                    this.yKeysCombo.add(string);
                    ++n;
                }
                this.yKeysCombo.setEnabled(this.yKeysCombo.getItemCount() > 0);
                this.xKeysCombo.setEnabled(this.yKeysCombo.getItemCount() > 0);
                if (this.currentXIndex > this.xKeysCombo.getItemCount()) {
                    this.currentXIndex = 0;
                }
                if (this.currentYIndex > this.yKeysCombo.getItemCount()) {
                    this.currentYIndex = 0;
                }
                if (this.xKeysCombo.getItemCount() > 0) {
                    this.xKeysCombo.select(this.currentXIndex);
                    this.sxAxisLabel = this.xKeysCombo.getItem(this.currentXIndex);
                }
                if (this.yKeysCombo.getItemCount() > 0) {
                    this.yKeysCombo.select(this.currentYIndex);
                    this.syAxisLabel = this.yKeysCombo.getItem(this.currentYIndex);
                }
            }
            catch (SampleException sampleException) {
                FableUtils.excMsg((Object)((Object)this), (String)"Unable to load keys for current file", (Throwable)sampleException);
            }
        }
    }

    private ArrayList<JLDataView> getJLdataView(Sample sample, JLAxis jLAxis) {
        HashMap<JLAxis, ArrayList<JLDataView>> hashMap = this.sampleAndItsData.get(sample);
        ArrayList<JLDataView> arrayList = null;
        if (hashMap != null) {
            arrayList = hashMap.get(jLAxis);
        }
        return arrayList;
    }

    public void clearAllPlots() {
        Object object;
        this.chart.removeAll();
        this.currentSample = this.getSelectedSample();
        ArrayList<JLDataView> arrayList = this.getJLdataView(this.currentSample, this.chart.getY1Axis());
        if (arrayList != null) {
            object = arrayList.iterator();
            while (object.hasNext()) {
                this.chart.getY1Axis().removeDataView((JLDataView)object.next());
            }
            arrayList.removeAll(arrayList);
        }
        if ((object = this.getJLdataView(this.currentSample, this.chart.getY2Axis())) != null) {
            Iterator iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                this.chart.getY2Axis().removeDataView((JLDataView)iterator.next());
            }
            ((ArrayList)object).removeAll((Collection<?>)object);
        }
        this.repaint();
        iDataColor = 0;
        iDataMarker = 0;
        this.y1dataviews.removeAll();
        this.y2dataviews.removeAll();
        this.populateJLDataViews(this.currentSample);
    }

    public void addDataView(Sample sample, Combo combo, JLAxis jLAxis) {
        if (!Display.getCurrent().isDisposed() && sample != null) {
            ArrayList<Object> arrayList;
            JLDataView jLDataView = new JLDataView();
            jLDataView.setXDataSorted(false);
            if (this.plotDiff.getSelection()) {
                jLDataView.setName("Diff: " + sample.getDirectoryName() + " :" + this.syAxisLabel + " =f(" + this.sxAxisLabel + ")");
            } else {
                jLDataView.setName(String.valueOf(sample.getDirectoryName()) + " :" + this.syAxisLabel + " =f(" + this.sxAxisLabel + ")");
            }
            jLAxis.setName(this.syAxisLabel);
            this.chart.getXAxis().setName(this.sxAxisLabel);
            this.currentdataview = jLDataView;
            HashMap<Object, ArrayList<Object>> hashMap = this.sampleAndItsData.get(sample);
            if (hashMap == null) {
                hashMap = new HashMap();
            }
            if ((arrayList = hashMap.get(jLAxis)) == null) {
                arrayList = new ArrayList();
            }
            int n = arrayList.size();
            arrayList.add(jLDataView);
            hashMap.put(jLAxis, arrayList);
            this.sampleAndItsData.put(sample, hashMap);
            jLDataView.setMarkerSize(7);
            jLDataView.setLineWidth(0);
            jLDataView.setMarkerColor(this.dataColors[iDataColor]);
            jLDataView.setMarker(this.dataMarkers[iDataMarker]);
            iDataColor = iDataColor + 1 < this.dataColors.length - 1 ? ++iDataColor : 0;
            iDataMarker = iDataMarker + 1 < this.dataMarkers.length - 1 ? ++iDataMarker : 0;
            jLAxis.addDataView(jLDataView);
            combo.add(jLDataView.getName());
            combo.select(n);
            this.setData(sample, jLDataView);
            this.repaint();
        }
    }

    private void removeDataViewFromChart(JLAxis jLAxis, JLDataView jLDataView) {
        jLAxis.removeDataView(jLDataView);
        this.repaint();
    }

    public void removeDataViews(Sample sample) {
        this.removeJLDataViews(sample);
        this.sampleAndItsData.remove(sample);
        this.populateCombosample();
        String string = this.sampleCombo.getText();
        if (string != null) {
            this.currentSample = (Sample)this.sampleCombo.getData(string);
            this.populateJLDataViews(this.currentSample);
        }
        this.populateListsKeys();
        this.repaint();
    }

    private void populateCombosample() {
        Set<Sample> set = this.sampleAndItsData.keySet();
        Iterator<Sample> iterator = set.iterator();
        this.sampleCombo.removeAll();
        while (iterator.hasNext()) {
            Sample sample = iterator.next();
            this.sampleCombo.add(sample.getDirectoryName());
            this.sampleCombo.setData(sample.getDirectoryName(), (Object)sample);
        }
        this.sampleCombo.select(0);
        this.sampleCombo.setEnabled(this.sampleCombo.getItemCount() > 0);
    }

    private void populateJLDataViews(Sample sample) {
        this.y1dataviews.removeAll();
        this.y2dataviews.removeAll();
        HashMap<JLAxis, ArrayList<JLDataView>> hashMap = this.sampleAndItsData.get(sample);
        if (hashMap != null) {
            Set<JLAxis> set = hashMap.keySet();
            for (JLAxis jLAxis : set) {
                String string;
                int n;
                ArrayList<JLDataView> arrayList;
                if (jLAxis.equals(this.chart.getY1Axis())) {
                    arrayList = hashMap.get(jLAxis);
                    n = 0;
                    while (arrayList != null && n < arrayList.size()) {
                        string = arrayList.get(n).getName();
                        this.y1dataviews.add(string);
                        ++n;
                    }
                    continue;
                }
                arrayList = hashMap.get(jLAxis);
                n = 0;
                while (arrayList != null && n < arrayList.size()) {
                    string = arrayList.get(n).getName();
                    this.y2dataviews.add(string);
                    ++n;
                }
            }
        }
        if (this.y1dataviews.getItemCount() > 0) {
            this.y1dataviews.select(0);
        }
        if (this.y2dataviews.getItemCount() > 0) {
            this.y2dataviews.select(0);
        }
    }

    private void removeJLDataViews(Sample sample) {
        boolean bl = false;
        Set<Sample> set = this.sampleAndItsData.keySet();
        Iterator<Sample> iterator = set.iterator();
        while (iterator.hasNext() && !bl) {
            Sample sample2 = iterator.next();
            if (!sample2.equals(sample)) continue;
            bl = true;
            HashMap<JLAxis, ArrayList<JLDataView>> hashMap = this.sampleAndItsData.get(sample2);
            if (hashMap == null) continue;
            Set<JLAxis> set2 = hashMap.keySet();
            for (JLAxis jLAxis : set2) {
                ArrayList<JLDataView> arrayList = hashMap.get(jLAxis);
                int n = 0;
                while (arrayList != null && n < arrayList.size()) {
                    jLAxis.removeDataView(arrayList.get(n));
                    ++n;
                }
            }
        }
    }

    public void repaint() {
        Dimension dimension = chartContainer.getSize();
        this.chart.setSize(dimension);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                chartContainer.repaint();
            }
        });
    }

    private void selectLabelinXCombo(String string) {
        boolean bl = false;
        int n = 0;
        n = 0;
        while (this.xKeysCombo != null && !bl && n < this.xKeysCombo.getItemCount()) {
            if (this.xKeysCombo.getItems()[n].equals(string)) {
                bl = true;
                this.xKeysCombo.select(n);
                this.currentXIndex = n;
                this.xKeysCombo.notifyListeners(13, new Event());
            }
            ++n;
        }
    }

    private void selectLabelinYCombo(String string) {
        boolean bl = false;
        int n = 0;
        n = 0;
        while (this.yKeysCombo != null && !bl && n < this.yKeysCombo.getItemCount()) {
            if (this.yKeysCombo.getItems()[n].equals(string)) {
                bl = true;
                this.yKeysCombo.select(n);
                this.currentYIndex = n;
                this.yKeysCombo.notifyListeners(13, new Event());
            }
            ++n;
        }
    }

    public JLChart getChart() {
        return this.chart;
    }

    public JApplet getChartContainer() {
        return chartContainer;
    }

    public void plotHeaderValues(final String string, final Sample sample) throws SampleException {
        final Job job = new Job("Loading file header"){

            protected IStatus run(final IProgressMonitor iProgressMonitor) {
                iProgressMonitor.beginTask("Wait while getting values for " + string + " in sample " + sample.getDirectoryName(), sample.getFilteredfiles().size());
                if (sample.hasFile()) {
                    int n = 0;
                    Iterator iterator = sample.getFilteredfiles().iterator();
                    while (iterator.hasNext()) {
                        if (iProgressMonitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        final FabioFile fabioFile = (FabioFile)iterator.next();
                        try {
                            if (n >= sample.getHeaderValues(string).length) continue;
                            final int n2 = n++;
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        double[] dArray = sample.getHeaderValues(string);
                                        dArray[n2] = Double.valueOf(fabioFile.getValue(string));
                                    }
                                    catch (SampleException sampleException) {
                                        FableUtils.excMsg((Object)this, (String)"Unable to load file headers", (Throwable)sampleException);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        FableUtils.excMsg((Object)this, (String)"Unable to load file headers", (Throwable)numberFormatException);
                                        iProgressMonitor.setCanceled(true);
                                    }
                                    catch (FabioFileException fabioFileException) {
                                        FableUtils.excMsg((Object)this, (String)"Unable to load file headers", (Throwable)fabioFileException);
                                        iProgressMonitor.setCanceled(true);
                                    }
                                }
                            });
                            iProgressMonitor.worked(1);
                        }
                        catch (SampleException sampleException) {
                            sampleException.printStackTrace();
                        }
                    }
                }
                iProgressMonitor.done();
                return Status.OK_STATUS;
            }
        };
        if (sample.hasFile()) {
            int n = sample.getFilteredfiles().size();
            double[] dArray = sample.getHeaderValues(string);
            job.setUser(true);
            if (dArray == null || dArray.length != n) {
                dArray = new double[n];
                sample.addHeaderValues(string, dArray);
                new Thread(){

                    @Override
                    public void run() {
                        job.schedule();
                        while (job.getResult() == null) {
                            view.showBusy(true);
                        }
                        view.showBusy(false);
                    }
                }.start();
            }
        }
    }

    public String[] clickOnChart(JLChartEvent jLChartEvent) {
        String[] stringArray = new String[]{String.valueOf(this.sxAxisLabel) + "=" + jLChartEvent.getTransformedXValue(), String.valueOf(this.syAxisLabel) + "=" + jLChartEvent.getTransformedYValue()};
        return stringArray;
    }

    private void enableGroupDataViews() {
        Control[] controlArray = this.grpPlot.getChildren();
        int n = 0;
        while (n < controlArray.length) {
            controlArray[n].setEnabled(this.sampleCombo.getItemCount() > 0);
            ++n;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty().equals("currentSample")) {
            this.currentSample = this.controller.getCurrentsample();
            this.populateListsKeys();
            this.populateJLDataViews(this.currentSample);
            String[] stringArray = this.sampleCombo.getItems();
            this.sampleCombo.setEnabled(this.sampleCombo.getItemCount() > 0);
            boolean bl = false;
            int n = 0;
            while (stringArray != null && !bl && n < stringArray.length) {
                if (stringArray[n].equals(this.currentSample.getDirectoryName())) {
                    this.sampleCombo.select(n);
                    bl = true;
                }
                ++n;
            }
        } else if (propertyChangeEvent.getProperty().equals("newSample")) {
            final Sample sample = (Sample)propertyChangeEvent.getNewValue();
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    HeaderPlotView.this.sampleAndItsData.put(sample, null);
                    HeaderPlotView.this.populateCombosample();
                    HeaderPlotView.this.populateJLDataViews(sample);
                    HeaderPlotView.this.populateListsKeys();
                    HeaderPlotView.this.enableGroupDataViews();
                }
            });
        } else if (propertyChangeEvent.getProperty().equals("RemoveSample")) {
            Sample sample = (Sample)propertyChangeEvent.getNewValue();
            this.removeDataViews(sample);
            this.enableGroupDataViews();
        } else if (propertyChangeEvent.getProperty().equals("updatePlot")) {
            this.setData(this.currentSample, this.currentdataview);
            this.repaint();
        } else if (propertyChangeEvent.getProperty().equals("CurrentFile")) {
            this.populateListsKeys();
        }
    }
}

