/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.model;

import fable.framework.navigator.Activator;
import fable.imageviewer.model.IFableImage;
import fable.imageviewer.model.IFableLoader;
import fable.imageviewer.model.ImageModel;
import org.dawb.fabio.FabioFile;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class ImageModelFactory {
    private static final String IFABLE_LOADER_ID = "fable.imageviewer.model.fableLoader";

    public static ImageModel getImageModel(Object object) throws Throwable {
        if (object instanceof FabioFile) {
            return ImageModelFactory.getImageModel((FabioFile)object);
        }
        return ImageModelFactory.getImageModel((String)object);
    }

    public static ImageModel getImageModel(String string) throws Throwable {
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(IFABLE_LOADER_ID);
        if (iConfigurationElementArray != null && iConfigurationElementArray.length > 0) {
            IFableLoader iFableLoader = (IFableLoader)iConfigurationElementArray[0].createExecutableExtension("class");
            boolean bl = Activator.getDefault().getPreferenceStore().getBoolean("fable.framework.navigator.preferences.useFabio");
            IFableImage iFableImage = iFableLoader.loadFile(string = string.replace("%20", " "), null, bl, null);
            if (iFableImage != null) {
                return new ImageModel(iFableImage.getFileName(), iFableImage.getWidth(), iFableImage.getHeight(), iFableImage.getImage(), iFableImage.getLoadTime());
            }
        }
        return ImageModelFactory.getImageModel(new FabioFile(string));
    }

    public static ImageModel getImageModel(String string, int n, int n2, float[] fArray) {
        return new ImageModel(string, n, n2, fArray, -1L);
    }

    private static ImageModel getImageModel(FabioFile fabioFile) throws Throwable {
        return new ImageModel(fabioFile);
    }
}

