/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.model;

import fable.imageviewer.model.ImageModelEvent;
import fable.imageviewer.model.ImageModelListener;
import java.util.EventListener;
import javax.swing.event.EventListenerList;
import org.dawb.fabio.FabioFile;
import org.dawb.fabio.FableJep;
import org.eclipse.swt.graphics.Rectangle;

public class ImageModel {
    private EventListenerList listenerList = new EventListenerList();
    private String fileName = null;
    private int width = 0;
    private int height = 0;
    private float[] data = null;
    private float[] statistics = null;
    private long time;
    public static final String DATA_CHANGED = String.valueOf(ImageModel.class.getName()) + ".DataChanged";
    public static final String RESET = String.valueOf(ImageModel.class.getName()) + ".Reset";

    ImageModel() {
    }

    ImageModel(FabioFile fabioFile) throws Throwable {
        this();
        this.set(fabioFile);
    }

    ImageModel(String string, int n, int n2, float[] fArray, long l) {
        this();
        this.reset(string, n, n2, fArray);
        this.time = l;
    }

    public void addImageModelListener(ImageModelListener imageModelListener) {
        this.listenerList.add(ImageModelListener.class, imageModelListener);
    }

    public void removeImageModelListener(ImageModelListener imageModelListener) {
        this.listenerList.remove(ImageModelListener.class, imageModelListener);
    }

    public void removeAllImageModelListeners(ImageModelListener imageModelListener) {
        EventListener[] eventListenerArray;
        EventListener[] eventListenerArray2 = eventListenerArray = this.listenerList.getListeners(ImageModelListener.class);
        int n = eventListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            EventListener eventListener = eventListenerArray2[n2];
            this.listenerList.remove(ImageModelListener.class, (ImageModelListener)eventListener);
            ++n2;
        }
    }

    protected void fireImageModelEvent(String string, Object object, Object object2) {
        EventListener[] eventListenerArray;
        EventListener[] eventListenerArray2 = eventListenerArray = this.listenerList.getListeners(ImageModelListener.class);
        int n = eventListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            EventListener eventListener = eventListenerArray2[n2];
            ImageModelEvent imageModelEvent = new ImageModelEvent(this, string, object, object2);
            ((ImageModelListener)eventListener).propertyChange(imageModelEvent);
            ++n2;
        }
    }

    public void set(FabioFile fabioFile) throws Throwable {
        try {
            this.statistics = null;
            this.fileName = fabioFile.getFileName();
            this.data = fabioFile.getImageAsFloat(FableJep.getFableJep());
            this.width = fabioFile.getWidth();
            this.height = fabioFile.getHeight();
            this.time = fabioFile.getTimeToReadImage();
        }
        finally {
            this.fireImageModelEvent(RESET, this, this);
        }
    }

    public void reset(String string, int n, int n2, float[] fArray) {
        this.statistics = null;
        this.fileName = string;
        this.width = n;
        this.height = n2;
        this.data = fArray;
        this.fireImageModelEvent(RESET, this, this);
    }

    private void calculateStatistics() {
        this.statistics = this.getStatistics(new Rectangle(0, 0, this.width, this.height));
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Rectangle getRect() {
        return new Rectangle(0, 0, this.width, this.height);
    }

    public float[] getStatistics() {
        if (this.statistics == null) {
            this.calculateStatistics();
        }
        return this.statistics;
    }

    public float[] getStatistics(Rectangle rectangle) {
        float f = Float.MAX_VALUE;
        float f2 = -3.4028235E38f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        int n = 0;
        while (n < rectangle.height) {
            int n2 = 0;
            while (n2 < rectangle.width) {
                float f5 = this.data[rectangle.x + n2 + (rectangle.y + n) * this.width];
                f4 += f5;
                if (f5 < f) {
                    f = f5;
                }
                if (f5 > f2) {
                    f2 = f5;
                }
                ++n2;
            }
            ++n;
        }
        f3 = f4 / (float)(rectangle.width * rectangle.height);
        return new float[]{f, f2, f3};
    }

    public float[] getData() {
        return this.data;
    }

    public float getData(int n, int n2) {
        if (this.data == null) {
            return Float.NaN;
        }
        return this.data[n2 + n * this.width];
    }

    public float getData(int n, int n2, Rectangle rectangle) {
        if (this.data == null) {
            return Float.NaN;
        }
        int n3 = n2 + n * rectangle.width;
        int n4 = n3 % this.width;
        int n5 = n3 / this.width;
        return this.data[n4 + n5 * this.width];
    }

    public float[] getData(Rectangle rectangle) {
        if (this.data == null) {
            return null;
        }
        float[] fArray = new float[rectangle.width * rectangle.height];
        int n = 0;
        while (n < rectangle.height) {
            int n2 = 0;
            while (n2 < rectangle.width) {
                fArray[n2 + n * rectangle.width] = this.data[rectangle.x + n2 + (rectangle.y + n) * this.width];
                ++n2;
            }
            ++n;
        }
        return fArray;
    }

    public void setData(float[] fArray) {
        float[] fArray2 = this.data;
        if (fArray != fArray2) {
            this.statistics = null;
            this.data = fArray;
            this.fireImageModelEvent(DATA_CHANGED, fArray2, fArray);
        }
    }

    public long getTimeToReadImage() {
        return this.time;
    }
}

