/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.internal;

import fable.framework.toolbox.EclipseUtils;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZoomSelection {
    private final Logger logger = LoggerFactory.getLogger(ZoomSelection.class);
    private final String name;
    private final String viewId;
    private final String secondId;
    public static final ZoomSelection NONE = new ZoomSelection("none", null);
    public static final ZoomSelection AREA = new ZoomSelection("area", "fable.imageviewer.views.ImageView", "Zoom");
    public static final ZoomSelection LINE = new ZoomSelection("line", "fable.imageviewer.views.LineView");
    public static final ZoomSelection PROFILE = new ZoomSelection("profile", "fable.imageviewer.views.ProfileView");
    public static final ZoomSelection RELIEF = new ZoomSelection("relief", "fable.imageviewer.views.ReliefView");
    public static final ZoomSelection ROCKINGCURVE = new ZoomSelection("rockingcurve", "fable.imageviewer.views.RockingCurveView");

    private ZoomSelection(String string, String string2) {
        this(string, string2, null);
    }

    public ZoomSelection(String string, String string2, String string3) {
        this.name = string;
        this.viewId = string2;
        this.secondId = string3;
    }

    public String getName() {
        return this.name;
    }

    public void bringToTop() {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        if (this.viewId != null) {
            if (EclipseUtils.getActivePage() == null) {
                return;
            }
            IViewPart iViewPart = EclipseUtils.getActivePage().findView(this.viewId);
            if (iViewPart == null) {
                IViewReference iViewReference = EclipseUtils.getActivePage().findViewReference(this.viewId, this.secondId);
                IViewPart iViewPart2 = iViewPart = iViewReference != null ? iViewReference.getView(false) : null;
            }
            if (iViewPart != null) {
                try {
                    EclipseUtils.getActivePage().bringToTop((IWorkbenchPart)iViewPart);
                }
                catch (Exception exception) {
                    this.logger.debug("Cannot bring page to top!", (Throwable)exception);
                }
            }
        }
    }

    public IViewPart getViewPart() throws PartInitException {
        if (this.secondId == null) {
            IViewPart iViewPart = EclipseUtils.getActivePage().findView(this.viewId);
            if (iViewPart == null) {
                iViewPart = EclipseUtils.getActivePage().showView(this.viewId);
            }
            return iViewPart;
        }
        IViewReference iViewReference = EclipseUtils.getActivePage().findViewReference(this.viewId, this.secondId);
        if (iViewReference == null) {
            return EclipseUtils.getActivePage().showView(this.viewId, this.secondId, 1);
        }
        return iViewReference != null ? iViewReference.getView(true) : null;
    }

    public String toString() {
        return this.name;
    }
}

