/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.internal;

import fable.framework.logging.FableLogger;
import fable.framework.navigator.controller.SampleController;
import fable.framework.navigator.views.SampleNavigatorView;
import fable.framework.toolbox.EclipseUtils;
import fable.framework.toolbox.FableUtils;
import fable.imageviewer.component.ImageComponent;
import fable.imageviewer.editor.ImageEditor;
import fable.imageviewer.views.ImageView;
import fable.python.Sample;
import java.util.Vector;
import jep.JepException;
import org.dawb.fabio.FabioFile;
import org.dawb.fabio.FableJep;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;

public class ImageUtils {
    public static void Slice2DLine(int n, int n2, int n3, int n4, int n5) {
        final int n6 = n;
        final int n7 = n2;
        final int n8 = n3;
        final int n9 = n4;
        final int n10 = n5;
        Job job = new Job("Make 1D Slice"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                final Sample sample = SampleController.getController().getCurrentsample();
                Vector vector = sample.getFilteredfiles();
                Vector vector2 = SampleNavigatorView.view.getSelectedFilesIndex();
                iProgressMonitor.beginTask("Make 1D Slice", vector2.size());
                try {
                    FableJep fableJep = FableJep.getFableJep();
                    final int n = vector2.size();
                    int n2 = Math.abs(n9 - n7);
                    int n3 = Math.abs(n8 - n6);
                    final int n4 = n2 > n3 ? n2 : n3;
                    float[] fArray = new float[n * n4];
                    int n5 = 0;
                    while (n5 < vector2.size()) {
                        if (iProgressMonitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        try {
                            float[] fArray2 = ImageUtils.SelectLine(((FabioFile)vector.elementAt((Integer)vector2.elementAt(n5))).getImageAsFloat(fableJep), ((FabioFile)vector.elementAt((Integer)vector2.elementAt(n5))).getWidth(), ((FabioFile)vector.elementAt((Integer)vector2.elementAt(n5))).getHeight(), n6, n7, n8, n9, n10);
                            int n62 = 0;
                            while (n62 < n4) {
                                fArray[n62 * n + n5] = fArray2[n62];
                                ++n62;
                            }
                        }
                        catch (JepException jepException) {
                            FableUtils.excNoTraceMsg((Object)((Object)this), (String)"Error using Jep", (Throwable)jepException);
                        }
                        iProgressMonitor.worked(1);
                        ++n5;
                    }
                    fableJep.close();
                    final float[] fArray3 = fArray;
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ImageView imageView = (ImageView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.ImageView", "Slice 2D", 1);
                                imageView.getImage().changeImageRect(new Rectangle(0, 0, n, n4), fArray3, sample.getDirectoryName(), null);
                                imageView.setPartName(String.valueOf(imageView.getSecondaryId()) + " " + sample.getDirectoryName());
                            }
                            catch (PartInitException partInitException) {
                                FableUtils.excMsg((Object)this, (String)"Error opening Slice2DImageView", (Throwable)partInitException);
                            }
                        }
                    });
                }
                catch (Throwable throwable) {
                    FableUtils.excNoTraceMsg((Object)((Object)this), (String)"Error using Jep", (Throwable)throwable);
                }
                iProgressMonitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    public static void Slice2DArea(int n, int n2, int n3, int n4) {
        final int n5 = n;
        final int n6 = n2;
        final int n7 = n3;
        final int n8 = n4;
        Job job = new Job("Make 2D Slice of Selected Area"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                final Sample sample = SampleController.getController().getCurrentsample();
                Vector vector = sample.getFilteredfiles();
                Vector vector2 = SampleNavigatorView.view.getSelectedFilesIndex();
                iProgressMonitor.beginTask("Read " + vector2.size() + " files and select area [" + n5 + "," + n6 + "] to [" + n7 + "," + n8 + "] ...", vector2.size());
                Logger logger = FableLogger.getLogger(ImageUtils.class);
                try {
                    FableJep fableJep = FableJep.getFableJep();
                    int n = Math.abs(n7 - n5);
                    int n2 = Math.abs(n8 - n6);
                    logger.debug("selected width " + n + " height " + n2);
                    final int n3 = vector2.size() * n;
                    final int n4 = n2;
                    float[] fArray = new float[n3 * n4];
                    logger.debug("image width " + n3 + " height " + n4);
                    int n52 = 0;
                    while (n52 < vector2.size()) {
                        if (iProgressMonitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        try {
                            iProgressMonitor.subTask("Reading file " + n52 + " " + ((FabioFile)vector.elementAt((Integer)vector2.elementAt(n52))).getFileName() + " ...");
                            float[] fArray2 = ImageUtils.SelectArea(((FabioFile)vector.elementAt((Integer)vector2.elementAt(n52))).getImageAsFloat(fableJep), ((FabioFile)vector.elementAt((Integer)vector2.elementAt(n52))).getWidth(), ((FabioFile)vector.elementAt((Integer)vector2.elementAt(n52))).getHeight(), n5, n6, n7, n8);
                            int n62 = 0;
                            while (n62 < n) {
                                int n72 = 0;
                                while (n72 < n2) {
                                    float f;
                                    fArray[n72 * n3 + n52 * n + n62] = f = fArray2[n72 * n + n62];
                                    ++n72;
                                }
                                ++n62;
                            }
                        }
                        catch (JepException jepException) {
                            FableUtils.excNoTraceMsg((Object)((Object)this), (String)"Error using Jep", (Throwable)jepException);
                        }
                        iProgressMonitor.worked(1);
                        ++n52;
                    }
                    fableJep.close();
                    final float[] fArray3 = fArray;
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ImageView imageView = (ImageView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.ImageView", "Slice 2D", 1);
                                imageView.getImage().changeImageRect(new Rectangle(0, 0, n3, n4), fArray3, sample.getDirectoryName(), null);
                                imageView.setPartName(String.valueOf(imageView.getSecondaryId()) + " " + sample.getDirectoryName());
                            }
                            catch (PartInitException partInitException) {
                                FableUtils.excMsg((Object)this, (String)"Error opening Slice2DImageView", (Throwable)partInitException);
                            }
                        }
                    });
                }
                catch (Throwable throwable) {
                    FableUtils.excNoTraceMsg((Object)((Object)this), (String)"Error using Jep", (Throwable)throwable);
                }
                iProgressMonitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private static float[] SelectArea(float[] fArray, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        float[] fArray2 = null;
        if (n3 > n5) {
            n7 = n3;
            n3 = n5;
            n5 = n7;
        }
        if (n4 > n6) {
            n7 = n4;
            n4 = n6;
            n6 = n7;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 >= n) {
            n3 = n - 1;
        }
        if (n5 <= n3) {
            n5 = n3 + 1;
        }
        if (n5 >= n) {
            n5 = n - 1;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (n4 >= n2) {
            n4 = n2 - 1;
        }
        if (n6 <= n4) {
            n6 = n4 + 1;
        }
        if (n6 >= n2) {
            n6 = n2 - 1;
        }
        n7 = n5 - n3;
        int n8 = n6 - n4;
        fArray2 = new float[n7 * n8];
        float f = Float.MAX_VALUE;
        float f2 = Float.MIN_VALUE;
        int n9 = 0;
        while (n9 < n7) {
            int n10 = 0;
            while (n10 < n8) {
                fArray2[n9 + n10 * n7] = fArray[n3 + n9 + (n4 + n10) * n];
                if (fArray2[n9 + n10 * n7] < f) {
                    f = fArray2[n9 + n10 * n7];
                }
                if (fArray2[n9 + n10 * n7] > f2) {
                    f2 = fArray2[n9 + n10 * n7];
                }
                float cfr_ignored_0 = fArray2[n9 + n10 * n7];
                ++n10;
            }
            ++n9;
        }
        return fArray2;
    }

    private static float[] SelectLine(float[] fArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        float[] fArray2;
        int n8;
        if (Math.abs(n5 - n3) > Math.abs(n6 - n4)) {
            if (n3 > n5) {
                n8 = n3;
                n3 = n5;
                n5 = n8;
                n8 = n4;
                n4 = n6;
                n6 = n8;
            }
        } else if (n4 > n6) {
            n8 = n3;
            n3 = n5;
            n5 = n8;
            n8 = n4;
            n4 = n6;
            n6 = n8;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        if (n3 >= n) {
            n3 = n - 1;
        }
        if (n5 >= n) {
            n5 = n - 1;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if (n4 >= n2) {
            n4 = n2 - 1;
        }
        if (n6 >= n2) {
            n6 = n2 - 1;
        }
        float f = 0.0f;
        if (n5 - n3 > n6 - n4) {
            fArray2 = new float[n5 - n3];
            if (n5 - n3 != 0) {
                f = (float)(n6 - n4) / (float)(n5 - n3);
            }
            int n9 = 0;
            while (n9 < n5 - n3) {
                int n10;
                int n11 = (int)((float)n4 + f * (float)n9);
                int n12 = n3 + n9;
                int n13 = n11 - (int)((double)n7 / 2.0);
                if (n13 < 0) {
                    n13 = 0;
                }
                if ((n10 = n11 + (int)((double)n7 / 2.0) + 1) > n2) {
                    n10 = n2;
                }
                float f2 = n10 - n13;
                int n14 = n13;
                while (n14 < n10) {
                    int n15 = n9;
                    fArray2[n15] = fArray2[n15] + fArray[n12 + n14 * n];
                    ++n14;
                }
                fArray2[n9] = fArray2[n9] / f2;
                ++n9;
            }
        } else {
            fArray2 = new float[n6 - n4];
            if (n6 - n4 != 0) {
                f = (float)(n5 - n3) / (float)(n6 - n4);
            }
            int n16 = 0;
            while (n16 < n6 - n4) {
                int n17;
                int n18 = (int)((float)n3 + f * (float)n16);
                int n19 = n4 + n16;
                int n20 = n18 - (int)((double)n7 / 2.0);
                if (n20 < 0) {
                    n20 = 0;
                }
                if ((n17 = n18 + (int)((double)n7 / 2.0) + 1) > n) {
                    n17 = n;
                }
                float f3 = n17 - n20;
                int n21 = n20;
                while (n21 < n17) {
                    int n22 = n16;
                    fArray2[n22] = fArray2[n22] + fArray[n21 + n19 * n];
                    ++n21;
                }
                fArray2[n16] = fArray2[n16] / f3;
                ++n16;
            }
        }
        return fArray2;
    }

    public static ImageComponent getComponentFromPartSelected() {
        IEditorPart iEditorPart = EclipseUtils.getActiveEditor();
        if (iEditorPart != null && iEditorPart instanceof ImageEditor) {
            return ((ImageEditor)iEditorPart).getImageComponent();
        }
        ImageView imageView = (ImageView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference("fable.imageviewer.views.ImageView", "Slice 2D").getView(true);
        if (imageView != null) {
            return imageView.getImageComponent();
        }
        return null;
    }
}

