/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.internal;

import fable.imageviewer.internal.IImagesVarKeys;
import java.text.NumberFormat;
import org.eclipse.swt.graphics.Point;

public class Coordinates
implements IImagesVarKeys {
    private double x0;
    private double y0;
    private double pixelWidth;
    private double pixelHeight;
    private String xName;
    private String yName;
    private int type;

    public Coordinates() {
        this.resetToDefault();
    }

    public Coordinates(int n, double d, double d2) {
        this.reset(n, d, d2);
    }

    public Coordinates(int n, double d, double d2, double d3, double d4, String string, String string2) {
        this.reset(n, d, d2, d3, d4, string, string2);
    }

    public void resetToDefault() {
        this.x0 = 0.0;
        this.y0 = 0.0;
        this.pixelWidth = 1.0;
        this.pixelHeight = 1.0;
        this.xName = "x";
        this.yName = "y";
        this.type = 0;
    }

    public void reset(int n, double d, double d2) {
        this.type = n;
        if (n == 4) {
            return;
        }
        this.xName = "x";
        this.yName = "y";
        switch (n) {
            case 0: {
                this.y0 = 0.0;
                this.x0 = 0.0;
                this.pixelWidth = 1.0;
                this.pixelHeight = 1.0;
                break;
            }
            case 1: {
                this.x0 = d == 0.0 ? 0.0 : d - 1.0;
                this.y0 = 0.0;
                this.pixelWidth = -1.0;
                this.pixelHeight = 1.0;
                break;
            }
            case 2: {
                this.x0 = d == 0.0 ? 0.0 : d - 1.0;
                this.y0 = d2 == 0.0 ? 0.0 : d2 - 1.0;
                this.pixelWidth = -1.0;
                this.pixelHeight = -1.0;
                break;
            }
            case 3: {
                this.x0 = 0.0;
                this.y0 = d2 == 0.0 ? 0.0 : d2 - 1.0;
                this.pixelWidth = 1.0;
                this.pixelHeight = -1.0;
            }
        }
    }

    public void reset(int n, double d, double d2, double d3, double d4, String string, String string2) {
        if (n != 4) {
            this.reset(n, d3, d4);
            return;
        }
        this.type = n;
        this.x0 = d;
        this.y0 = d2;
        this.pixelWidth = d3;
        this.pixelHeight = d4;
        this.xName = string;
        this.yName = string2;
    }

    public double[] getCoordinatesFromOriented(Point point) {
        double d = this.pixelWidth * ((double)point.x - this.x0);
        double d2 = this.pixelHeight * ((double)point.y - this.y0);
        return new double[]{d, d2};
    }

    public String getCoordinateString(int n, int n2) {
        double d = this.pixelWidth * ((double)n - this.x0);
        double d2 = this.pixelHeight * ((double)n2 - this.y0);
        if (this.type == 4) {
            return String.format("%s=%g, %s=%g", this.xName, d, this.yName, d2);
        }
        return String.format("%s=%d, %s=%d", this.xName, (int)(d + 0.5), this.yName, (int)(d2 + 0.5));
    }

    public String getCoordinateString(int n, int n2, float f) {
        double d = this.pixelWidth * ((double)n - this.x0);
        double d2 = this.pixelHeight * ((double)n2 - this.y0);
        StringBuilder stringBuilder = new StringBuilder();
        if (this.type == 4) {
            stringBuilder.append(String.format("%s=%g %s=%g value=", this.xName, d, this.yName, d2));
        } else {
            stringBuilder.append(String.format("%s=%d %s=%d value=", this.xName, (int)(d + 0.5), this.yName, (int)(d2 + 0.5)));
        }
        stringBuilder.append(NumberFormat.getNumberInstance().format(f));
        return stringBuilder.toString();
    }

    public boolean isXInverted() {
        return this.pixelWidth < 0.0;
    }

    public boolean isYInverted() {
        return this.pixelHeight < 0.0;
    }

    public double getX0() {
        return this.x0;
    }

    public double getY0() {
        return this.y0;
    }

    public double getPixelWidth() {
        return this.pixelWidth;
    }

    public double getPixelHeight() {
        return this.pixelHeight;
    }

    public String getXName() {
        return this.xName;
    }

    public String getYName() {
        return this.yName;
    }

    public int getType() {
        return this.type;
    }
}

