/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.editor;

import fable.framework.logging.FableLogger;
import fable.framework.toolbox.ActionBarWrapper;
import fable.framework.toolbox.EclipseUtils;
import fable.framework.toolbox.GridUtils;
import fable.imageviewer.component.ActionsProvider;
import fable.imageviewer.component.ImageComponent;
import fable.imageviewer.component.ImageComponentImage;
import fable.imageviewer.component.ImagePlay;
import fable.imageviewer.model.ImageModelFactory;
import fable.imageviewer.rcp.Activator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IActionBars2;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPart3;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class ImageEditor
extends EditorPart
implements IReusableEditor,
ActionsProvider {
    public static final String ID = "fable.imageviewer.editor.ImageEditor";
    private ImageComponent imageComponent;
    private ActionBarWrapper actionBarsWrapper;

    public void createPartControl(Composite composite) {
        composite.setLayout((Layout)new GridLayout(1, false));
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(3, false));
        composite2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Text text = new Text(composite2, 16384);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        text.setEditable(false);
        GridUtils.setVisible((Control)text, (boolean)true);
        text.setBackground(composite2.getBackground());
        final MenuManager menuManager = new MenuManager();
        ToolBarManager toolBarManager = new ToolBarManager(0x820000);
        final ToolBar toolBar = toolBarManager.createControl(composite2);
        toolBar.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        Action action = new Action("", Activator.getImageDescriptor("/icons/DropDown.png")){

            public void run() {
                Menu menu = menuManager.createContextMenu((Control)toolBar);
                menu.setVisible(true);
            }
        };
        IActionBars iActionBars = this.getEditorSite().getActionBars();
        this.actionBarsWrapper = new ActionBarWrapper((IToolBarManager)toolBarManager, (IMenuManager)menuManager, null, (IActionBars2)iActionBars);
        Composite composite3 = new Composite(composite, 0);
        composite3.setLayoutData((Object)new GridData(4, 4, true, true));
        this.imageComponent = new ImageComponent((IWorkbenchPart3)this);
        this.imageComponent.setStatusLabel(text);
        this.imageComponent.createPartControl(composite3);
        ImagePlay.setView(this.getImageComponent());
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ImageEditor.this.loadFile();
            }
        });
        GridUtils.removeMargins((Composite)composite3);
        GridUtils.removeMargins((Composite)composite2);
        GridUtils.removeMargins((Composite)composite);
        toolBarManager.add((IAction)action);
        toolBarManager.update(true);
    }

    public void setFocus() {
        if (this.imageComponent != null) {
            this.imageComponent.setFocus();
        }
    }

    public void dispose() {
        if (this.imageComponent != null) {
            this.imageComponent.dispose();
        }
    }

    public ImageComponentImage getImage() {
        return this.imageComponent.getImage();
    }

    public void setPartName(String string) {
        super.setPartName(string);
    }

    public ImageComponent getImageComponent() {
        return this.imageComponent;
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        this.setSite((IWorkbenchPartSite)iEditorSite);
        this.setInput(iEditorInput);
        this.setPartName(iEditorInput.getName());
    }

    public void setInput(IEditorInput iEditorInput) {
        super.setInput(iEditorInput);
        this.setPartName(iEditorInput.getName());
        this.loadFile();
    }

    private void loadFile() {
        if (this.imageComponent != null && this.getEditorInput() != null) {
            String string = EclipseUtils.getFilePath((IEditorInput)this.getEditorInput());
            try {
                this.imageComponent.loadModel(ImageModelFactory.getImageModel(string));
            }
            catch (Throwable throwable) {
                FableLogger.error((String)("Cannot load file " + string), (Throwable)throwable);
            }
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    @Override
    public IActionBars getActionBars() {
        return this.actionBarsWrapper;
    }
}

