/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.component;

import fable.framework.logging.FableLogger;
import fable.framework.toolbox.CheckableActionGroup;
import fable.framework.toolbox.FableUtils;
import fable.framework.toolbox.GridUtils;
import fable.framework.toolbox.MenuAction;
import fable.framework.toolbox.SWTUtils;
import fable.imageviewer.actions.ImageViewActions;
import fable.imageviewer.component.ImageComponent;
import fable.imageviewer.component.ImageComponentImage;
import fable.imageviewer.internal.Coordinates;
import fable.imageviewer.internal.CustomCoordinatesDialog;
import fable.imageviewer.internal.IImagesVarKeys;
import fable.imageviewer.internal.ZoomSelection;
import fable.imageviewer.rcp.Activator;
import java.text.NumberFormat;
import java.text.ParseException;
import org.dawb.common.ui.image.PaletteFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.PlatformUI;

public class ImageComponentUI
implements IImagesVarKeys {
    private static final boolean ADD_DEBUG_ACTIONS = false;
    public static final int DEFAULT_MARKER_SIZE = 3;
    ImageComponent iv = null;
    private ImageComponentImage image = null;
    private Composite controlComposite = null;
    private boolean controlCompositeShowing = true;
    private boolean legendShowing = false;
    private Display display;
    private MenuAction coordCombo;
    private MenuAction orientCombo;
    private MenuAction lutCombo;
    private Action aspectButton;
    private Action peaksButton;
    private Action autoscaleButton;
    private CCombo peakMarkerSizeText = null;
    private Text userMinimumText = null;
    private Text userMaximumText = null;
    private Text fileNumberText = null;
    private Text statusLabel = null;
    private CLabel titleLabel;
    private Canvas imageCanvas;
    private Composite statusGroup;
    private static NumberFormat decimalFormat = NumberFormat.getNumberInstance();
    static boolean customSavedParametersInitialized = false;
    private ImageViewActions actions;
    private boolean off = false;
    private Composite titleComponent;
    private Composite legendComposite;
    private Canvas canvaslegend;
    private static int canvaslegendsize;
    public static GC legendCanvasGC;

    public ImageComponentUI(ImageComponent imageComponent) {
        this.iv = imageComponent;
    }

    public String toString() {
        return "Image UI for " + this.iv.getParentPart().getPartName();
    }

    public void createControls(Composite composite) {
        if (this.iv == null) {
            return;
        }
        this.image = new ImageComponentImage(this.iv, this);
        this.actions = new ImageViewActions(this.iv, this, this.image);
        this.iv.setZoomSelection(ZoomSelection.AREA);
        this.display = this.iv.getDisplay();
        composite.setLayout((Layout)new GridLayout(1, false));
        this.titleComponent = new Composite(composite, 16384);
        this.titleComponent.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.titleComponent.setLayout((Layout)new GridLayout(2, false));
        this.titleLabel = new CLabel(this.titleComponent, 16384);
        this.titleLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Link link = new Link(this.titleComponent, 0);
        link.setLayoutData((Object)new GridData(131072, 128, false, false));
        link.setText("<a>hide</a>");
        link.setToolTipText("Hide title and intensity information.");
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ((ImageComponentUI)ImageComponentUI.this).actions.controlPanelAction.run();
            }
        });
        GridUtils.setVisible((Control)this.titleComponent, (boolean)false);
        if (this.statusLabel == null) {
            this.statusLabel = new Text(composite, 16384);
            this.statusLabel.setLayoutData((Object)new GridData(4, 16384, true, false));
            this.statusLabel.setEditable(false);
            this.statusLabel.setBackground(composite.getBackground());
        }
        if (this.iv.getSecondaryId().equals("Main")) {
            this.iv.getController().addPropertyChangeListener((IPropertyChangeListener)this.iv);
        }
        this.createZoomActions(this.iv.getActionBars());
        this.createImageControlSwitches(this.iv.getActionBars());
        this.createImageControlMenus(this.iv.getActionBars());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 200;
        gridLayout.marginWidth = 200;
        gridLayout.verticalSpacing = 200;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        GridUtils.removeMargins((Composite)composite2);
        GridLayout gridLayout2 = new GridLayout();
        this.legendComposite = new Composite(composite2, 0);
        this.legendComposite.setLayout((Layout)gridLayout2);
        this.legendComposite.setLayoutData((Object)new GridData(0, 4, false, true, 1, 1));
        GridUtils.removeMargins((Composite)this.legendComposite);
        GridUtils.setVisible((Control)this.legendComposite, (boolean)true);
        this.image.setLegendOn(false);
        this.canvaslegend = new Canvas(this.legendComposite, 0);
        this.canvaslegend.setBackground(this.display.getSystemColor(3));
        GridData gridData = new GridData(4, 4, true, true, 1, 1);
        gridData.widthHint = canvaslegendsize = 58;
        this.canvaslegend.setLayoutData((Object)gridData);
        this.canvaslegend.layout();
        GridUtils.setVisible((Control)this.legendComposite, (boolean)false);
        GridLayout gridLayout3 = new GridLayout();
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)gridLayout3);
        composite3.setLayoutData((Object)new GridData(1808));
        GridUtils.removeMargins((Composite)composite3);
        this.imageCanvas = new Canvas(composite3, 0);
        this.image.initializeCanvas();
        this.createImageControlUI(composite);
        this.contributeToActionBars();
        this.createContextMenu();
        this.iv.getParentPart().getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this.iv);
    }

    public Canvas getCanvaslegend() {
        return this.canvaslegend;
    }

    public void setTitle(String string) {
        if (this.titleLabel.isDisposed()) {
            return;
        }
        if (string == null) {
            GridUtils.setVisible((Control)this.titleComponent, (boolean)false);
        } else {
            this.titleLabel.setText(string);
            GridUtils.setVisible((Control)this.titleComponent, (boolean)true);
        }
        this.titleComponent.getParent().layout(new Control[]{this.titleComponent});
    }

    public void dispose() {
        if (this.coordCombo != null) {
            this.coordCombo.dispose();
        }
        if (this.orientCombo != null) {
            this.orientCombo.dispose();
        }
        if (this.peakMarkerSizeText != null) {
            this.peakMarkerSizeText.dispose();
        }
        if (this.userMinimumText != null) {
            this.userMinimumText.dispose();
        }
        if (this.userMaximumText != null) {
            this.userMaximumText.dispose();
        }
        if (this.fileNumberText != null) {
            this.fileNumberText.dispose();
        }
        if (this.statusLabel != null) {
            this.statusLabel.dispose();
        }
        if (this.imageCanvas != null) {
            this.imageCanvas.dispose();
        }
        if (this.statusGroup != null) {
            this.statusGroup.dispose();
        }
    }

    private void createZoomActions(IActionBars iActionBars) {
        IToolBarManager iToolBarManager = iActionBars.getToolBarManager();
        iToolBarManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + ".zoomapply"));
        iToolBarManager.add((IAction)this.actions.zoomApplyAction);
        iToolBarManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + ".zoom"));
        iToolBarManager.add((IAction)this.actions.zoomAreaAction);
        iToolBarManager.add((IAction)this.actions.zoomLineAction);
        iToolBarManager.add((IAction)this.actions.zoomProfileAction);
        iToolBarManager.add((IAction)this.actions.zoomReliefAction);
        iToolBarManager.add((IAction)this.actions.zoomNone);
    }

    private void createImageControlUI(Composite composite) {
        this.controlComposite = new Composite(composite, 0);
        this.controlComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.controlComposite.setLayout((Layout)new GridLayout(7, false));
        GridUtils.removeMargins((Composite)this.controlComposite);
        Label label = new Label(this.controlComposite, 0);
        label.setText("Min Intensity ");
        label.setToolTipText("The minimum intensity used by the palette");
        GridData gridData = new GridData(4, 0x1000000, false, false);
        gridData.widthHint = 60;
        this.userMinimumText = new Text(this.controlComposite, 133120);
        this.userMinimumText.setText("0");
        this.userMinimumText.setLayoutData((Object)gridData);
        this.userMinimumText.setToolTipText("The minimum intensity used by the palette");
        this.userMinimumText.setBackground(this.display.getSystemColor(1));
        this.userMinimumText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                if (ImageComponentUI.this.userMinimumText == null || ImageComponentUI.this.userMinimumText.isDisposed()) {
                    return;
                }
                if (!ImageComponentUI.this.userMinimumText.isEnabled() || ImageComponentUI.this.off) {
                    return;
                }
                ImageComponentUI.this.updateIntensity();
            }
        });
        boolean bl = Activator.getDefault().getPreferenceStore().getBoolean("fable.imageviewer.preferences.autoScale");
        this.userMinimumText.setEnabled(!bl);
        label = new Label(this.controlComposite, 133120);
        label.setText("  Max Intensity ");
        label.setToolTipText("The maximum intensity used by the palette");
        this.userMaximumText = new Text(this.controlComposite, 133120);
        this.userMaximumText.setLayoutData((Object)gridData);
        this.userMaximumText.setToolTipText("The maximum intensity used by the palette");
        this.userMaximumText.setText("0");
        this.userMaximumText.setBackground(this.display.getSystemColor(1));
        this.userMaximumText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                if (ImageComponentUI.this.userMaximumText == null || ImageComponentUI.this.userMaximumText.isDisposed()) {
                    return;
                }
                if (!ImageComponentUI.this.userMaximumText.isEnabled() || ImageComponentUI.this.off) {
                    return;
                }
                ImageComponentUI.this.updateIntensity();
            }
        });
        this.userMaximumText.setEnabled(!bl);
        label = new Label(this.controlComposite, 0);
        label.setText("  Marker Size ");
        label.setToolTipText("Set the size of the markers used to mark peaks (must be odd)");
        this.peakMarkerSizeText = new CCombo(this.controlComposite, 133128);
        this.peakMarkerSizeText.setItems(new String[]{"1", "3", "5", "7", "9"});
        this.peakMarkerSizeText.setText(Integer.toString(this.iv.getPeakMarkerSize()));
        this.peakMarkerSizeText.setToolTipText("Set the size of the markers used to mark peaks (must be odd)");
        this.peakMarkerSizeText.setBackground(this.display.getSystemColor(1));
        this.peakMarkerSizeText.setLayoutData((Object)gridData);
        this.peakMarkerSizeText.addListener(24, new Listener(){

            /*
             * Unable to fully structure code
             */
            public void handleEvent(Event var1_1) {
                block9: {
                    if (ImageComponentUI.access$5(ImageComponentUI.this) == null || ImageComponentUI.access$5(ImageComponentUI.this).isDisposed()) {
                        return;
                    }
                    if (!ImageComponentUI.access$5(ImageComponentUI.this).isEnabled() || ImageComponentUI.access$2(ImageComponentUI.this)) {
                        return;
                    }
                    ImageComponentUI.access$6(ImageComponentUI.this, true);
                    var2_2 = ImageComponentUI.access$5(ImageComponentUI.this).getText();
                    var3_3 = Integer.parseInt(var2_2);
                    if (var3_3 > 0) break block9;
                    SWTUtils.errMsg((Shell)ImageComponentUI.access$7(ImageComponentUI.this).getActiveShell(), (String)"Marker size must be positive");
                    ImageComponentUI.this.iv.setPeakMarkerSize(var3_3);
                    ImageComponentUI.access$5(ImageComponentUI.this).setText(Integer.toString(3));
lbl13:
                    // 2 sources

                    while (true) {
                        ImageComponentUI.access$6(ImageComponentUI.this, false);
                        return;
                    }
                }
                try {
                    try {
                        if (var3_3 % 2 == 0) {
                            SWTUtils.errMsg((Shell)ImageComponentUI.access$7(ImageComponentUI.this).getActiveShell(), (String)"Marker size must be odd to center the marker");
                            ImageComponentUI.this.iv.setPeakMarkerSize(3);
                            ImageComponentUI.access$5(ImageComponentUI.this).setText(Integer.toString(3));
                            ** continue;
                        }
                        ImageComponentUI.this.iv.setPeakMarkerSize(var3_3);
                    }
                    catch (NumberFormatException v0) {
                        ImageComponentUI.access$7(ImageComponentUI.this).beep();
                        ImageComponentUI.access$6(ImageComponentUI.this, false);
                    }
                }
                catch (Throwable var4_4) {
                    ImageComponentUI.access$6(ImageComponentUI.this, false);
                    throw var4_4;
                }
                ImageComponentUI.access$6(ImageComponentUI.this, false);
                ImageComponentUI.access$8(ImageComponentUI.this).displayImage();
            }
        });
    }

    private void updateIntensity() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ImageComponentUI.this.resetAutoscale(false);
                ImageComponentUI.this.image.displayImage();
            }
        });
    }

    private void createImageControlSwitches(IActionBars iActionBars) {
        IToolBarManager iToolBarManager = iActionBars.getToolBarManager();
        iToolBarManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + ".switches1"));
        iToolBarManager.add((IAction)this.actions.showHeaderTableAction);
        iToolBarManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + ".switches2"));
        this.autoscaleButton = new Action("Autoscale Intensity", 2){

            public void run() {
                ImageComponentUI.this.resetAutoscale(true);
                ImageComponentUI.this.image.displayImage();
            }
        };
        iToolBarManager.add((IAction)this.autoscaleButton);
        this.autoscaleButton.setText("Autoscale Intensity");
        this.autoscaleButton.setToolTipText("Scale the palette between the minimum and maximum intensity in the data");
        this.autoscaleButton.setChecked(Activator.getDefault().getPreferenceStore().getBoolean("fable.imageviewer.preferences.autoScale"));
        this.autoscaleButton.setImageDescriptor(Activator.getImageDescriptor("/icons/autoscale.png"));
        this.aspectButton = new Action("Keep Aspect", 2){

            public void run() {
                Activator.getDefault().getPreferenceStore().setValue("fable.imageviewer.preferences.keepAspectRatio", this.isChecked());
                ImageComponentUI.this.image.clearCanvas();
                ImageComponentUI.this.image.displayImage();
            }
        };
        iToolBarManager.add((IAction)this.aspectButton);
        this.aspectButton.setText("Keep Aspect");
        this.aspectButton.setToolTipText("Keep aspect ratio when displaying image");
        boolean bl = Activator.getDefault().getPreferenceStore().getBoolean("fable.imageviewer.preferences.keepAspectRatio");
        this.aspectButton.setChecked(bl);
        this.aspectButton.setImageDescriptor(Activator.getImageDescriptor("/icons/aspect.gif"));
        this.peaksButton = new Action("Show Peaks", 2){

            public void run() {
                ImageComponentUI.this.iv.setPeaksOn(ImageComponentUI.this.peaksButton.isChecked());
                ImageComponentUI.this.image.displayImage();
            }
        };
        iToolBarManager.add((IAction)this.peaksButton);
        this.peaksButton.setText("Show Peaks");
        this.peaksButton.setToolTipText("Display peaks");
        this.peaksButton.setChecked(this.iv.isPeaksOn());
        this.peaksButton.setImageDescriptor(Activator.getImageDescriptor("/icons/chart_curve_go.png"));
    }

    private void createImageControlMenus(IActionBars iActionBars) {
        int n;
        IMenuManager iMenuManager = iActionBars.getMenuManager();
        iMenuManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + "menus"));
        IPreferenceStore iPreferenceStore = Activator.getDefault().getPreferenceStore();
        int n2 = iPreferenceStore.getInt("orientationPreference");
        this.iv.setOrientation(n2);
        this.orientCombo = new MenuAction("Orientation", false);
        this.orientCombo.setId(String.valueOf(this.getClass().getName()) + this.orientCombo.getText());
        iMenuManager.add((IAction)this.orientCombo);
        CheckableActionGroup checkableActionGroup = new CheckableActionGroup();
        int n3 = 0;
        while (n3 < 8) {
            n = n3;
            Object object = new Action(orientNameValues[n3][0], 2){

                public void run() {
                    ImageComponentUI.this.iv.setOrientation(n);
                }
            };
            checkableActionGroup.add((IAction)object);
            this.orientCombo.add((IAction)object);
            object.setChecked(n == n2);
            ++n3;
        }
        this.orientCombo.setToolTipText("Adjust the orientation with O parameters (o11 o12 o21 o22)");
        this.orientCombo.setImageDescriptor(Activator.getImageDescriptor("/icons/orientation.gif"));
        iMenuManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + "orient"));
        if (!customSavedParametersInitialized) {
            String string = "xName";
            try {
                this.iv.setXNameSave(iPreferenceStore.getString("coordinatesXNamePreference"));
                string = "yName";
                this.iv.setYNameSave(iPreferenceStore.getString("coordinatesYNamePreference"));
                string = "x0";
                this.iv.setX0Save(Double.parseDouble(iPreferenceStore.getString("coordinatesX0Preference")));
                string = "y0";
                this.iv.setY0Save(Double.parseDouble(iPreferenceStore.getString("coordinatesY0Preference")));
                string = "pixelHeight";
                this.iv.setPixelWidthSave(Double.parseDouble(iPreferenceStore.getString("coordinatesPixelWidthPreference")));
                string = "pixelHeight";
                this.iv.setPixelHeightSave(Double.parseDouble(iPreferenceStore.getString("coordinatesPixelHeightPreference")));
                customSavedParametersInitialized = true;
            }
            catch (NumberFormatException numberFormatException) {
                FableUtils.excMsg((Object)this, (String)("Error setting custom coordinates from preferences for " + string), (Throwable)numberFormatException);
            }
        }
        int n4 = iPreferenceStore.getInt("coordinatesPreference");
        this.coordCombo = new MenuAction("Coordinates", false);
        this.coordCombo.setImageDescriptor(Activator.getImageDescriptor("/icons/coords.png"));
        this.coordCombo.setId(String.valueOf(this.getClass().getName()) + this.coordCombo.getText());
        iMenuManager.add((IAction)this.coordCombo);
        checkableActionGroup = new CheckableActionGroup();
        n = 0;
        while (n < 5) {
            final int n5 = n;
            Action action = new Action(coordNameValues[n][0], 2){

                public void run() {
                    ImageComponentUI.this.setCoordinateChoice(n5);
                }
            };
            checkableActionGroup.add((IAction)action);
            this.coordCombo.add((IAction)action);
            action.setChecked(n5 == n4);
            ++n;
        }
        this.coordCombo.setToolTipText("Select the origin of the coordinate system for mouse movement");
        iMenuManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + "coord"));
        if (n4 == 4) {
            Coordinates coordinates = this.iv.getCoordinates();
            try {
                coordinates.reset(n4, this.iv.getX0Save(), this.iv.getY0Save(), this.iv.getPixelWidthSave(), this.iv.getPixelHeightSave(), this.iv.getXNameSave(), this.iv.getYNameSave());
            }
            catch (NumberFormatException numberFormatException) {
                FableUtils.excMsg((Object)this, (String)"Error setting custom coordinates", (Throwable)numberFormatException);
                coordinates.resetToDefault();
            }
        } else {
            this.iv.resetCoordinates();
        }
        n = iPreferenceStore.getInt("palettePreference");
        this.iv.setPalette(n);
        this.lutCombo = new MenuAction("Color", false);
        this.lutCombo.setId(String.valueOf(this.getClass().getName()) + this.lutCombo.getText());
        this.lutCombo.setImageDescriptor(Activator.getImageDescriptor("/icons/color_wheel.png"));
        iMenuManager.add((IAction)this.lutCombo);
        checkableActionGroup = new CheckableActionGroup();
        for (Object object : PaletteFactory.PALETTES.keySet()) {
            Action action = new Action((String)object, 2, (String)object){
                private final /* synthetic */ String val$paletteName;
                {
                    this.val$paletteName = string2;
                    super(string, n);
                }

                public void run() {
                    int n = (Integer)PaletteFactory.PALETTES.get(this.val$paletteName);
                    ImageComponentUI.this.iv.setPalette(n);
                    this.setChecked((Integer)PaletteFactory.PALETTES.get(this.val$paletteName) == n);
                }
            };
            checkableActionGroup.add((IAction)action);
            this.lutCombo.add((IAction)action);
            action.setChecked((Integer)PaletteFactory.PALETTES.get(object) == n);
        }
        this.lutCombo.setToolTipText("Set the Color Map");
        iMenuManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + "menusend"));
    }

    protected void setCoordinateChoice(int n) {
        Object object;
        int n2 = this.iv.getCoordOrigin();
        this.iv.setCoordOrigin(n);
        if (n == 4) {
            Coordinates coordinates = this.iv.getCoordinates();
            object = coordinates.getType() == 4 ? new CustomCoordinatesDialog(this.display.getActiveShell(), coordinates.getX0(), coordinates.getY0(), coordinates.getPixelWidth(), coordinates.getPixelHeight(), coordinates.getXName(), coordinates.getYName()) : new CustomCoordinatesDialog(this.display.getActiveShell(), this.iv.getX0Save(), this.iv.getY0Save(), this.iv.getPixelWidthSave(), this.iv.getPixelHeightSave(), this.iv.getXNameSave(), this.iv.getYNameSave());
            boolean bl = object.open();
            if (bl) {
                this.iv.setX0Save(object.getX0());
                this.iv.setY0Save(object.getY0());
                this.iv.setPixelWidthSave(object.getPixelWidth());
                this.iv.setPixelHeightSave(object.getPixelHeight());
                this.iv.setXNameSave(object.getXName());
                this.iv.setYNameSave(object.getYName());
                coordinates.reset(this.iv.getCoordOrigin(), this.iv.getX0Save(), this.iv.getY0Save(), this.iv.getPixelWidthSave(), this.iv.getPixelHeightSave(), this.iv.getXNameSave(), this.iv.getYNameSave());
            } else {
                this.coordCombo.setSelected(n2);
            }
        } else {
            this.iv.resetCoordinates();
        }
        object = Activator.getDefault().getPreferenceStore();
        object.setValue("coordinatesPreference", n);
    }

    public void resetAutoscale(boolean bl) {
        boolean bl2 = this.autoscaleButton.isChecked();
        Activator.getDefault().getPreferenceStore().setValue("fable.imageviewer.preferences.autoScale", bl2);
        this.userMinimumText.setEnabled(true);
        this.userMaximumText.setEnabled(true);
        try {
            this.iv.setUserMinimum(decimalFormat.parse(this.userMinimumText.getText()).floatValue(), bl);
        }
        catch (ParseException parseException) {
            FableLogger.warn((String)("Unable to parse maximum value: " + this.userMinimumText.getText()));
        }
        try {
            this.iv.setUserMaximum(decimalFormat.parse(this.userMaximumText.getText()).floatValue(), bl);
        }
        catch (ParseException parseException) {
            FableLogger.warn((String)("Unable to parse maximum value: " + this.userMaximumText.getText()));
        }
        if (bl2) {
            this.userMinimumText.setEnabled(false);
            this.userMaximumText.setEnabled(false);
        } else {
            this.userMinimumText.setEnabled(true);
            this.userMaximumText.setEnabled(true);
        }
    }

    public void createFileNumberText() {
        if (this.fileNumberText == null) {
            this.fileNumberText = new Text(this.statusGroup, 2048);
            this.fileNumberText.setToolTipText("Go to image number");
            this.fileNumberText.setEnabled(true);
            this.fileNumberText.addListener(14, new Listener(){

                public void handleEvent(Event event) {
                    int n;
                    int n2 = Integer.parseInt(ImageComponentUI.this.fileNumberText.getText());
                    if (n2 > (n = ImageComponentUI.this.iv.getController().getCurrentsample().getFilteredfiles().size())) {
                        n2 = n - 1;
                    }
                    ImageComponentUI.this.iv.getController().setCurrentFileIndex(n2);
                }
            });
        }
    }

    private void fillLocalMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.actions.controlPanelAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.actions.drawLegendAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.actions.zoomAreaAction);
        iMenuManager.add((IAction)this.actions.zoomLineAction);
        iMenuManager.add((IAction)this.actions.zoomProfileAction);
        iMenuManager.add((IAction)this.actions.zoomReliefAction);
        iMenuManager.add((IAction)this.actions.zoomNone);
        iMenuManager.add((IAction)this.actions.resetZoomAction);
        iMenuManager.add((IContributionItem)new Separator());
        MenuManager menuManager = new MenuManager("Print");
        iMenuManager.add((IContributionItem)menuManager);
        menuManager.add((IAction)this.actions.printSetupAction);
        menuManager.add((IAction)this.actions.printPreviewAction);
        menuManager.add((IAction)this.actions.printAction);
        menuManager = new MenuManager("Edit");
        iMenuManager.add((IContributionItem)menuManager);
        menuManager.add((IAction)this.actions.copyAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.actions.resetMinMaxAction);
        iMenuManager.add((IAction)this.actions.imageInfoAction);
        iMenuManager.add((IAction)this.actions.inputSummaryAction);
    }

    private void fillLocalToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IAction)this.actions.controlPanelAction);
    }

    private void contributeToActionBars() {
        IActionBars iActionBars = this.iv.getActionBars();
        if (iActionBars != null) {
            this.fillLocalMenu(iActionBars.getMenuManager());
        }
        if (iActionBars != null) {
            this.fillLocalToolBar(iActionBars.getToolBarManager());
        }
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                ImageComponentUI.this.fillLocalMenu(iMenuManager);
            }
        });
        Menu menu = menuManager.createContextMenu(this.imageCanvas.getAccessible().getControl());
        this.imageCanvas.getAccessible().getControl().setMenu(menu);
    }

    public void setFileNumberText(String string) {
        if (this.fileNumberText != null) {
            this.fileNumberText.setText(string);
        }
    }

    public void setMinMaxText(float[] fArray) {
        this.setUserMinimumText(Float.toString(fArray[0]));
        this.setUserMaximumText(Float.toString(fArray[1]));
    }

    public float[] getMinMaxText() {
        float[] fArray = new float[2];
        try {
            fArray[0] = decimalFormat.parse(this.userMinimumText.getText()).floatValue();
            fArray[1] = decimalFormat.parse(this.userMaximumText.getText()).floatValue();
        }
        catch (ParseException parseException) {
            FableUtils.excNoTraceMsg((Object)this, (String)"Unable to read minimum and/or maximum", (Throwable)parseException);
            fArray[1] = Float.NaN;
            fArray[0] = Float.NaN;
        }
        return fArray;
    }

    public void setStatusText(String string) {
        if (this.statusLabel != null && !this.statusLabel.isDisposed()) {
            this.statusLabel.setText(" " + string);
            this.controlComposite.redraw();
        }
    }

    public Canvas getImageCanvas() {
        return this.imageCanvas;
    }

    public ImageComponentImage getImage() {
        return this.image;
    }

    public void setImage(ImageComponentImage imageComponentImage) {
        this.image = imageComponentImage;
    }

    public boolean getControlCompositeShowing() {
        return this.controlCompositeShowing;
    }

    public void setControlCompositeShowing(boolean bl) {
        this.controlCompositeShowing = bl;
        GridUtils.setVisible((Control)this.controlComposite, (boolean)bl);
        this.controlComposite.getParent().layout(new Control[]{this.controlComposite});
        if (!bl || this.titleLabel.getText() != null && !"".equals(this.titleLabel.getText())) {
            GridUtils.setVisible((Control)this.titleComponent, (boolean)bl);
            this.titleComponent.getParent().layout(new Control[]{this.titleComponent});
        }
    }

    public boolean getLegendShowing() {
        return this.legendShowing;
    }

    public void setLegendShowing(boolean bl) {
        this.legendShowing = bl;
        this.image.setLegendOn(bl);
        GridUtils.setVisible((Control)this.legendComposite, (boolean)bl);
        this.legendComposite.getParent().layout(new Control[]{this.legendComposite});
    }

    public void setFocus() {
    }

    public void setAspectSelection(boolean bl) {
        if (this.aspectButton != null) {
            this.aspectButton.setChecked(bl);
        }
    }

    public void firePeaksUpate() {
        if (this.peaksButton != null) {
            this.peaksButton.run();
        }
    }

    public void setCoordinate(int n) {
        if (this.coordCombo != null) {
            this.coordCombo.setSelected(n);
        }
    }

    public void setOrientation(int n) {
        if (this.orientCombo != null) {
            this.orientCombo.setSelected(n);
        }
    }

    public void setImageScheme(int n) {
        if (this.lutCombo != null) {
            this.lutCombo.setSelected(n);
        }
    }

    public void setAutoScale(boolean bl) {
        if (this.autoscaleButton != null) {
            this.autoscaleButton.setChecked(bl);
        }
    }

    public void setPeaks(boolean bl) {
        if (this.peaksButton != null) {
            this.peaksButton.setChecked(bl);
        }
    }

    public void setUserMinimumText(String string) {
        if (this.userMinimumText != null && !this.userMinimumText.isDisposed()) {
            try {
                this.off = true;
                this.userMinimumText.setText(string);
            }
            finally {
                this.off = false;
            }
        }
    }

    public void setUserMaximumText(String string) {
        if (this.userMaximumText != null && !this.userMaximumText.isDisposed()) {
            try {
                this.off = true;
                this.userMaximumText.setText(string);
            }
            finally {
                this.off = false;
            }
        }
    }

    public void setStatusLabel(Text text) {
        this.statusLabel = text;
    }

    public static int getCanvaslegendsize() {
        return canvaslegendsize;
    }

    public static void setCanvaslegendsize(int n) {
        canvaslegendsize = n;
    }

    static /* synthetic */ CCombo access$5(ImageComponentUI imageComponentUI) {
        return imageComponentUI.peakMarkerSizeText;
    }

    static /* synthetic */ void access$6(ImageComponentUI imageComponentUI, boolean bl) {
        imageComponentUI.off = bl;
    }

    static /* synthetic */ Display access$7(ImageComponentUI imageComponentUI) {
        return imageComponentUI.display;
    }
}

