/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.component;

import fable.framework.logging.FableLogger;
import fable.framework.navigator.controller.SampleController;
import fable.framework.toolbox.EclipseUtils;
import fable.framework.toolbox.FableUtils;
import fable.imageviewer.component.ImageComponent;
import fable.imageviewer.component.ImageComponentUI;
import fable.imageviewer.internal.IImagesVarKeys;
import fable.imageviewer.internal.ZoomSelection;
import fable.imageviewer.model.ImageModel;
import fable.imageviewer.model.ImageModelFactory;
import fable.imageviewer.rcp.Activator;
import fable.imageviewer.views.ImageView;
import fable.imageviewer.views.LineView;
import fable.imageviewer.views.ProfileView;
import fable.imageviewer.views.ReliefView;
import fable.imageviewer.views.RockingCurveView;
import java.text.DecimalFormat;
import java.util.Vector;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageComponentImage
implements IImagesVarKeys {
    private static final boolean debug = false;
    private static final boolean debug1 = false;
    private static final float ZOOMFACTOR_LARGE = 0.5f;
    private static final boolean LINEVIEW_HISTOGRAM = true;
    ImageComponent iv = null;
    private ImageComponentUI controls;
    private Canvas imageCanvas;
    private GC imageCanvasGC;
    private Image image = null;
    private Image legend = null;
    private ImageData imageData;
    private ImageData legendData;
    private Rectangle imageRect = new Rectangle(0, 0, 0, 0);
    private Rectangle origRect = new Rectangle(0, 0, 0, 0);
    private Rectangle orientedOrigRect = new Rectangle(0, 0, 0, 0);
    private Rectangle orientedRect = new Rectangle(0, 0, 0, 0);
    double xScale;
    double yScale;
    private Boolean selectingOn = false;
    private int canvasWidth;
    private int canvasHeight;
    private Boolean selectOn = false;
    private boolean imageChanged = true;
    private Boolean newSelection = true;
    private int xSelectionStart;
    private int ySelectionStart;
    private Rectangle selectedArea = new Rectangle(0, 0, 0, 0);
    private Display display;
    private static final Logger logger = LoggerFactory.getLogger(ImageComponentImage.class);
    private ImageView zoomAreaView;
    private LineView lineView;
    private ProfileView profileView;
    private ReliefView zoomReliefView;
    private RockingCurveView zoomRockingCurveView;
    private Boolean legendDraw = false;
    private Canvas canvasLegend;
    private GC legendCanvasGC;

    public ImageComponentImage(ImageComponent imageComponent, ImageComponentUI imageComponentUI) {
        this.iv = imageComponent;
        this.controls = imageComponentUI;
        imageComponent.setImage(this);
        imageComponentUI.setImage(this);
    }

    public void initializeCanvas() {
        if (this.iv == null || this.controls == null) {
            return;
        }
        this.imageCanvas = this.controls.getImageCanvas();
        this.display = this.iv.getDisplay();
        this.imageCanvas.setBackground(this.display.getSystemColor(16));
        GridData gridData = new GridData(4, 4, true, true);
        this.imageCanvas.setLayoutData((Object)gridData);
        this.canvasLegend = this.controls.getCanvaslegend();
        this.canvasLegend.setBackground(this.display.getSystemColor(16));
        this.legendCanvasGC = new GC((Drawable)this.canvasLegend);
        this.imageCanvasGC = new GC((Drawable)this.imageCanvas);
        Rectangle rectangle = this.imageCanvas.getBounds();
        this.canvasWidth = rectangle.width;
        this.canvasHeight = rectangle.height;
        this.imageCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                ImageComponentImage.this.imageCanvasGC.dispose();
            }
        });
        this.imageCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                if (ImageComponentImage.this.image == null) {
                    return;
                }
                Rectangle rectangle = ImageComponentImage.this.imageCanvas.getBounds();
                paintEvent.gc.fillRectangle(0, 0, rectangle.width, rectangle.height);
                if (ImageComponentImage.this.canvasWidth != rectangle.width || ImageComponentImage.this.canvasHeight != rectangle.height) {
                    double d = ImageComponentImage.this.xScale;
                    double d2 = ImageComponentImage.this.yScale;
                    ImageComponentImage.this.createScreenImage(ImageComponentImage.this.imageData);
                    ((ImageComponentImage)ImageComponentImage.this).selectedArea.width = (int)Math.round((double)((ImageComponentImage)ImageComponentImage.this).selectedArea.width * (d /= ImageComponentImage.this.xScale));
                    ((ImageComponentImage)ImageComponentImage.this).selectedArea.height = (int)Math.round((double)((ImageComponentImage)ImageComponentImage.this).selectedArea.height * (d2 /= ImageComponentImage.this.yScale));
                    ((ImageComponentImage)ImageComponentImage.this).selectedArea.x = (int)Math.round((double)((ImageComponentImage)ImageComponentImage.this).selectedArea.x * d);
                    ((ImageComponentImage)ImageComponentImage.this).selectedArea.y = (int)Math.round((double)((ImageComponentImage)ImageComponentImage.this).selectedArea.y * d2);
                    ImageComponentImage.this.canvasWidth = rectangle.width;
                    ImageComponentImage.this.canvasHeight = rectangle.height;
                }
                ImageComponentImage.this.displayImage();
            }
        });
        this.imageCanvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent mouseEvent) {
                block0: {
                    ZoomSelection zoomSelection;
                    block1: {
                        if (ImageComponentImage.this.image == null) break block0;
                        ImageComponentImage.this.showPixelAtCursor(mouseEvent.x, mouseEvent.y);
                        if (!ImageComponentImage.this.selectingOn.booleanValue()) break block0;
                        int n = mouseEvent.x - ImageComponentImage.this.xSelectionStart;
                        int n2 = mouseEvent.y - ImageComponentImage.this.ySelectionStart;
                        ImageComponentImage.this.imageCanvasGC.setForeground(ImageComponentImage.this.display.getSystemColor(1));
                        ImageComponentImage.this.drawImage(false);
                        zoomSelection = ImageComponentImage.this.iv.getZoomSelection();
                        if (zoomSelection != ZoomSelection.AREA && zoomSelection != ZoomSelection.PROFILE && zoomSelection != ZoomSelection.RELIEF && zoomSelection != ZoomSelection.ROCKINGCURVE) break block1;
                        Rectangle rectangle = new Rectangle(ImageComponentImage.this.xSelectionStart, ImageComponentImage.this.ySelectionStart, n, n2);
                        ImageComponentImage.this.imageCanvasGC.setLineWidth(1);
                        ImageComponentImage.this.imageCanvasGC.setXORMode(true);
                        ImageComponentImage.this.imageCanvasGC.drawRectangle(rectangle);
                        ImageComponentImage.this.imageCanvasGC.setXORMode(false);
                        break block0;
                    }
                    if (zoomSelection != ZoomSelection.LINE) break block0;
                    ImageComponentImage.this.imageCanvasGC.setXORMode(true);
                    ImageComponentImage.this.imageCanvasGC.drawLine(ImageComponentImage.this.xSelectionStart, ImageComponentImage.this.ySelectionStart, mouseEvent.x, mouseEvent.y);
                    ImageComponentImage.this.imageCanvasGC.setXORMode(false);
                }
            }
        });
        this.imageCanvas.addListener(7, new Listener(){

            public void handleEvent(Event event) {
                ImageComponentImage.this.controls.setStatusText("");
                if (ImageComponentImage.this.selectingOn.booleanValue()) {
                    ImageComponentImage.this.drawImage(false);
                    ImageComponentImage.this.selectingOn = false;
                }
            }
        });
        this.imageCanvas.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.keyCode) {
                    case 27: {
                        if (!ImageComponentImage.this.selectingOn.booleanValue()) break;
                        ImageComponentImage.this.drawImage(false);
                        ImageComponentImage.this.selectingOn = false;
                    }
                }
            }
        });
        this.imageCanvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                if (ImageComponentImage.this.selectingOn.booleanValue()) {
                    ImageComponentImage.this.drawImage(false);
                    ImageComponentImage.this.selectingOn = false;
                    ImageComponentImage.this.selectOn = false;
                }
            }

            public void mouseDown(MouseEvent mouseEvent) {
                if (ImageComponentImage.this.image == null) {
                    return;
                }
                if (mouseEvent.button == 1) {
                    if ((mouseEvent.stateMask & 0x40000) != 0) {
                        ImageComponentImage.this.selectingOn = false;
                        ImageComponentImage.this.selectOn = false;
                        ImageComponentImage.this.showZoom(mouseEvent, true);
                    } else if ((mouseEvent.stateMask & 0x20000) != 0) {
                        ImageComponentImage.this.selectingOn = false;
                        ImageComponentImage.this.selectOn = false;
                        ImageComponentImage.this.showZoom(mouseEvent, false);
                    } else if ((mouseEvent.stateMask & 0x10000) != 0) {
                        ImageComponentImage.this.selectingOn = false;
                        ImageComponentImage.this.selectOn = false;
                        ImageComponentImage.this.resetZoom();
                    } else {
                        ImageComponentImage.this.selectingOn = true;
                        ImageComponentImage.this.xSelectionStart = mouseEvent.x;
                        ImageComponentImage.this.ySelectionStart = mouseEvent.y;
                    }
                }
            }

            public void mouseUp(MouseEvent mouseEvent) {
                if (ImageComponentImage.this.image == null) {
                    return;
                }
                if (!ImageComponentImage.this.selectingOn.booleanValue()) {
                    return;
                }
                if (ImageComponentImage.this.xSelectionStart != mouseEvent.x || ImageComponentImage.this.ySelectionStart != mouseEvent.y) {
                    ((ImageComponentImage)ImageComponentImage.this).selectedArea.x = ImageComponentImage.this.xSelectionStart;
                    ((ImageComponentImage)ImageComponentImage.this).selectedArea.y = ImageComponentImage.this.ySelectionStart;
                    ((ImageComponentImage)ImageComponentImage.this).selectedArea.width = mouseEvent.x - ((ImageComponentImage)ImageComponentImage.this).selectedArea.x;
                    ((ImageComponentImage)ImageComponentImage.this).selectedArea.height = mouseEvent.y - ((ImageComponentImage)ImageComponentImage.this).selectedArea.y;
                    ImageComponentImage.this.imageCanvasGC.setForeground(ImageComponentImage.this.display.getSystemColor(1));
                    ImageComponentImage.this.drawImage(false);
                    ImageComponentImage.this.imageChanged = true;
                    ImageComponentImage.this.newSelection = true;
                    ImageComponentImage.this.showSelection(false);
                }
                ImageComponentImage.this.selectingOn = false;
            }
        });
        this.createDropTarget();
    }

    public void dispose() {
        if (this.imageCanvas != null) {
            this.imageCanvas.dispose();
        }
        if (this.image != null) {
            this.image.dispose();
        }
        if (this.legend != null) {
            this.legend.dispose();
        }
        this.zoomAreaView = null;
        this.lineView = null;
        this.profileView = null;
        this.zoomReliefView = null;
        this.zoomRockingCurveView = null;
    }

    public void calculateMainRectangles() {
        this.origRect = this.iv.getImageModel().getRect();
        this.orientedOrigRect.x = 0;
        this.orientedOrigRect.y = 0;
        switch (this.iv.getOrientation()) {
            default: {
                this.orientedRect.x = this.imageRect.x;
                this.orientedRect.y = this.imageRect.y;
                this.orientedRect.width = this.imageRect.width;
                this.orientedRect.height = this.imageRect.height;
                this.orientedOrigRect.width = this.origRect.width;
                this.orientedOrigRect.height = this.origRect.height;
                break;
            }
            case 1: {
                this.orientedRect.x = this.origRect.width - this.imageRect.width - this.imageRect.x;
                this.orientedRect.y = this.imageRect.y;
                this.orientedRect.width = this.imageRect.width;
                this.orientedRect.height = this.imageRect.height;
                this.orientedOrigRect.width = this.origRect.width;
                this.orientedOrigRect.height = this.origRect.height;
                break;
            }
            case 2: {
                this.orientedRect.x = this.imageRect.x;
                this.orientedRect.y = this.origRect.height - this.imageRect.height - this.imageRect.y;
                this.orientedRect.width = this.imageRect.width;
                this.orientedRect.height = this.imageRect.height;
                this.orientedOrigRect.width = this.origRect.width;
                this.orientedOrigRect.height = this.origRect.height;
                break;
            }
            case 3: {
                this.orientedRect.x = this.origRect.width - this.imageRect.width - this.imageRect.x;
                this.orientedRect.y = this.origRect.height - this.imageRect.height - this.imageRect.y;
                this.orientedRect.width = this.imageRect.width;
                this.orientedRect.height = this.imageRect.height;
                this.orientedOrigRect.width = this.origRect.width;
                this.orientedOrigRect.height = this.origRect.height;
                break;
            }
            case 6: {
                this.orientedRect.x = this.imageRect.y;
                this.orientedRect.y = this.imageRect.x;
                this.orientedRect.width = this.imageRect.height;
                this.orientedRect.height = this.imageRect.width;
                this.orientedOrigRect.width = this.origRect.height;
                this.orientedOrigRect.height = this.origRect.width;
                break;
            }
            case 4: {
                this.orientedRect.x = this.imageRect.y;
                this.orientedRect.y = this.origRect.width - this.imageRect.width - this.imageRect.x;
                this.orientedRect.width = this.imageRect.height;
                this.orientedRect.height = this.imageRect.width;
                this.orientedOrigRect.width = this.origRect.height;
                this.orientedOrigRect.height = this.origRect.width;
                break;
            }
            case 5: {
                this.orientedRect.x = this.origRect.height - this.imageRect.height - this.imageRect.y;
                this.orientedRect.y = this.imageRect.x;
                this.orientedRect.width = this.imageRect.height;
                this.orientedRect.height = this.imageRect.width;
                this.orientedOrigRect.width = this.origRect.height;
                this.orientedOrigRect.height = this.origRect.width;
                break;
            }
            case 7: {
                this.orientedRect.x = this.origRect.height - this.imageRect.height - this.imageRect.y;
                this.orientedRect.y = this.origRect.width - this.imageRect.width - this.imageRect.x;
                this.orientedRect.width = this.imageRect.height;
                this.orientedRect.height = this.imageRect.width;
                this.orientedOrigRect.width = this.origRect.height;
                this.orientedOrigRect.height = this.origRect.width;
            }
        }
    }

    public void showSelection(boolean bl) {
        if (!(bl || this.selectingOn.booleanValue() || this.selectOn.booleanValue())) {
            return;
        }
        ZoomSelection zoomSelection = this.iv.getZoomSelection();
        if (zoomSelection == ZoomSelection.AREA || zoomSelection == ZoomSelection.RELIEF || zoomSelection == ZoomSelection.ROCKINGCURVE) {
            if (!bl) {
                this.imageCanvasGC.setXORMode(true);
                this.imageCanvasGC.drawRectangle(this.selectedArea);
                this.imageCanvasGC.setXORMode(false);
            }
            if (this.imageChanged || bl) {
                this.showSelectedArea(this.selectedArea, true);
            }
            this.selectOn = true;
        } else if (zoomSelection == ZoomSelection.LINE) {
            if (!bl) {
                this.imageCanvasGC.setXORMode(true);
                this.imageCanvasGC.drawLine(this.selectedArea.x, this.selectedArea.y, this.selectedArea.x + this.selectedArea.width, this.selectedArea.y + this.selectedArea.height);
                this.imageCanvasGC.setLineWidth(1);
                this.imageCanvasGC.setXORMode(false);
            }
            if (this.imageChanged || bl) {
                this.showSelectedLine();
            }
            this.selectOn = true;
        } else if (zoomSelection == ZoomSelection.PROFILE) {
            if (!bl) {
                this.imageCanvasGC.drawRectangle(this.selectedArea);
            }
            if (this.imageChanged || bl) {
                this.showProfile();
            }
            this.selectOn = true;
        }
        this.newSelection = false;
        this.imageChanged = false;
    }

    public void showZoom(MouseEvent mouseEvent, boolean bl) {
        if (this.iv.getSecondaryId().equals("Main")) {
            return;
        }
        this.setSelectOn(false);
        float f = bl ? 2.0f : 0.5f;
        Rectangle rectangle = this.imageCanvas.getBounds();
        int n = (int)((float)rectangle.width * f + 0.5f);
        int n2 = (int)((float)rectangle.height * f + 0.5f);
        int n3 = mouseEvent.x - n / 2;
        int n4 = mouseEvent.y - n2 / 2;
        Rectangle rectangle2 = new Rectangle(n3, n4, n, n2);
        Rectangle rectangle3 = this.screenRectangleToImageRectangle(rectangle2, true);
        float[] fArray = !this.iv.isImageDiffOn() ? this.iv.getImageModel().getData(rectangle3) : this.iv.getImageDiffModel().getData(rectangle3);
        if (!this.iv.isImageDiffOn()) {
            this.changeImageRect(rectangle3, fArray, this.iv.getImageModel().getFileName(), this.iv.getImageModel());
        } else {
            this.changeImageRect(rectangle3, fArray, this.iv.getImageModel().getFileName(), this.iv.getImageDiffModel());
        }
    }

    public void resetZoom() {
        if (this.image == null) {
            return;
        }
        this.selectingOn = false;
        this.selectOn = false;
        this.showSelectedArea(this.origRect, false);
    }

    public void showPeaks() {
        Vector<Float> vector = this.iv.getPeaks();
        if (vector != null) {
            Color color = this.display.getSystemColor(3);
            this.imageCanvasGC.setForeground(color);
            this.imageCanvasGC.setLineWidth(1);
            Point point = new Point(0, 0);
            int n = this.iv.getPeakMarkerSize();
            int n2 = 0;
            while (n2 < vector.size() / 2) {
                point = this.tcToScreen(vector.elementAt(n2 * 2).floatValue() + 0.5f, vector.elementAt(n2 * 2 + 1).floatValue() + 0.5f);
                int n3 = point.x;
                int n4 = point.y;
                Rectangle rectangle = new Rectangle(n3 -= n / 2, n4 -= n / 2, n, n);
                this.imageCanvasGC.drawRectangle(rectangle);
                ++n2;
            }
        }
    }

    public void showSelectedPeaks(float[] fArray) {
        this.showPeaks();
        if (fArray != null) {
            Color color = this.display.getSystemColor(5);
            this.imageCanvasGC.setForeground(color);
            this.imageCanvasGC.setLineWidth(1);
            Point point = new Point(0, 0);
            int n = this.iv.getPeakMarkerSize();
            int n2 = 0;
            while (n2 < fArray.length / 2) {
                int n3 = n2 * 2;
                point = this.tcToScreen(fArray[n3] + 0.5f, fArray[n3 + 1] + 0.5f);
                int n4 = point.x;
                int n5 = point.y;
                Rectangle rectangle = new Rectangle(n4 -= n / 2, n5 -= n / 2, n, n);
                this.imageCanvasGC.drawRectangle(rectangle);
                ++n2;
            }
        }
    }

    private void showPixelAtCursor(int n, int n2) {
        if (this.iv.getImageModel() != null) {
            int n3 = (int)((double)n * this.xScale);
            int n4 = (int)((double)n2 * this.yScale);
            if (n3 < 0 || n3 >= this.orientedRect.width || n4 < 0 || n4 >= this.orientedRect.height) {
                if (this.controls != null) {
                    this.controls.setStatusText("");
                }
                return;
            }
            Point point = this.orientedToImage(new Point(n3, n4));
            int n5 = point.x;
            int n6 = point.y;
            if (n5 < 0 || n5 >= this.iv.getImageModel().getWidth() || n6 < 0 || n6 >= this.iv.getImageModel().getHeight()) {
                this.controls.setStatusText("");
                return;
            }
            float f = 0.0f;
            f = !this.iv.isImageDiffOn() ? this.iv.getImageModel().getData(n6, n5) : this.iv.getImageDiffModel().getData(n6, n5);
            if (this.controls != null) {
                this.controls.setStatusText(this.iv.getCoordinates().getCoordinateString(n3 + this.orientedRect.x, n4 + this.orientedRect.y, f));
            }
        }
    }

    private void showSelectedArea(Rectangle rectangle, boolean bl) {
        Rectangle rectangle2 = bl ? this.screenRectangleToImageRectangle(rectangle, true) : rectangle;
        try {
            float[] fArray;
            float[] fArray2 = null;
            if (!this.iv.isImageDiffOn()) {
                fArray = this.iv.getImageModel().getData(rectangle2);
                fArray2 = this.iv.getImageModel().getStatistics(rectangle2);
            } else {
                fArray = this.iv.getImageDiffModel().getData(rectangle2);
                fArray2 = this.iv.getImageDiffModel().getStatistics(rectangle2);
            }
            float f = fArray2[0];
            float f2 = fArray2[1];
            float f3 = fArray2[2];
            ZoomSelection zoomSelection = this.iv.getZoomSelection();
            IViewPart iViewPart = zoomSelection.getViewPart();
            if (iViewPart == null) {
                return;
            }
            EclipseUtils.getPage().bringToTop((IWorkbenchPart)iViewPart);
            if (zoomSelection == ZoomSelection.AREA) {
                this.zoomAreaView = (ImageView)iViewPart;
                if (this.zoomAreaView != null) {
                    this.zoomAreaView.getImage().setSelectOn(false);
                    if (!this.iv.isImageDiffOn()) {
                        this.zoomAreaView.getImage().changeImageRect(rectangle2, fArray, this.iv.getImageModel().getFileName(), this.iv.getImageModel());
                        this.zoomAreaView.setPartName(String.valueOf(this.zoomAreaView.getSecondaryId()) + " " + this.iv.getFileName());
                    } else {
                        this.zoomAreaView.getImage().changeImageRect(rectangle2, fArray, this.iv.getImageModel().getFileName(), this.iv.getImageDiffModel());
                        this.zoomAreaView.setPartName(String.valueOf(this.zoomAreaView.getSecondaryId()) + " Diff " + this.iv.getFileName());
                    }
                    this.zoomAreaView.transferSelectedSettings(this.iv);
                }
            } else if (zoomSelection == ZoomSelection.RELIEF) {
                this.zoomReliefView = (ReliefView)iViewPart;
                if (this.zoomReliefView != null) {
                    this.zoomReliefView.setImageAsFloat(fArray, rectangle2.width, rectangle2.height, f, f2, f3, this.iv.getImageModel().getFileName());
                }
            } else if (zoomSelection == ZoomSelection.ROCKINGCURVE) {
                this.zoomRockingCurveView = (RockingCurveView)iViewPart;
                if (this.zoomRockingCurveView != null) {
                    int n = rectangle2.width == 0 ? rectangle2.x : rectangle2.x + rectangle2.width - 1;
                    int n2 = rectangle2.height == 0 ? rectangle2.y : rectangle2.y + rectangle2.height - 1;
                    this.zoomRockingCurveView.setCenterArea("Rocking Curve " + this.iv.getFileName(), SampleController.getController().getCurrentFileIndex(), rectangle2.x, rectangle2.y, n, n2);
                }
            }
        }
        catch (Throwable throwable) {
            FableUtils.excMsg((Object)this, (String)"Unable to show selected area", (Throwable)throwable);
        }
    }

    private void showSelectedLine() {
        Rectangle rectangle = this.screenRectangleToOrientedImageRectangle(this.selectedArea, false);
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.x + rectangle.width - 1;
        int n4 = rectangle.y + rectangle.height - 1;
        Point point = new Point(0, 0);
        double[] dArray = new double[]{0.0, 0.0};
        boolean bl = false;
        try {
            IViewReference iViewReference;
            int n5;
            float[] fArray;
            float[] fArray2;
            int n6;
            String string;
            String string2;
            float f = Float.NaN;
            if (Math.abs(n3 - n) >= Math.abs(n4 - n2)) {
                string2 = "Pixels in " + this.iv.getCoordinates().getXName();
                string = "Intensity";
                float f2 = 0.5f * (float)this.iv.getCoordinates().getPixelWidth();
                bl = this.iv.getCoordinates().isXInverted();
                if (n3 < n) {
                    int n7 = n;
                    n = n3;
                    n3 = n7;
                    n7 = n2;
                    n2 = n4;
                    n4 = n7;
                }
                n6 = n3 - n + 1;
                fArray2 = new float[2 * n6 + 2];
                fArray = new float[2 * n6 + 2];
                fArray[2 * n6 + 1] = 0.0f;
                fArray[0] = 0.0f;
                if (n3 - n != 0) {
                    f = (float)(n4 - n2) / (float)(n3 - n);
                }
                logger.debug("slope " + f);
                n5 = 0;
                while (n5 < n6) {
                    int n8 = 2 * n5 + 1;
                    int n9 = n + n5;
                    int n10 = (int)((double)((float)n2 + f * (float)n5) + 0.5);
                    if (n10 < 0) {
                        n10 = 0;
                    }
                    if (n10 > this.orientedOrigRect.height - 1) {
                        n10 = this.orientedOrigRect.height - 1;
                    }
                    point.x = n9 + this.orientedRect.x;
                    point.y = n10 + this.orientedRect.y;
                    dArray = this.iv.getCoordinates().getCoordinatesFromOriented(point);
                    float f3 = (float)dArray[0];
                    if (n5 == 0) {
                        fArray2[0] = f3 - f2;
                    }
                    fArray2[n8] = f3 - f2;
                    fArray2[n8 + 1] = f3 + f2;
                    if (n5 == n6 - 1) {
                        fArray2[n8 + 2] = f3 + f2;
                    }
                    point.x = n9;
                    point.y = n10;
                    point = this.orientedToImage(point);
                    f3 = !this.iv.isImageDiffOn() ? this.iv.getImageModel().getData(point.y, point.x) : this.iv.getImageDiffModel().getData(point.y, point.x);
                    fArray[n8] = f3;
                    fArray[n8 + 1] = f3;
                    ++n5;
                }
            } else {
                string2 = "Pixels in " + this.iv.getCoordinates().getYName();
                string = "Intensity";
                bl = this.iv.getCoordinates().isYInverted();
                float f4 = 0.5f * (float)this.iv.getCoordinates().getPixelHeight();
                if (n4 < n2) {
                    int n11 = n;
                    n = n3;
                    n3 = n11;
                    n11 = n2;
                    n2 = n4;
                    n4 = n11;
                }
                n6 = n4 - n2 + 1;
                fArray2 = new float[2 * n6 + 2];
                fArray = new float[2 * n6 + 2];
                fArray[2 * n6 + 1] = 0.0f;
                fArray[0] = 0.0f;
                if (n3 - n != 0) {
                    f = (float)(n4 - n2) / (float)(n3 - n);
                }
                logger.debug("slope " + f);
                n5 = 0;
                while (n5 < n6) {
                    int n12 = 2 * n5 + 1;
                    int n13 = n2 + n5;
                    int n14 = n3 - n != 0 ? (int)((double)((float)n + (float)n5 / f) + 0.5) : n;
                    if (n14 < 0) {
                        n14 = 0;
                    }
                    if (n14 > this.orientedOrigRect.width - 1) {
                        n14 = this.orientedOrigRect.width - 1;
                    }
                    point.x = n14 + this.orientedRect.x;
                    point.y = n13 + this.orientedRect.y;
                    dArray = this.iv.getCoordinates().getCoordinatesFromOriented(point);
                    float f5 = (float)dArray[1];
                    if (n5 == 0) {
                        fArray2[0] = f5 - f4;
                    }
                    fArray2[n12] = f5 - f4;
                    fArray2[n12 + 1] = f5 + f4;
                    if (n5 == n6 - 1) {
                        fArray2[n12 + 2] = f5 + f4;
                    }
                    point.x = n14;
                    point.y = n13;
                    point = this.orientedToImage(point);
                    f5 = !this.iv.isImageDiffOn() ? this.iv.getImageModel().getData(point.y, point.x) : this.iv.getImageDiffModel().getData(point.y, point.x);
                    fArray[n12] = f5;
                    fArray[n12 + 1] = f5;
                    ++n5;
                }
            }
            if (this.newSelection.booleanValue()) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.LineView", null, 1);
            }
            if ((iViewReference = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference("fable.imageviewer.views.LineView")) != null) {
                this.lineView = (LineView)iViewReference.getView(true);
                if (this.lineView != null) {
                    String string3 = "unknown";
                    String string4 = "unknown";
                    point.x = n + this.orientedRect.x;
                    point.y = n2 + this.orientedRect.y;
                    string3 = this.iv.getCoordinates().getCoordinateString(point.x, point.y);
                    point.x = n3 + this.orientedRect.x;
                    point.y = n4 + this.orientedRect.y;
                    string4 = this.iv.getCoordinates().getCoordinateString(point.x, point.y);
                    string2 = String.valueOf(string2) + " from (" + string3 + ") to (" + string4 + ") for " + this.iv.getCoordinatesName();
                    this.lineView.setData(this.iv.getFileName(), string2, bl, fArray2, string, fArray);
                }
            }
        }
        catch (PartInitException partInitException) {
            FableUtils.excMsg((Object)this, (String)"Unable to show selected line", (Throwable)partInitException);
        }
    }

    private void showProfile() {
        int n;
        Rectangle rectangle = this.screenRectangleToOrientedImageRectangle(this.selectedArea, true);
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.x + rectangle.width - 1;
        int n5 = rectangle.y + rectangle.height - 1;
        if (n2 > n4) {
            n = n3;
            n2 = n4;
            n4 = n;
        }
        if (n3 > n5) {
            n = n3;
            n3 = n5;
            n5 = n;
        }
        try {
            IViewReference iViewReference;
            float f;
            int n6;
            String string = "Pixels in " + this.iv.getCoordinates().getXName();
            String string2 = "Pixels in " + this.iv.getCoordinates().getYName();
            boolean bl = this.iv.getCoordinates().isXInverted();
            boolean bl2 = this.iv.getCoordinates().isYInverted();
            double[] dArray = new double[]{0.0, 0.0};
            int n7 = n4 - n2 + 1;
            float[] fArray = new float[2 * n7 + 2];
            float[] fArray2 = new float[2 * n7 + 2];
            float f2 = 0.5f * (float)this.iv.getCoordinates().getPixelWidth();
            fArray[0] = (float)n2 - f2;
            fArray[2 * n7 + 1] = (float)n4 + f2;
            fArray2[2 * n7 + 1] = 0.0f;
            fArray2[0] = 0.0f;
            Point point = new Point(0, 0);
            Point point2 = new Point(0, 0);
            int n8 = 0;
            while (n8 < n7) {
                n6 = 2 * n8 + 1;
                point.x = n2 + n8 + this.orientedRect.x;
                point.y = n3 + this.orientedRect.y;
                dArray = this.iv.getCoordinates().getCoordinatesFromOriented(point);
                f = (float)dArray[0];
                if (n8 == 0) {
                    fArray[0] = f - f2;
                }
                fArray[n6] = f - f2;
                fArray[n6 + 1] = f + f2;
                if (n8 == n7 - 1) {
                    fArray[n6 + 2] = f + f2;
                }
                fArray2[n6 + 1] = 0.0f;
                fArray2[n6] = 0.0f;
                point.x = n2 + n8;
                int n9 = n3;
                while (n9 <= n5) {
                    point.y = n9;
                    point2 = this.orientedToImage(point);
                    f = !this.iv.isImageDiffOn() ? this.iv.getImageModel().getData(point2.y, point2.x) : this.iv.getImageDiffModel().getData(point2.y, point2.x);
                    int n10 = n6;
                    fArray2[n10] = fArray2[n10] + f;
                    int n11 = n6 + 1;
                    fArray2[n11] = fArray2[n11] + f;
                    ++n9;
                }
                ++n8;
            }
            n8 = n5 - n3 + 1;
            float[] fArray3 = new float[2 * n8 + 2];
            float[] fArray4 = new float[2 * n8 + 2];
            f2 = 0.5f * (float)this.iv.getCoordinates().getPixelHeight();
            fArray3[0] = (float)n3 - f2;
            fArray3[2 * n8 + 1] = (float)n5 + f2;
            fArray4[2 * n8 + 1] = 0.0f;
            fArray4[0] = 0.0f;
            int n12 = 0;
            while (n12 < n8) {
                n6 = 2 * n12 + 1;
                point.x = n2 + this.orientedRect.x;
                point.y = n3 + n12 + this.orientedRect.y;
                dArray = this.iv.getCoordinates().getCoordinatesFromOriented(point);
                f = (float)dArray[1];
                if (n12 == 0) {
                    fArray3[0] = f - f2;
                }
                fArray3[n6] = f - f2;
                fArray3[n6 + 1] = f + f2;
                if (n12 == n8 - 1) {
                    fArray3[n6 + 2] = f + f2;
                }
                fArray4[n6 + 1] = 0.0f;
                fArray4[n6] = 0.0f;
                point.y = n3 + n12;
                int n13 = n2;
                while (n13 <= n4) {
                    point.x = n13;
                    point2 = this.orientedToImage(point);
                    f = !this.iv.isImageDiffOn() ? this.iv.getImageModel().getData(point2.y, point2.x) : this.iv.getImageDiffModel().getData(point2.y, point2.x);
                    int n14 = n6;
                    fArray4[n14] = fArray4[n14] + f;
                    int n15 = n6 + 1;
                    fArray4[n15] = fArray4[n15] + f;
                    ++n13;
                }
                ++n12;
            }
            if (this.newSelection.booleanValue()) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.ProfileView", null, 1);
            }
            if ((iViewReference = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference("fable.imageviewer.views.ProfileView")) != null) {
                this.profileView = (ProfileView)iViewReference.getView(true);
                if (this.profileView != null) {
                    this.profileView.setData(this.iv.getFileName(), string, string2, bl, bl2, fArray, fArray2, fArray3, fArray4);
                }
            }
        }
        catch (PartInitException partInitException) {
            FableUtils.excMsg((Object)this, (String)"Unable to show profile", (Throwable)partInitException);
        }
    }

    public void changeImageRect(Rectangle rectangle, float[] fArray, String string, ImageModel imageModel) {
        if (this.imageRect.width != rectangle.width || this.imageRect.height != rectangle.height) {
            this.clearCanvas();
        } else {
            this.selectingOn = false;
            this.selectOn = false;
        }
        if (imageModel == null) {
            this.iv.setImageModel(ImageModelFactory.getImageModel(string, rectangle.width, rectangle.height, fArray));
        } else if (imageModel != this.iv.getImageModel()) {
            this.iv.setImageModel(imageModel);
        }
        this.imageRect = rectangle;
        this.calculateMainRectangles();
        this.iv.resetCoordinates();
        float[] fArray2 = this.iv.getImageModel().getStatistics(this.imageRect);
        this.iv.setStatistics(fArray2);
    }

    public void displayImage() {
        float f;
        float f2;
        if (this.iv.getImageModel() == null || this.iv.getImageModel().getData() == null) {
            return;
        }
        boolean bl = Activator.getDefault().getPreferenceStore().getBoolean("fable.imageviewer.preferences.autoScale");
        if (bl) {
            f2 = this.iv.getMinimum();
            f = 3.0f * this.iv.getMean();
            if (f > this.iv.getMaximum()) {
                f = this.iv.getMaximum();
            }
        } else {
            f2 = this.iv.getUserMinimum();
            f = this.iv.getUserMaximum();
        }
        this.imageData = this.createImageData(f2, f, this.iv.getPalette());
        this.createScreenImage(this.imageData);
        this.drawImage(true);
        if (this.legendDraw.booleanValue()) {
            this.legendData = this.createLegendData(f2, f, this.iv.getPalette());
            this.createScreenLegend(this.legendData);
            this.drawLegend(f2, f);
        }
        this.imageChanged = false;
    }

    public ImageData createImageData(float f, float f2, PaletteData paletteData) {
        float f3;
        float f4;
        float[] fArray = !this.iv.isImageDiffOn() ? this.iv.getImageModel().getData(this.imageRect) : this.iv.getImageDiffModel().getData(this.imageRect);
        int n = fArray.length;
        if (n == 0) {
            return null;
        }
        this.calculateMainRectangles();
        this.iv.resetCoordinates();
        if (f2 > f) {
            f4 = 255.0f / (f2 - f);
            f3 = f2 - f;
        } else {
            f4 = 1.0f;
            f3 = 255.0f;
        }
        byte[] byArray = new byte[n];
        Point point = new Point(0, 0);
        int n2 = 0;
        while (n2 < n) {
            float f5 = fArray[n2] < f ? 0.0f : (fArray[n2] >= f2 ? f3 : fArray[n2] - f);
            byte by = (byte)(0xFF & (int)(f5 *= f4));
            point.x = n2 % this.imageRect.width;
            point.y = n2 / this.imageRect.width;
            Point point2 = this.imageToOriented(point);
            int n3 = point2.y * this.orientedRect.width + point2.x;
            byArray[n3] = by;
            ++n2;
        }
        ImageData imageData = new ImageData(this.orientedRect.width, this.orientedRect.height, 8, paletteData, 1, byArray);
        return imageData;
    }

    public Image createScreenImage(ImageData imageData) {
        if (this.image != null && !this.image.isDisposed()) {
            this.image.dispose();
            this.image = null;
        }
        Rectangle rectangle = this.imageCanvas.getBounds();
        this.xScale = (double)this.orientedRect.width / (double)rectangle.width;
        this.yScale = (double)this.orientedRect.height / (double)rectangle.height;
        boolean bl = Activator.getDefault().getPreferenceStore().getBoolean("fable.imageviewer.preferences.keepAspectRatio");
        if (bl) {
            if (this.xScale > this.yScale) {
                this.yScale = this.xScale;
            } else {
                this.xScale = this.yScale;
            }
        }
        if ((double)this.orientedRect.width / this.xScale < 1.0) {
            this.xScale = (double)this.orientedRect.width / (double)rectangle.width;
        }
        if ((double)this.orientedRect.height / this.yScale < 1.0) {
            this.yScale = (double)this.orientedRect.height / (double)rectangle.height;
        }
        int n = (int)((double)this.orientedRect.width / this.xScale);
        int n2 = (int)((double)this.orientedRect.height / this.yScale);
        if (imageData == null) {
            logger.debug("data is null !");
            this.image = null;
        } else {
            this.image = new Image((Device)Display.getCurrent(), imageData.scaledTo(n, n2));
        }
        return this.image;
    }

    private void drawImage(boolean bl) {
        if (this.imageCanvasGC == null || this.image == null) {
            return;
        }
        this.imageCanvasGC.drawImage(this.image, 0, 0);
        if (this.iv.isPeaksOn()) {
            this.showPeaks();
        }
        if (bl && this.selectOn.booleanValue()) {
            this.showSelection(false);
        }
    }

    public ImageData createLegendData(float f, float f2, PaletteData paletteData) {
        byte[] byArray = new byte[100];
        float f3 = 255.0f;
        int n = 0;
        while (n < 100) {
            byte by;
            float f4 = f3;
            f3 -= 2.56f;
            byArray[n] = by = (byte)(0xFF & (int)f4);
            ++n;
        }
        ImageData imageData = new ImageData(1, 100, 8, paletteData, 1, byArray);
        return imageData;
    }

    public Image createScreenLegend(ImageData imageData) {
        if (this.legend != null && !this.legend.isDisposed()) {
            this.legend.dispose();
            this.legend = null;
        }
        Rectangle rectangle = this.imageCanvas.getBounds();
        rectangle.width = ImageComponentUI.getCanvaslegendsize();
        rectangle.height -= 2;
        int n = rectangle.width;
        int n2 = rectangle.height;
        if (imageData == null) {
            logger.debug("data is null !");
            this.legend = null;
        } else {
            this.legend = new Image((Device)Display.getCurrent(), imageData.scaledTo(n, n2));
        }
        return this.legend;
    }

    private void drawLegend(float f, float f2) {
        if (this.imageCanvasGC == null || this.legend == null) {
            return;
        }
        if (this.imageCanvasGC == null || this.legend == null) {
            return;
        }
        Rectangle rectangle = this.imageCanvas.getBounds();
        int n = 1;
        this.legendCanvasGC.drawImage(this.legend, 0, 0);
        Font font = new Font((Device)this.display, "Arial", 14, 3);
        this.legendCanvasGC.setFont(font);
        this.legendCanvasGC.setForeground(this.display.getSystemColor(1));
        String string = Integer.toString((int)f2);
        String string2 = null;
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat = new DecimalFormat("0.##E0");
        int n2 = string.length();
        int n3 = Float.toString(f2).length();
        string2 = decimalFormat.format(f2);
        if (n2 < 6) {
            font = new Font((Device)this.display, "Arial", 14, 3);
            this.legendCanvasGC.setFont(font);
            this.legendCanvasGC.drawText(Integer.toString((int)f2), 0, 0);
        } else if (6 <= n3) {
            font = new Font((Device)this.display, "Arial", 11, 3);
            this.legendCanvasGC.setFont(font);
            this.legendCanvasGC.drawText(string2, 0, 0);
        }
        String string3 = Integer.toString((int)f);
        String string4 = null;
        int n4 = string3.length();
        string4 = decimalFormat.format(f);
        if (n4 < 6) {
            font = new Font((Device)this.display, "Arial", 14, 3);
            this.legendCanvasGC.setFont(font);
            this.legendCanvasGC.drawText(Integer.toString((int)f), 0, rectangle.height - n - 20);
        } else if (6 <= n4) {
            font = new Font((Device)this.display, "Arial", 11, 3);
            this.legendCanvasGC.setFont(font);
            this.legendCanvasGC.drawText(string4, 0, rectangle.height - n - 20);
        }
        font.dispose();
    }

    private void createDropTarget() {
        DropTarget dropTarget = new DropTarget((Control)this.imageCanvas, 17);
        Transfer[] transferArray = new Transfer[]{TextTransfer.getInstance(), FileTransfer.getInstance()};
        dropTarget.setTransfer(transferArray);
        dropTarget.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent dropTargetEvent) {
                if (dropTargetEvent.detail == 16) {
                    dropTargetEvent.detail = (dropTargetEvent.operations & 1) != 0 ? 1 : 0;
                }
            }

            public void dragLeave(DropTargetEvent dropTargetEvent) {
            }

            public void dragOperationChanged(DropTargetEvent dropTargetEvent) {
            }

            public void dragOver(DropTargetEvent dropTargetEvent) {
            }

            public void drop(DropTargetEvent dropTargetEvent) {
                String string = null;
                if (TextTransfer.getInstance().isSupportedType(dropTargetEvent.currentDataType)) {
                    string = (String)dropTargetEvent.data;
                } else if (FileTransfer.getInstance().isSupportedType(dropTargetEvent.currentDataType)) {
                    String[] stringArray = (String[])dropTargetEvent.data;
                    string = stringArray[0];
                }
                if (string == null) {
                    return;
                }
                try {
                    ImageComponentImage.this.iv.setEditorInput(string);
                }
                catch (Throwable throwable) {
                    FableLogger.error((String)("Cannot load image " + string), (Throwable)throwable);
                }
            }

            public void dropAccept(DropTargetEvent dropTargetEvent) {
            }
        });
    }

    public Point orientedToImage(Point point) {
        int n = point.x + this.orientedRect.x;
        int n2 = point.y + this.orientedRect.y;
        int n3 = n;
        int n4 = n2;
        switch (this.iv.getOrientation()) {
            default: {
                break;
            }
            case 1: {
                n3 = this.orientedOrigRect.width - n - 1;
                break;
            }
            case 2: {
                n4 = this.orientedOrigRect.height - n2 - 1;
                break;
            }
            case 3: {
                n3 = this.orientedOrigRect.width - n - 1;
                n4 = this.orientedOrigRect.height - n2 - 1;
                break;
            }
            case 6: {
                n3 = n2;
                n4 = n;
                break;
            }
            case 4: {
                n3 = this.orientedOrigRect.height - n2 - 1;
                n4 = n;
                break;
            }
            case 5: {
                n3 = n2;
                n4 = this.orientedOrigRect.width - n - 1;
                break;
            }
            case 7: {
                n3 = this.orientedOrigRect.height - n2 - 1;
                n4 = this.orientedOrigRect.width - n - 1;
            }
        }
        Point point2 = new Point(n3, n4);
        return point2;
    }

    public Point imageToOriented(Point point) {
        int n = point.x;
        int n2 = point.y;
        int n3 = n;
        int n4 = n2;
        switch (this.iv.getOrientation()) {
            default: {
                break;
            }
            case 1: {
                n3 = this.imageRect.width - n - 1;
                break;
            }
            case 2: {
                n4 = this.imageRect.height - n2 - 1;
                break;
            }
            case 3: {
                n3 = this.imageRect.width - n - 1;
                n4 = this.imageRect.height - n2 - 1;
                break;
            }
            case 6: {
                n3 = n2;
                n4 = n;
                break;
            }
            case 5: {
                n3 = this.imageRect.height - n2 - 1;
                n4 = n;
                break;
            }
            case 4: {
                n3 = n2;
                n4 = this.imageRect.width - n - 1;
                break;
            }
            case 7: {
                n3 = this.imageRect.height - n2 - 1;
                n4 = this.imageRect.width - n - 1;
            }
        }
        return new Point(n3, n4);
    }

    public float[] imageToOriented(float[] fArray) {
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = f;
        float f4 = f2;
        switch (this.iv.getOrientation()) {
            default: {
                break;
            }
            case 1: {
                f3 = (float)this.imageRect.width - f - 1.0f;
                break;
            }
            case 2: {
                f4 = (float)this.imageRect.height - f2 - 1.0f;
                break;
            }
            case 3: {
                f3 = (float)this.imageRect.width - f - 1.0f;
                f4 = (float)this.imageRect.height - f2 - 1.0f;
                break;
            }
            case 6: {
                f3 = f2;
                f4 = f;
                break;
            }
            case 5: {
                f3 = (float)this.imageRect.height - f2 - 1.0f;
                f4 = f;
                break;
            }
            case 4: {
                f3 = f2;
                f4 = (float)this.imageRect.width - f - 1.0f;
                break;
            }
            case 7: {
                f3 = (float)this.imageRect.height - f2 - 1.0f;
                f4 = (float)this.imageRect.width - f - 1.0f;
            }
        }
        return new float[]{f3, f4};
    }

    public Rectangle screenRectangleToImageRectangle(Rectangle rectangle, boolean bl) {
        int n = rectangle.x - this.imageData.x;
        int n2 = rectangle.y - this.imageData.y;
        int n3 = (int)((double)n * this.xScale);
        int n4 = (int)((double)n2 * this.yScale);
        int n5 = rectangle.width != 0 ? (int)((double)(n + rectangle.width - 1) * this.xScale) : n3;
        int n6 = rectangle.height != 0 ? (int)((double)(n2 + rectangle.height - 1) * this.yScale) : n4;
        Point point = this.orientedToImage(new Point(n3, n4));
        Point point2 = this.orientedToImage(new Point(n5, n6));
        n3 = point.x;
        n4 = point.y;
        n5 = point2.x;
        n6 = point2.y;
        if (bl) {
            int n7;
            if (n3 > n5) {
                n7 = n3;
                n3 = n5;
                n5 = n7;
            }
            if (n4 > n6) {
                n7 = n4;
                n4 = n6;
                n6 = n7;
            }
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 >= this.origRect.width) {
            n3 = this.origRect.width - 1;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        if (n5 >= this.origRect.width) {
            n5 = this.origRect.width - 1;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (n4 >= this.origRect.height) {
            n4 = this.origRect.height - 1;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if (n6 >= this.origRect.height) {
            n6 = this.origRect.height - 1;
        }
        int n8 = n5 - n3 + 1;
        int n9 = n6 - n4 + 1;
        Rectangle rectangle2 = new Rectangle(n3, n4, n8, n9);
        return rectangle2;
    }

    public Rectangle screenRectangleToOrientedImageRectangle(Rectangle rectangle, boolean bl) {
        int n = rectangle.x - this.imageData.x;
        int n2 = rectangle.y - this.imageData.y;
        int n3 = (int)((double)n * this.xScale);
        int n4 = (int)((double)n2 * this.yScale);
        int n5 = rectangle.width != 0 ? (int)((double)(n + rectangle.width - 1) * this.xScale) : n3;
        int n6 = rectangle.height != 0 ? (int)((double)(n2 + rectangle.height - 1) * this.yScale) : n4;
        if (bl) {
            int n7;
            if (n3 > n5) {
                n7 = n3;
                n3 = n5;
                n5 = n7;
            }
            if (n4 > n6) {
                n7 = n4;
                n4 = n6;
                n6 = n7;
            }
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 >= this.orientedRect.width) {
            n3 = this.orientedRect.width - 1;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        if (n5 >= this.orientedRect.width) {
            n5 = this.orientedRect.width - 1;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (n4 >= this.orientedRect.height) {
            n4 = this.orientedRect.height - 1;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if (n6 >= this.orientedRect.height) {
            n6 = this.orientedRect.height - 1;
        }
        int n8 = n5 - n3 + 1;
        int n9 = n6 - n4 + 1;
        Rectangle rectangle2 = new Rectangle(n3, n4, n8, n9);
        return rectangle2;
    }

    public Point tcToScreen(float f, float f2) {
        float f3 = f - (float)this.imageRect.x;
        float f4 = f2 - (float)this.imageRect.y;
        float[] fArray = this.imageToOriented(new float[]{f3, f4});
        Point point = new Point((int)((double)fArray[0] / this.xScale), (int)((double)fArray[1] / this.yScale));
        return point;
    }

    public void clearCanvas() {
        if (this.imageCanvas != null && this.imageCanvasGC != null) {
            Rectangle rectangle = this.imageCanvas.getBounds();
            this.imageCanvasGC.fillRectangle(0, 0, rectangle.width, rectangle.height);
        }
    }

    public Rectangle getSelectedArea() {
        return this.selectedArea;
    }

    public void selectZoom(ZoomSelection zoomSelection) {
        logger.debug("set zoom to " + zoomSelection.getName());
        this.iv.setZoomSelection(zoomSelection);
        this.selectingOn = false;
        this.selectOn = false;
    }

    public boolean isImageChanged() {
        return this.imageChanged;
    }

    public void setImageChanged(boolean bl) {
        this.imageChanged = bl;
    }

    public Rectangle getImageRect() {
        return this.imageRect;
    }

    public void setImageRect(Rectangle rectangle) {
        this.imageRect = rectangle;
    }

    public Rectangle getOrigRect() {
        return this.origRect;
    }

    public Rectangle getOrientedOrigRect() {
        return this.orientedOrigRect;
    }

    public Rectangle getOrientedRect() {
        return this.orientedRect;
    }

    public Boolean getSelectOn() {
        return this.selectOn;
    }

    public void setSelectOn(Boolean bl) {
        this.selectOn = bl;
    }

    public Image getImage() {
        return this.image;
    }

    public Image getImageLegend() {
        return this.legend;
    }

    public boolean isDisposed() {
        if (this.imageCanvasGC == null || this.imageCanvasGC.isDisposed()) {
            return true;
        }
        if (this.image == null) {
            return false;
        }
        return this.image.isDisposed();
    }

    public void setLegendOn(Boolean bl) {
        this.legendDraw = bl;
        this.displayImage();
    }
}

