/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.component;

import fable.framework.logging.FableLogger;
import fable.framework.navigator.controller.SampleController;
import fable.framework.toolbox.EclipseUtils;
import fable.framework.toolbox.FableUtils;
import fable.imageviewer.component.ActionsProvider;
import fable.imageviewer.component.ImageComponentImage;
import fable.imageviewer.component.ImageComponentUI;
import fable.imageviewer.internal.Coordinates;
import fable.imageviewer.internal.IImagesVarKeys;
import fable.imageviewer.internal.ZoomSelection;
import fable.imageviewer.model.ImageModel;
import fable.imageviewer.model.ImageModelFactory;
import fable.imageviewer.rcp.Activator;
import fable.imageviewer.views.ImageView;
import fable.python.Peak;
import fable.python.PeakSearchSpt;
import java.util.Vector;
import org.dawb.common.ui.image.PaletteFactory;
import org.dawb.fabio.FabioFile;
import org.dawb.fabio.FableJep;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPart3;
import org.eclipse.ui.PlatformUI;

public class ImageComponent
implements IPropertyChangeListener,
IImagesVarKeys,
ISelectionListener {
    public static final String SECONDARY_ID_MAIN = "Main";
    public static final String SECONDARY_ID_ZOOM = "Zoom";
    public static final String SECONDARY_ID_SLICE1D = "Slice 1D";
    public static final String SECONDARY_ID_SLICE2D = "Slice 2D";
    public static int SECONDARY_ID_COPY_START;
    public static int copySecondaryID;
    private SampleController controller = SampleController.getController();
    private ImageComponentUI controls = null;
    public ImageComponentImage image = null;
    private Display display;
    private ImageModel imageModel = null;
    private ImageModel imageDiffModel = null;
    private ImageModel imageSavedModel = null;
    private String fileNameSaved = "";
    private Vector<Float> peaks;
    private Coordinates coordinates = new Coordinates();
    double x0Save = 0.0;
    double y0Save = 0.0;
    double pixelWidthSave = 1.0;
    double pixelHeightSave = 1.0;
    String xNameSave = "x";
    String yNameSave = "y";
    private int orientation = 0;
    private ZoomSelection zoomSelection = ZoomSelection.AREA;
    private int coordOrigin = 0;
    private boolean peaksOn = false;
    private int peakMarkerSize = 3;
    private float minimum;
    private float maximum;
    private float mean;
    private float userMinimum;
    private float userMaximum;
    private PaletteData palette = null;
    private int paletteIndex = 0;
    protected boolean imageDiffOn = false;
    private boolean jobRunning = false;
    private IWorkbenchListener workbenchListener = null;
    private IWorkbenchPart3 parentPart;
    private ActionsProvider provider;
    private Text statusLabel;

    static {
        copySecondaryID = SECONDARY_ID_COPY_START = 100;
    }

    public ImageComponent(IWorkbenchPart3 iWorkbenchPart3) {
        this(iWorkbenchPart3, (ActionsProvider)iWorkbenchPart3);
    }

    public ImageComponent(IWorkbenchPart3 iWorkbenchPart3, ActionsProvider actionsProvider) {
        this.parentPart = iWorkbenchPart3;
        this.provider = actionsProvider;
    }

    public void createPartControl(Composite composite) {
        this.display = composite.getDisplay();
        this.controls = new ImageComponentUI(this);
        this.controls.setStatusLabel(this.statusLabel);
        this.controls.createControls(composite);
    }

    public void setFocus() {
        if (this.controls != null) {
            this.controls.setFocus();
        }
        if (this.getSecondaryId() != SECONDARY_ID_MAIN) {
            return;
        }
        ZoomSelection zoomSelection = this.getZoomSelection();
        if (zoomSelection != null) {
            zoomSelection.bringToTop();
        }
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            Object object = iStructuredSelection.getFirstElement();
            Object[] objectArray = iStructuredSelection.toArray();
            if (object instanceof PeakSearchSpt) {
                String string = this.getSecondaryId();
                if (string == null || !string.equals(SECONDARY_ID_MAIN) && !string.equals(SECONDARY_ID_ZOOM)) {
                    return;
                }
                PeakSearchSpt peakSearchSpt = (PeakSearchSpt)object;
                if (peakSearchSpt.getImageFile() != null) {
                    if (string.equals(SECONDARY_ID_MAIN)) {
                        try {
                            this.loadModel(ImageModelFactory.getImageModel((Object)peakSearchSpt.getImageFile()));
                        }
                        catch (Throwable throwable) {
                            FableLogger.error((String)("Cannot load file " + peakSearchSpt.getFabioFileName()), (Throwable)throwable);
                        }
                    }
                    this.setPeaksOn(true);
                    this.image.displayImage();
                    Vector vector = peakSearchSpt.getTabChildren();
                    if (vector != null) {
                        this.setPeaks(vector);
                        this.image.showPeaks();
                    }
                }
            } else if (object instanceof Peak) {
                String string = this.getSecondaryId();
                if (string == null || !string.equals(SECONDARY_ID_MAIN) && !string.equals(SECONDARY_ID_ZOOM)) {
                    return;
                }
                PeakSearchSpt peakSearchSpt = ((Peak)object).getParent();
                int n = objectArray.length;
                float[] fArray = new float[n * 2];
                int n2 = 0;
                int n3 = 0;
                while (n3 < objectArray.length) {
                    Peak peak = (Peak)objectArray[n3];
                    if (peak.isVisible()) {
                        int n4 = n2 + 1;
                        fArray[n2] = Float.valueOf(peak.getS()).floatValue();
                        fArray[n4] = Float.valueOf(peak.getF()).floatValue();
                        n2 += 2;
                    }
                    ++n3;
                }
                Vector vector = peakSearchSpt.getTabChildren();
                if (vector != null) {
                    this.setPeaks(vector);
                }
                this.setPeaksOn(true);
                this.image.showSelectedPeaks(fArray);
            }
        }
    }

    public void loadFile(String string) throws Throwable {
        this.loadModel(ImageModelFactory.getImageModel(string));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadModel(ImageModel imageModel) {
        long l = System.currentTimeMillis();
        try {
            if (imageModel == null) {
                this.image.clearCanvas();
                FableUtils.errMsg((Object)this, (String)"Unable to load null image model");
                return;
            }
            this.imageModel = imageModel;
            if (this.controls != null) {
                this.controls.setStatusText("Loading... ");
            }
            this.peaks = null;
            if (this.image.isDisposed()) {
                return;
            }
            this.image.setImageChanged(true);
            if (this.image.getImageRect().width != imageModel.getWidth() || this.image.getImageRect().height != imageModel.getHeight()) {
                this.image.clearCanvas();
            }
            int n = imageModel.getWidth();
            int n2 = imageModel.getHeight();
            int n3 = 0;
            int n4 = 0;
            double d = 1.0;
            double d2 = 1.0;
            if (this.image != null && this.image.getOrigRect() != null && this.image.getImageRect() != null) {
                if (this.image.getOrigRect().width != 0) {
                    d = (double)n / (double)this.image.getOrigRect().width;
                }
                if (this.image.getOrigRect().height != 0) {
                    d2 = (double)n2 / (double)this.image.getOrigRect().height;
                }
                n3 = (int)(d * (double)this.image.getImageRect().x);
                n4 = (int)(d2 * (double)this.image.getImageRect().y);
                if (this.image.getImageRect().width > 0) {
                    n = (int)(d * (double)this.image.getImageRect().width);
                }
                if (this.image.getImageRect().height > 0) {
                    n2 = (int)(d2 * (double)this.image.getImageRect().height);
                }
            }
            if (n > imageModel.getWidth()) {
                n = imageModel.getWidth();
            }
            if (n2 > imageModel.getHeight()) {
                n2 = imageModel.getHeight();
            }
            if (n3 + n > imageModel.getWidth()) {
                n3 = 0;
            }
            if (n4 + n2 > imageModel.getHeight()) {
                n4 = 0;
            }
            this.image.setImageRect(new Rectangle(n3, n4, n, n2));
            this.image.calculateMainRectangles();
            this.resetCoordinates();
            if (this.imageDiffOn) {
                this.calcImageDiff();
            } else {
                this.setPartName(String.valueOf(this.getSecondaryId()) + " " + this.getFileName());
            }
            this.setStatistics(imageModel.getStatistics(this.image.getOrigRect()));
            return;
        }
        finally {
            if (imageModel.getTimeToReadImage() > 0L) {
                this.updateStatusLabel("Loaded in " + imageModel.getTimeToReadImage() + " ms");
            } else {
                long l2 = System.currentTimeMillis();
                this.updateStatusLabel("Loaded in " + (l2 - l) + " ms");
            }
        }
    }

    public void calcImageDiff() {
        long l = System.currentTimeMillis();
        if (this.imageSavedModel == null) {
            this.setImageDiffOn(false);
            this.updateStatusLabel("Cannot create difference image - no difference image set");
            FableUtils.errMsg((Object)this, (String)"Cannot create difference: no difference image set\n");
            this.setPartName(null);
            return;
        }
        FableLogger.debug((String)("Calculate difference of " + this.imageModel.getFileName() + " and background image " + this.imageSavedModel.getFileName()));
        float[] fArray = this.imageModel.getData();
        float[] fArray2 = this.imageSavedModel.getData();
        int n = fArray.length;
        int n2 = fArray2.length;
        if (n != n2) {
            FableUtils.errMsg((Object)this, (String)"Cannot create difference:\nnewWidth=%d savedWidth=%d\nnewHeight=%d savedHeight=%d");
            this.setPartName(String.valueOf(this.getSecondaryId()) + " " + this.getFileName());
            return;
        }
        float[] fArray3 = new float[n2];
        int n3 = 0;
        while (n3 < n2) {
            fArray3[n3] = fArray[n3] - fArray2[n3];
            ++n3;
        }
        this.imageDiffModel = ImageModelFactory.getImageModel(String.valueOf(this.imageModel.getFileName()) + " - " + this.imageSavedModel.getFileName(), this.imageModel.getWidth(), this.imageModel.getHeight(), fArray3);
        this.imageDiffModel.reset(String.valueOf(this.imageModel.getFileName()) + " - " + this.imageSavedModel.getFileName(), this.imageModel.getWidth(), this.imageModel.getHeight(), fArray3);
        float[] fArray4 = this.imageDiffModel.getStatistics(this.image.getImageRect());
        this.minimum = fArray4[0];
        this.minimum = fArray4[1];
        this.mean = fArray4[2];
        long l2 = System.currentTimeMillis() - l;
        this.updateStatusLabel(String.valueOf(this.getFileName()) + " - " + this.fileNameSaved + " took " + l2 + " ms");
        this.setPartName("Difference " + this.getFileName());
    }

    private void setPartName(String string) {
        if (this.parentPart instanceof ImageView) {
            if (string == null) {
                string = String.valueOf(this.getSecondaryId()) + " " + this.getFileName();
            }
            ((ImageView)this.parentPart).setPartName(string);
        }
    }

    public void updateStatusLabel(String string) {
        final String string2 = string;
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ImageComponent.this.controls != null) {
                    ImageComponent.this.controls.setStatusText(string2);
                }
            }
        });
    }

    public void setPeaks(Vector<Float> vector) {
        this.peaks = vector;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty().equals("CurrentFile")) {
            Object object = propertyChangeEvent.getNewValue();
            try {
                this.loadModel(ImageModelFactory.getImageModel(object));
            }
            catch (Throwable throwable) {
                FableLogger.error((String)("Cannot load image " + object), (Throwable)throwable);
            }
            this.image.displayImage();
            this.controls.setFileNumberText(Integer.toString(this.controller.getCurrentFileIndex()));
            final int n = this.controller.getCurrentsample().getFilteredfiles().indexOf(object);
            int n2 = this.controller.getCurrentsample().getFilteredfiles().size();
            if (n >= 0 && n < n2 && !this.jobRunning) {
                final int n3 = Math.max(0, n - 3);
                final int n4 = Math.min(n + 3, n2 - 1);
                this.jobRunning = true;
                Job job = new Job("Read files ahead "){

                    protected IStatus run(IProgressMonitor iProgressMonitor) {
                        iProgressMonitor.beginTask("Read files ahead", 7);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            FableUtils.excNoTraceMsg((Object)((Object)this), (String)"Reading files ahead interrupted", (Throwable)interruptedException);
                        }
                        try {
                            FableJep fableJep = FableJep.getFableJep();
                            int n2 = n3;
                            while (n2 <= n4) {
                                if (n2 >= 0 && n2 < ImageComponent.this.controller.getCurrentsample().getFilteredfiles().size() && n2 != n) {
                                    ((FabioFile)ImageComponent.this.controller.getCurrentsample().getFilteredfiles().get(n2)).readImageAsFloat(fableJep);
                                }
                                iProgressMonitor.worked(1);
                                ++n2;
                            }
                            fableJep.close();
                        }
                        catch (Throwable throwable) {}
                        iProgressMonitor.done();
                        ImageComponent.this.jobRunning = false;
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
        }
    }

    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
        }
        this.controller.removePropertyChangeListener((IPropertyChangeListener)this);
        if (this.workbenchListener != null) {
            PlatformUI.getWorkbench().removeWorkbenchListener(this.workbenchListener);
            this.workbenchListener = null;
        }
        if (this.parentPart.getSite() != null) {
            this.parentPart.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        }
        if (this.controls != null) {
            this.controls.dispose();
        }
    }

    public void transferSelectedSettings(ImageComponent imageComponent) {
        this.setOrientation(imageComponent.getOrientation());
        this.setCoordOrigin(imageComponent.getCoordOrigin());
        if (imageComponent.getCoordOrigin() == 4) {
            this.getCoordinates().reset(imageComponent.getCoordOrigin(), imageComponent.getCoordinates().getX0(), imageComponent.getCoordinates().getY0(), imageComponent.getCoordinates().getPixelWidth(), imageComponent.getCoordinates().getPixelHeight(), imageComponent.getCoordinates().getXName(), imageComponent.getCoordinates().getYName());
        } else {
            this.resetCoordinates();
        }
        this.setPalette(imageComponent.getPalette());
        this.setPeaks(imageComponent.getPeaks());
        this.setPeaksOn(imageComponent.isPeaksOn());
    }

    public void initWithShowPeaks() {
        if (this.controls == null) {
            return;
        }
        this.setPeaksOn(true);
        this.controls.firePeaksUpate();
    }

    public void resetCoordinates() {
        if (this.coordOrigin != 4) {
            this.coordinates.reset(this.coordOrigin, this.image.getOrientedOrigRect().width, this.image.getOrientedOrigRect().height);
        }
    }

    public int getCoordOrigin() {
        return this.coordOrigin;
    }

    public void setCoordOrigin(int n) {
        if (n < 0 || n >= coordNameValues.length) {
            return;
        }
        if (this.coordOrigin != n) {
            this.coordOrigin = n;
            if (this.controls != null) {
                this.controls.setCoordinate(n);
            }
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        if (n < 0 || n >= 8) {
            return;
        }
        if (n == this.orientation) {
            return;
        }
        this.orientation = n;
        if (this.controls != null) {
            this.controls.setOrientation(n);
        }
        this.resetCoordinates();
        this.image.clearCanvas();
        this.image.displayImage();
        IPreferenceStore iPreferenceStore = Activator.getDefault().getPreferenceStore();
        iPreferenceStore.setValue("orientationPreference", n);
    }

    public PaletteData getPalette() {
        return this.palette;
    }

    public void setPalette(int n) {
        this.palette = PaletteFactory.getPalette((int)n);
        if (this.controls != null) {
            this.controls.setImageScheme(n);
        }
        this.paletteIndex = n;
        this.image.displayImage();
        IPreferenceStore iPreferenceStore = Activator.getDefault().getPreferenceStore();
        iPreferenceStore.setValue("palettePreference", n);
    }

    public float[] getStatistics() {
        return new float[]{this.minimum, this.maximum, this.mean};
    }

    public void setStatistics(float[] fArray, boolean bl) {
        if (this.controls != null) {
            this.controls.setAutoScale(bl);
        }
        this.setStatistics(fArray);
    }

    public void setStatistics(float[] fArray) {
        this.minimum = fArray[0];
        this.maximum = fArray[1];
        this.mean = fArray[2];
        if (this.controls != null) {
            this.controls.setMinMaxText(fArray);
        }
        if (this.image != null) {
            this.image.displayImage();
        }
    }

    public String getFileName() {
        String string = null;
        if (this.imageModel != null) {
            string = this.imageModel.getFileName();
        }
        return string == null ? "" : string;
    }

    public ImageModel getImageModel() {
        return this.imageModel;
    }

    public void setImageModel(ImageModel imageModel) {
        this.imageModel = imageModel;
    }

    public ImageModel getImageDiffModel() {
        return this.imageDiffModel;
    }

    public void setImageDiffModel(ImageModel imageModel) {
        this.imageDiffModel = imageModel;
    }

    public ImageModel getImageSavedModel() {
        return this.imageSavedModel;
    }

    public void setImageSavedModel(ImageModel imageModel) {
        this.imageSavedModel = imageModel;
    }

    public Coordinates getCoordinates() {
        return this.coordinates;
    }

    public String getCoordinatesName() {
        if (this.coordOrigin < 0 || this.coordOrigin > 4) {
            return "Unknown";
        }
        return coordNameValues[this.coordOrigin][0].split("[\\s\\.]", 2)[0];
    }

    public SampleController getController() {
        return this.controller;
    }

    public boolean isPeaksOn() {
        return this.peaksOn;
    }

    public void setPeaksOn(boolean bl) {
        this.peaksOn = bl;
        this.controls.setPeaks(bl);
    }

    public int getPeakMarkerSize() {
        return this.peakMarkerSize;
    }

    public void setPeakMarkerSize(int n) {
        this.peakMarkerSize = n;
    }

    public ImageComponentUI getControls() {
        return this.controls;
    }

    public void setControls(ImageComponentUI imageComponentUI) {
        this.controls = imageComponentUI;
    }

    public ImageComponentImage getImage() {
        return this.image;
    }

    public void setImage(ImageComponentImage imageComponentImage) {
        this.image = imageComponentImage;
    }

    public void setZoomSelection(ZoomSelection zoomSelection) {
        this.zoomSelection = zoomSelection;
    }

    public ZoomSelection getZoomSelection() {
        return this.zoomSelection;
    }

    public Vector<Float> getPeaks() {
        return this.peaks;
    }

    public boolean isImageDiffOn() {
        return this.imageDiffOn;
    }

    public void setImageDiffOn(boolean bl) {
        this.imageDiffOn = bl;
        if (bl) {
            this.calcImageDiff();
        } else if (this.parentPart instanceof ImageView) {
            this.setPartName(String.valueOf(this.getSecondaryId()) + " " + this.getFileName());
        }
        this.image.setImageChanged(true);
        this.image.displayImage();
    }

    public float getMinimum() {
        return this.minimum;
    }

    public float getMaximum() {
        return this.maximum;
    }

    public float getMean() {
        return this.mean;
    }

    public float getUserMinimum() {
        return this.userMinimum;
    }

    public void setUserMinimum(float f, boolean bl) {
        this.userMinimum = f;
        if (this.controls != null && bl) {
            this.controls.setUserMinimumText(Float.toString(f));
        }
    }

    public float getUserMaximum() {
        return this.userMaximum;
    }

    public void setUserMaximum(float f, boolean bl) {
        this.userMaximum = f;
        if (this.controls != null && bl) {
            this.controls.setUserMaximumText(Float.toString(f));
        }
    }

    public double getX0Save() {
        return this.x0Save;
    }

    public void setX0Save(double d) {
        this.x0Save = d;
    }

    public double getY0Save() {
        return this.y0Save;
    }

    public void setY0Save(double d) {
        this.y0Save = d;
    }

    public double getPixelWidthSave() {
        return this.pixelWidthSave;
    }

    public void setPixelWidthSave(double d) {
        this.pixelWidthSave = d;
    }

    public double getPixelHeightSave() {
        return this.pixelHeightSave;
    }

    public void setPixelHeightSave(double d) {
        this.pixelHeightSave = d;
    }

    public String getXNameSave() {
        return this.xNameSave;
    }

    public void setXNameSave(String string) {
        this.xNameSave = string;
    }

    public String getYNameSave() {
        return this.yNameSave;
    }

    public void setYNameSave(String string) {
        this.yNameSave = string;
    }

    public int getPaletteIndex() {
        return this.paletteIndex;
    }

    public void setPaletteIndex(int n) {
        this.paletteIndex = n;
    }

    public void setPalette(PaletteData paletteData) {
        this.palette = paletteData;
    }

    public Display getDisplay() {
        return this.display;
    }

    public String getSecondaryId() {
        String string = null;
        try {
            string = this.parentPart instanceof IViewPart ? ((IViewPart)this.parentPart).getViewSite().getSecondaryId() : SECONDARY_ID_MAIN;
        }
        catch (Exception exception) {}
        return string;
    }

    public Object getPartName() {
        return this.parentPart.getPartName();
    }

    public IActionBars getActionBars() {
        return this.provider.getActionBars();
    }

    public String toString() {
        return "Image Component for " + this.parentPart.getPartName();
    }

    public IWorkbenchPart3 getParentPart() {
        return this.parentPart;
    }

    public void setStatusLabel(Text text) {
        this.statusLabel = text;
    }

    public void setPlotTitle(String string) {
        this.controls.setTitle(string);
    }

    public void setEditorInput(String string) throws Throwable {
        if (this.parentPart instanceof IReusableEditor) {
            IEditorInput iEditorInput = EclipseUtils.getEditorInput((String)string);
            IReusableEditor iReusableEditor = (IReusableEditor)this.parentPart;
            iReusableEditor.setInput(iEditorInput);
        } else {
            ImageModel imageModel = ImageModelFactory.getImageModel(string);
            this.loadModel(imageModel);
        }
    }
}

