/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.actions;

import fable.framework.navigator.views.SampleNavigatorView;
import fable.framework.toolbox.FableUtils;
import fable.imageviewer.actions.AbstractImageComponentAction;
import fable.imageviewer.internal.ImageUtils;
import fable.imageviewer.internal.ZoomSelection;
import fable.imageviewer.views.ImageView;
import java.util.Vector;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class Slice2DAction
extends AbstractImageComponentAction
implements IViewActionDelegate {
    public Slice2DAction() {
    }

    public Slice2DAction(String string) {
        super(string, 1);
        this.setEnabled(true);
    }

    public void run(IAction iAction) {
        this.slice2D();
    }

    public void run() {
        this.slice2D();
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }

    private void slice2D() {
        try {
            Vector vector = SampleNavigatorView.view.getSelectedFilesIndex();
            if (vector.size() <= 1) {
                this.imageComp.updateStatusLabel("select at least 2 files to make a slice");
            } else {
                if (this.imageComp == null) {
                    this.imageComp = ImageUtils.getComponentFromPartSelected();
                }
                if (this.imageComp != null) {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.ImageView", "Slice 2D", 1);
                    ImageView imageView = (ImageView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference("fable.imageviewer.views.ImageView", "Slice 1D").getView(true);
                    Rectangle rectangle = this.imageComp.getImage().getSelectedArea();
                    Rectangle rectangle2 = this.imageComp.getImage().screenRectangleToImageRectangle(rectangle, true);
                    if (this.imageComp.getZoomSelection() == ZoomSelection.AREA) {
                        ImageUtils.Slice2DArea(rectangle2.x, rectangle2.y, rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height);
                    } else {
                        this.imageComp.updateStatusLabel("zoom on a 2D area to make a slice");
                    }
                    imageView.transferSelectedSettings(this.imageComp);
                    imageView.setPartName(String.valueOf(imageView.getSecondaryId()) + " " + this.imageComp.getFileName());
                }
            }
        }
        catch (PartInitException partInitException) {
            FableUtils.excMsg((Object)((Object)this), (String)"Error opening Slice 2D view", (Throwable)partInitException);
        }
    }
}

