/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.actions;

import fable.framework.navigator.views.SampleNavigatorView;
import fable.framework.toolbox.FableUtils;
import fable.imageviewer.actions.SetDifferenceAction;
import fable.imageviewer.internal.ImageUtils;
import fable.imageviewer.internal.ZoomSelection;
import fable.imageviewer.views.ImageView;
import java.util.Vector;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class Slice1DAction
extends SetDifferenceAction
implements IViewActionDelegate {
    public Slice1DAction() {
    }

    public Slice1DAction(String string) {
        super(string, 1);
        this.setEnabled(true);
    }

    @Override
    public void run(IAction iAction) {
        this.slice1D();
    }

    @Override
    public void run() {
        this.slice1D();
    }

    @Override
    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }

    private void slice1D() {
        try {
            Vector vector = SampleNavigatorView.view.getSelectedFilesIndex();
            if (vector.size() <= 1) {
                this.imageComp.updateStatusLabel("select at least 2 files to make a slice");
            } else {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.ImageView", "Slice 1D", 1);
                ImageView imageView = (ImageView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference("fable.imageviewer.views.ImageView", "Slice 1D").getView(true);
                Rectangle rectangle = this.imageComp.getImage().getSelectedArea();
                Rectangle rectangle2 = this.imageComp.getImage().screenRectangleToImageRectangle(rectangle, true);
                if (this.imageComp.getZoomSelection() == ZoomSelection.LINE) {
                    ImageUtils.Slice2DLine(rectangle2.x, rectangle2.y, rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height, 1);
                } else {
                    this.imageComp.updateStatusLabel("zoom on a 1D line to make a slice");
                }
                imageView.transferSelectedSettings(this.imageComp);
                imageView.setPartName(String.valueOf(imageView.getSecondaryId()) + " " + this.imageComp.getFileName());
            }
        }
        catch (PartInitException partInitException) {
            FableUtils.excMsg((Object)((Object)this), (String)"Error opening Slice 1D view", (Throwable)partInitException);
        }
    }
}

