/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.actions;

import fable.framework.navigator.views.SampleNavigatorView;
import fable.framework.toolbox.FableUtils;
import fable.framework.toolbox.ToolBox;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class OpenImageViewerResourceAction
implements IObjectActionDelegate {
    private ISelection selection = null;

    public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
    }

    public void run(IAction iAction) {
        IFile iFile = null;
        IFolder iFolder = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.selection instanceof IStructuredSelection) {
            Iterator iterator = ((IStructuredSelection)this.selection).iterator();
            while (iterator.hasNext()) {
                iFile = null;
                iFolder = null;
                Object e = iterator.next();
                if (e instanceof IFile) {
                    iFile = (IFile)e;
                } else if (e instanceof IFolder) {
                    iFolder = (IFolder)e;
                } else if (e instanceof IAdaptable) {
                    iFile = (IFile)((IAdaptable)e).getAdapter(IFile.class);
                    iFolder = (IFolder)((IAdaptable)e).getAdapter(IFolder.class);
                }
                if (iFile != null) {
                    arrayList.add(iFile.getLocation().toString());
                    continue;
                }
                if (iFolder == null) continue;
                this.loadFolder(iFolder);
            }
        }
        this.processFiles(arrayList);
    }

    void processFiles(ArrayList<String> arrayList) {
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            try {
                if (ToolBox.isSmallPerspectiveSet()) {
                    PlatformUI.getWorkbench().showPerspective("fable.imageviewer.perspectiveSmall", iWorkbenchWindow);
                } else {
                    PlatformUI.getWorkbench().showPerspective("fable.imageviewer.perspective", iWorkbenchWindow);
                }
            }
            catch (WorkbenchException workbenchException) {
                FableUtils.excMsg((Object)this, (String)"Error opening ImageViewer perspective", (Throwable)workbenchException);
                return;
            }
            try {
                String[] stringArray;
                SampleNavigatorView sampleNavigatorView = (SampleNavigatorView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("fable.framework.navigator.views.SampleNavigatorViewid");
                Collections.sort(arrayList);
                ListIterator<String> listIterator = arrayList.listIterator();
                String string = null;
                String string2 = null;
                ArrayList<String> arrayList2 = new ArrayList<String>();
                while (listIterator.hasNext()) {
                    String string3 = listIterator.next();
                    File file = new File(string3);
                    string = file.getParent();
                    String string4 = file.getName();
                    if (string.equals(string2)) {
                        arrayList2.add(string4);
                    } else {
                        if (string2 != null && !arrayList2.isEmpty()) {
                            stringArray = new String[arrayList2.size()];
                            arrayList2.toArray(stringArray);
                            sampleNavigatorView.addFiles(stringArray, string2);
                        }
                        string2 = string;
                        arrayList2.clear();
                        arrayList2.add(string4);
                    }
                    stringArray = new String[arrayList2.size()];
                }
                if (string2 != null && !arrayList2.isEmpty()) {
                    stringArray = new String[arrayList2.size()];
                    arrayList2.toArray(stringArray);
                    sampleNavigatorView.addFiles(stringArray, string2);
                }
            }
            catch (Exception exception) {
                FableUtils.excMsg((Object)this, (String)"Error loading Image File", (Throwable)exception);
            }
        }
    }

    private void loadFolder(IFolder iFolder) {
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            try {
                if (ToolBox.isSmallPerspectiveSet()) {
                    PlatformUI.getWorkbench().showPerspective("fable.imageviewer.perspectiveSmall", iWorkbenchWindow);
                } else {
                    PlatformUI.getWorkbench().showPerspective("fable.imageviewer.perspective", iWorkbenchWindow);
                }
            }
            catch (WorkbenchException workbenchException) {
                FableUtils.excMsg((Object)this, (String)"Error opening ImageViewer perspective", (Throwable)workbenchException);
                return;
            }
            try {
                SampleNavigatorView sampleNavigatorView = (SampleNavigatorView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("fable.framework.navigator.views.SampleNavigatorViewid");
                sampleNavigatorView.addDirectory(iFolder.getLocation().toString());
            }
            catch (Exception exception) {
                FableUtils.excMsg((Object)this, (String)"Error loading Image Folder", (Throwable)exception);
            }
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        this.selection = iSelection;
    }
}

