/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.actions;

import fable.framework.logging.FableLogger;
import fable.imageviewer.component.ImageComponent;
import fable.imageviewer.internal.ImageUtils;
import java.io.File;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchWindow;

public class OpenImageAction
extends Action {
    private final IWorkbenchWindow window;
    private static final String CMD_OPEN_IMAGE = "fable.imageviewer.openImageAction";
    private static String previousDirectory = null;

    public OpenImageAction(IWorkbenchWindow iWorkbenchWindow, String string, String string2, String string3) {
        this.window = iWorkbenchWindow;
        this.setText(string);
        this.setId(CMD_OPEN_IMAGE);
        this.setActionDefinitionId(CMD_OPEN_IMAGE);
        previousDirectory = string3;
    }

    public void run() {
        if (this.window != null) {
            String string;
            FileDialog fileDialog = new FileDialog(this.window.getShell(), 4);
            fileDialog.setText("Choose Image");
            if (previousDirectory != null) {
                fileDialog.setFilterPath(previousDirectory);
            }
            if ((string = fileDialog.open()) != null) {
                ImageComponent imageComponent;
                if (previousDirectory == null) {
                    previousDirectory = new File(string).getAbsolutePath();
                }
                if ((imageComponent = ImageUtils.getComponentFromPartSelected()) != null) {
                    try {
                        imageComponent.loadFile(string);
                    }
                    catch (Throwable throwable) {
                        FableLogger.error((String)("Cannot load image " + string), (Throwable)throwable);
                    }
                }
            }
        }
    }
}

