/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.actions;

import fable.framework.imageprint.FableImagePrinter;
import fable.framework.imageprint.ImagePrintPreviewDialog;
import fable.framework.imageprint.ImagePrintSetupDialog;
import fable.framework.imageprint.ImagePrintUtils;
import fable.framework.imageprint.PrintSettings;
import fable.framework.toolbox.EclipseUtils;
import fable.framework.toolbox.FableUtils;
import fable.framework.toolbox.ImageSelection;
import fable.framework.toolbox.SWTUtils;
import fable.imageviewer.actions.DisplayDifferenceAction;
import fable.imageviewer.actions.ImageCopyAction;
import fable.imageviewer.actions.ImageInfoAction;
import fable.imageviewer.actions.InputSummaryAction;
import fable.imageviewer.actions.ResetZoomAction;
import fable.imageviewer.actions.SetDifferenceAction;
import fable.imageviewer.actions.Slice1DAction;
import fable.imageviewer.actions.Slice2DAction;
import fable.imageviewer.actions.ZoomApplyAction;
import fable.imageviewer.actions.ZoomAreaAction;
import fable.imageviewer.actions.ZoomLineAction;
import fable.imageviewer.actions.ZoomNoneAction;
import fable.imageviewer.actions.ZoomProfileAction;
import fable.imageviewer.actions.ZoomReliefAction;
import fable.imageviewer.actions.ZoomRockingAction;
import fable.imageviewer.component.ImageComponent;
import fable.imageviewer.component.ImageComponentImage;
import fable.imageviewer.component.ImageComponentUI;
import fable.imageviewer.internal.IImagesVarKeys;
import fable.imageviewer.internal.ZoomSelection;
import fable.imageviewer.rcp.Activator;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageViewActions
implements IImagesVarKeys {
    private static final Logger logger = LoggerFactory.getLogger(ImageViewActions.class);
    ImageComponent iv = null;
    private ImageComponentUI controls;
    public ImageComponentImage image = null;
    public Action controlPanelAction;
    public Action drawLegendAction;
    public Action resetMinMaxAction;
    public ZoomApplyAction zoomApplyAction;
    public ZoomAreaAction zoomAreaAction;
    public ZoomLineAction zoomLineAction;
    public ZoomNoneAction zoomNone;
    public ZoomProfileAction zoomProfileAction;
    public ZoomReliefAction zoomReliefAction;
    public ZoomRockingAction zoomRockingAction;
    public Action showHeaderTableAction;
    public ResetZoomAction resetZoomAction;
    public ImageCopyAction copyImageAction;
    public SetDifferenceAction setDifferenceAction;
    public DisplayDifferenceAction displayDifferenceAction;
    public Slice1DAction slice1DAction;
    public Slice2DAction slice2DAction;
    public Action printSetupAction;
    public Action printPreviewAction;
    public Action printAction;
    public Action copyAction;
    public ImageInfoAction imageInfoAction;
    public InputSummaryAction inputSummaryAction;

    public ImageViewActions(ImageComponent imageComponent, ImageComponentUI imageComponentUI, ImageComponentImage imageComponentImage) {
        this.iv = imageComponent;
        this.controls = imageComponentUI;
        this.image = imageComponentImage;
        this.controlPanelAction = new Action("Intensity Information", 8){

            public void run() {
                ImageViewActions.this.controls.setControlCompositeShowing(!ImageViewActions.this.controls.getControlCompositeShowing());
                this.setChecked(ImageViewActions.this.controls.getControlCompositeShowing());
            }
        };
        this.controlPanelAction.setChecked(this.controls.getControlCompositeShowing());
        this.controlPanelAction.setToolTipText("Toggle intensity and title");
        this.controlPanelAction.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"org.dawb.fable.imageviewer", (String)"icons/settings.gif"));
        this.drawLegendAction = new Action("Show legend", 8){

            public void run() {
                ImageViewActions.this.controls.setLegendShowing(!ImageViewActions.this.controls.getLegendShowing());
                this.setChecked(ImageViewActions.this.controls.getLegendShowing());
            }
        };
        this.drawLegendAction.setChecked(this.controls.getLegendShowing());
        this.controlPanelAction.setToolTipText("Show legend");
        this.controlPanelAction.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"org.dawb.fable.imageviewer", (String)"icons/settings.gif"));
        this.resetMinMaxAction = new Action("Reset Min Max Intensity"){

            public void run() {
                if (ImageViewActions.this.iv == null) {
                    return;
                }
                ImageViewActions.this.iv.setUserMinimum(ImageViewActions.this.iv.getMinimum(), true);
                ImageViewActions.this.iv.setUserMaximum(ImageViewActions.this.iv.getMaximum(), true);
                if (ImageViewActions.this.iv.getImage() != null) {
                    ImageViewActions.this.iv.getImage().displayImage();
                }
            }
        };
        this.resetMinMaxAction.setToolTipText("Reset the minimum and maximum for manual intensity scaling to be the image limits");
        this.zoomApplyAction = new ZoomApplyAction("Reapply Zoom");
        this.zoomApplyAction.set(this.iv);
        this.zoomApplyAction.setImageDescriptor(Activator.getImageDescriptor("/icons/zoom_update.png"));
        this.zoomApplyAction.setToolTipText("Apply the zoom again. This updates the side plots with the last zoom function.");
        this.zoomAreaAction = new ZoomAreaAction("Zoom Area");
        this.zoomAreaAction.set(this.iv);
        ZoomSelection zoomSelection = this.iv.getZoomSelection();
        if (zoomSelection == ZoomSelection.AREA) {
            this.zoomAreaAction.setChecked(true);
        }
        this.zoomAreaAction.setImageDescriptor(Activator.getImageDescriptor("/icons/zoom_box.gif"));
        this.zoomLineAction = new ZoomLineAction("Zoom Line");
        this.zoomLineAction.set(this.iv);
        if (zoomSelection == ZoomSelection.LINE) {
            this.zoomLineAction.setChecked(true);
        }
        this.zoomLineAction.setImageDescriptor(Activator.getImageDescriptor("/icons/zoom_line.gif"));
        this.zoomProfileAction = new ZoomProfileAction("Zoom Profile");
        this.zoomProfileAction.set(this.iv);
        if (zoomSelection == ZoomSelection.PROFILE) {
            this.zoomProfileAction.setChecked(true);
        }
        this.zoomProfileAction.setImageDescriptor(Activator.getImageDescriptor("/icons/zoom_profile.gif"));
        this.zoomReliefAction = new ZoomReliefAction("Zoom Relief");
        this.zoomReliefAction.set(this.iv);
        if (zoomSelection == ZoomSelection.RELIEF) {
            this.zoomReliefAction.setChecked(true);
        }
        this.zoomReliefAction.setImageDescriptor(Activator.getImageDescriptor("/icons/zoom_relief.png"));
        this.zoomRockingAction = new ZoomRockingAction("Zoom Rocking");
        this.zoomRockingAction.set(this.iv);
        if (zoomSelection == ZoomSelection.ROCKINGCURVE) {
            this.zoomRockingAction.setChecked(true);
        }
        this.zoomRockingAction.setImageDescriptor(Activator.getImageDescriptor("/icons/zoom_rocking.png"));
        this.zoomNone = new ZoomNoneAction("Zoom None");
        this.zoomNone.set(this.iv);
        if (zoomSelection == ZoomSelection.NONE) {
            this.zoomNone.setChecked(true);
        }
        this.zoomNone.setImageDescriptor(Activator.getImageDescriptor("/icons/zoom_none.gif"));
        this.resetZoomAction = new ResetZoomAction("Reset Zoom");
        this.resetZoomAction.set(this.iv);
        this.resetZoomAction.setToolTipText("Reset zoom to original image size");
        this.showHeaderTableAction = new Action("Show Meta Data"){

            public void run() {
                try {
                    EclipseUtils.getPage().showView("fable.imageviewer.views.HeaderView");
                }
                catch (PartInitException partInitException) {
                    logger.error("Canot open fable.imageviewer.views.HeaderView", (Throwable)partInitException);
                }
            }
        };
        this.showHeaderTableAction.setImageDescriptor(Activator.getImageDescriptor("/icons/header_table.gif"));
        this.copyImageAction = new ImageCopyAction("Copy Image");
        this.copyImageAction.set(this.iv);
        this.copyImageAction.setToolTipText("Show a copy of this view in another view");
        this.setDifferenceAction = new SetDifferenceAction("Set Difference");
        this.setDifferenceAction.set(this.iv);
        this.setDifferenceAction.setToolTipText("Set current image as reference image to subtract");
        this.displayDifferenceAction = new DisplayDifferenceAction("Display Difference");
        this.displayDifferenceAction.set(this.iv);
        this.displayDifferenceAction.setToolTipText("Display image with reference image subtracted");
        this.slice1DAction = new Slice1DAction("1D Slice");
        this.slice1DAction.set(this.iv);
        this.slice1DAction.setToolTipText("Make a new 2D image by stacking the zoomed line of the selected images");
        this.slice2DAction = new Slice2DAction("2D Slice");
        this.slice2DAction.set(this.iv);
        this.slice2DAction.setToolTipText("Make a new 2D image by stacking the zoomed area of the selected images");
        this.printSetupAction = new Action("Print Setup"){

            public void run() {
                org.eclipse.swt.graphics.Image image = ImageViewActions.this.controls.getImage().getImage();
                if (image == null) {
                    return;
                }
                ImagePrintSetupDialog imagePrintSetupDialog = new ImagePrintSetupDialog(ImageViewActions.this.iv.getDisplay().getActiveShell(), image, FableImagePrinter.getSettings());
                PrintSettings printSettings = imagePrintSetupDialog.open();
                if (printSettings != null) {
                    FableImagePrinter.setSettings((PrintSettings)printSettings);
                }
            }
        };
        this.printPreviewAction = new Action("Print Preview"){

            public void run() {
                org.eclipse.swt.graphics.Image image = ImageViewActions.this.controls.getImage().getImageLegend();
                if (image == null) {
                    return;
                }
                ImagePrintPreviewDialog imagePrintPreviewDialog = new ImagePrintPreviewDialog(ImageViewActions.this.iv.getDisplay().getActiveShell(), image, FableImagePrinter.getSettings());
                PrintSettings printSettings = imagePrintPreviewDialog.open();
                if (printSettings != null) {
                    FableImagePrinter.setSettings((PrintSettings)printSettings);
                }
            }
        };
        this.printAction = new Action("Print"){

            public void run() {
                org.eclipse.swt.graphics.Image image = ImageViewActions.this.controls.getImage().getImage();
                if (image == null) {
                    return;
                }
                ImagePrintUtils.dialogPrintImage((Shell)ImageViewActions.this.iv.getDisplay().getActiveShell(), (org.eclipse.swt.graphics.Image)image, (Point)ImageViewActions.this.iv.getDisplay().getActiveShell().getDisplay().getDPI(), (PrintSettings)FableImagePrinter.getSettings());
            }
        };
        this.copyAction = new Action("Copy"){

            public void run() {
                org.eclipse.swt.graphics.Image image = ImageViewActions.this.controls.getImage().getImage();
                if (image == null) {
                    return;
                }
                try {
                    BufferedImage bufferedImage = SWTUtils.convertToAWT((ImageData)image.getImageData());
                    if (bufferedImage == null) {
                        FableUtils.errMsg((Object)((Object)this), (String)"Could not convert SWT image to AWT image");
                        return;
                    }
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents((Transferable)new ImageSelection((Image)bufferedImage), null);
                }
                catch (Throwable throwable) {
                    FableUtils.excMsg((Object)((Object)this), (String)"Problem copying to clipboard", (Throwable)throwable);
                }
            }
        };
        this.imageInfoAction = new ImageInfoAction("Image Info");
        this.imageInfoAction.set(this.iv);
        this.imageInfoAction.setToolTipText("Display image info");
        this.inputSummaryAction = new InputSummaryAction("Input Summary");
        this.inputSummaryAction.set(this.iv);
        this.inputSummaryAction.setToolTipText("Display a summary of mouse operations");
    }
}

