/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.toolbox;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.regex.Pattern;

public class VarUtils {
    private static final Collection<String> IMAGES;

    static {
        HashSet<String> hashSet = new HashSet<String>(31);
        hashSet.add("tif");
        hashSet.add("tif.bz2");
        hashSet.add("tif.gz");
        hashSet.add("tiff");
        hashSet.add("tiff.bz2");
        hashSet.add("tiff.gz");
        hashSet.add("img");
        hashSet.add("img.bz2");
        hashSet.add("img.gz");
        hashSet.add("edf");
        hashSet.add("edf.bz2");
        hashSet.add("edf.gz");
        hashSet.add("cor");
        hashSet.add("cor.bz2");
        hashSet.add("cor.gz");
        hashSet.add("\\.\\d{4}$");
        hashSet.add("\\.\\d{4}\\.bz2$");
        hashSet.add("mccd");
        hashSet.add("mccd.bz2");
        hashSet.add("mccd.gz");
        hashSet.add("mccd");
        hashSet.add("mccd.bz2");
        hashSet.add("mccd.gz");
        hashSet.add("ccd");
        hashSet.add("pnm");
        hashSet.add("pgm");
        hashSet.add("pbm");
        hashSet.add("jpg");
        hashSet.add("jpeg");
        hashSet.add("png");
        hashSet.add("gif");
        hashSet.add("cbf");
        hashSet.add("cbf.bz2");
        IMAGES = Collections.unmodifiableCollection(hashSet);
    }

    public static final boolean isImage(String string) {
        String string2;
        int n = string.lastIndexOf(".");
        String string3 = string2 = n < 0 ? string : string.substring(n + 1);
        if (IMAGES.contains(string2.toLowerCase())) {
            return true;
        }
        try {
            n = string.lastIndexOf(46, n - 1);
            string2 = n < 0 ? string : string.substring(n + 1);
            return IMAGES.contains(string2.toLowerCase());
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean isTiff(String string) {
        if (string == null) {
            return false;
        }
        if (string.toLowerCase().endsWith("tif")) {
            return true;
        }
        if (string.toLowerCase().endsWith("tif.gz")) {
            return true;
        }
        if (string.toLowerCase().endsWith("tif.bz2")) {
            return true;
        }
        if (string.toLowerCase().endsWith("tiff")) {
            return true;
        }
        if (string.toLowerCase().endsWith("tiff.gz")) {
            return true;
        }
        return string.toLowerCase().endsWith("tiff.bz2");
    }

    public static boolean isImg(String string) {
        if (string == null) {
            return false;
        }
        if (string.toLowerCase().endsWith("img")) {
            return true;
        }
        if (string.toLowerCase().endsWith("img.gz")) {
            return true;
        }
        return string.toLowerCase().endsWith("img.bz2");
    }

    public static boolean isEdf(String string) {
        if (string == null) {
            return false;
        }
        if (string.toLowerCase().endsWith("edf")) {
            return true;
        }
        if (string.toLowerCase().endsWith("edf.gz")) {
            return true;
        }
        return string.toLowerCase().endsWith("edf.bz2");
    }

    public static boolean isCor(String string) {
        if (string == null) {
            return false;
        }
        if (string.toLowerCase().endsWith("cor")) {
            return true;
        }
        if (string.toLowerCase().endsWith("cor.gz")) {
            return true;
        }
        return string.toLowerCase().endsWith("cor.bz2");
    }

    public static boolean isBruker(String string) {
        if (string == null) {
            return false;
        }
        if (Pattern.compile(".*\\.\\d{4}$").matcher(string).matches()) {
            return true;
        }
        return Pattern.compile(".*\\.\\d{4}\\.bz2$").matcher(string).matches();
    }
}

