/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.toolbox;

import fable.framework.toolbox.Activator;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TypedText
extends Composite {
    protected static final int SPACING = 5;
    protected static final int MARGIN = 1;
    private final String ID_REQUIRED = "required.field";
    private final String ID_FORMAT = "format.field";
    protected boolean _bValide = true;
    protected boolean _isRequiredField;
    protected Text textField;
    protected Label _label;
    protected ControlDecoration textFieldDecorated;
    protected FieldDecorationRegistry _registry;
    protected Image _imgRequired = Activator.imageDescriptorFromPlugin((String)"org.dawb.fable.framework.toolbox", (String)"images/required_field.gif").createImage();
    protected Image _imgError = Activator.imageDescriptorFromPlugin((String)"org.dawb.fable.framework.toolbox", (String)"images/errorField.gif").createImage();
    protected String _errorMessage = "";
    private String name = "";

    protected TypedText(Composite composite, int n) {
        super(composite, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(new GridData(256, 2, true, true));
        this.createFields(n);
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
            }
        });
        this.textField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                TypedText.this._bValide = TypedText.this.checkValue(((Text)modifyEvent.widget).getText());
                TypedText.this.showDecoration();
            }
        });
        this.textField.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                TypedText.this._bValide = TypedText.this.checkValue(((Text)traverseEvent.widget).getText());
                TypedText.this.showDecoration();
            }
        });
    }

    protected TypedText(Composite composite, int n, String string) {
        this(composite, n);
        this._label.setText(string);
        this.name = string;
    }

    public boolean set_Text(String string) {
        if (string != null) {
            ((Text)this.textFieldDecorated.getControl()).setText(string);
            this._bValide = this.checkValue(string);
            this.showDecoration();
        }
        return this._bValide;
    }

    public void setBackground(Color color) {
        ((Text)this.textFieldDecorated.getControl()).setBackground(color);
    }

    public void setToolTipText(String string) {
        this.textField.setToolTipText(string);
    }

    public Text getTextField() {
        return this.textField;
    }

    public boolean is_bValide() {
        return this._bValide;
    }

    public void set_bValide(boolean bl) {
        this._bValide = bl;
    }

    public String getText() {
        return this.textField.getText();
    }

    public boolean is_isRequiredField() {
        return this._isRequiredField;
    }

    public void set_isRequiredField(boolean bl) {
        this._isRequiredField = bl;
        this._bValide = this.checkValue(this.getText());
    }

    public void showDecoration() {
        this.textFieldDecorated.hide();
        if (!this.showRequired()) {
            if (this.showError()) {
                this.textFieldDecorated.show();
            }
        } else {
            this.textFieldDecorated.show();
        }
    }

    private void createFields(int n) {
        this._label = new Label((Composite)this, 0);
        this._label.setVisible(true);
        this.textField = new Text((Composite)this, 0x800 | n);
        this.textFieldDecorated = new ControlDecoration((Control)this.textField, 16512);
        this._registry = FieldDecorationRegistry.getDefault();
        this._registry.registerFieldDecoration("format.field", "This field should contain a typed value", this._imgError);
        this._registry.registerFieldDecoration("required.field", "This field is required", this._imgRequired);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 1;
        gridData.horizontalIndent = 8;
        this.textFieldDecorated.getControl().setLayoutData((Object)gridData);
    }

    public boolean checkValue(String string) {
        return this.is_isRequiredField();
    }

    public String getErrorMessage() {
        if (this.showRequired()) {
            return "Field is required";
        }
        return this.getErrorFormatDescription();
    }

    private boolean showError() {
        boolean bl = false;
        if (!this.is_bValide()) {
            this.textFieldDecorated.setDescriptionText(this.getErrorFormatDescription());
            this.textFieldDecorated.setImage(this._registry.getFieldDecoration("format.field").getImage());
            bl = true;
        }
        return bl;
    }

    private boolean showRequired() {
        boolean bl = false;
        if (this.is_isRequiredField() && (this.textField.getText() == null || this.textField.getText().trim().length() == 0)) {
            String string = this._registry.getFieldDecoration("required.field").getDescription();
            this.textFieldDecorated.setDescriptionText(string);
            this.textFieldDecorated.setImage(this._registry.getFieldDecoration("required.field").getImage());
            bl = true;
        }
        return bl;
    }

    protected String getErrorFormatDescription() {
        return this._registry.getFieldDecoration("format.field").getDescription();
    }

    public void setEnabled(boolean bl) {
        this.textField.setEnabled(bl);
        if (!bl) {
            this._bValide = true;
            this.showDecoration();
        } else {
            this._bValide = this.checkValue(this.textField.getText());
            this.showDecoration();
        }
    }

    public String toString() {
        String string = "";
        string = this._label != null && !this._label.getText().equals("") ? this._label.getText() : this.name;
        return string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setLabel(String string) {
        this._label.setText(string);
    }

    public String getLabel() {
        return this._label.getText();
    }
}

