/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.toolbox;

import java.io.File;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class TreeWithAddRemove
extends Composite {
    private static String lastDirectoryDialogPath = null;
    private static String lastFileDialogPath = null;
    private Tree tree;

    public TreeWithAddRemove(Composite composite, int n, String string) {
        super(composite, n);
        if (string == null) {
            string = "";
        }
        final Shell shell = composite.getShell();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        this.tree = new Tree((Composite)this, 2048);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.tree);
        this.resetTreeItems(string);
        Composite composite2 = new Composite((Composite)this, 0);
        GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)composite2);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        Button button = new Button(composite2, 8);
        button.setText("Add Source Folder");
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DirectoryDialog directoryDialog = new DirectoryDialog(shell);
                directoryDialog.setFilterPath(lastDirectoryDialogPath);
                String string = directoryDialog.open();
                if (string != null) {
                    lastDirectoryDialogPath = string;
                }
                TreeWithAddRemove.this.addTreeItem(string);
            }
        });
        button = new Button(composite2, 8);
        button.setText("Add ZIP/JAR/EGG");
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(shell);
                fileDialog.setFilterPath(lastFileDialogPath);
                fileDialog.open();
                String[] stringArray = fileDialog.getFileNames();
                if (stringArray != null && stringArray.length > 0) {
                    lastFileDialogPath = fileDialog.getFilterPath();
                    String[] stringArray2 = stringArray;
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string = stringArray2[n2];
                        StringBuffer stringBuffer = new StringBuffer(lastFileDialogPath);
                        if (stringBuffer.charAt(stringBuffer.length() - 1) != File.separatorChar) {
                            stringBuffer.append(File.separatorChar);
                        }
                        stringBuffer.append(string);
                        TreeWithAddRemove.this.addTreeItem(stringBuffer.toString());
                        ++n2;
                    }
                }
            }
        });
        button = new Button(composite2, 8);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)button);
        button.setText("Remove");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TreeItem[] treeItemArray = TreeWithAddRemove.this.tree.getSelection();
                int n = 0;
                while (n < treeItemArray.length) {
                    treeItemArray[n].dispose();
                    ++n;
                }
            }
        });
    }

    private static String[] stringToStringArray(String string) {
        String string2 = System.getProperty("path.separator", "|");
        return string.split(string2);
    }

    private void addTreeItem(String string) {
        if (string != null && string.trim().length() > 0) {
            TreeItem treeItem = new TreeItem(this.tree, 0);
            treeItem.setText(string);
            File file = new File(string);
            if (file.isDirectory()) {
                treeItem.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER"));
            } else if (file.isFile()) {
                treeItem.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE"));
            } else {
                treeItem.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
            }
        }
    }

    public String getTreeItemsAsString() {
        String string = System.getProperty("path.separator", "|");
        StringBuffer stringBuffer = new StringBuffer();
        TreeItem[] treeItemArray = this.tree.getItems();
        int n = 0;
        while (n < treeItemArray.length) {
            String string2 = treeItemArray[n].getText();
            if (string2 != null && string2.trim().length() > 0) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(string);
                }
                stringBuffer.append(string2);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void resetTreeItems(String string) {
        String[] stringArray;
        this.tree.removeAll();
        String[] stringArray2 = stringArray = TreeWithAddRemove.stringToStringArray(string);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            this.addTreeItem(string2);
            ++n2;
        }
    }
}

