/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.toolbox;

import fable.framework.toolbox.ExceptionMessageDialog;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.examples.rcp.texteditor.editors.PathEditorInput;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class SWTUtils {
    public static final String LS = System.getProperty("line.separator");

    public static String timeStamp() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd, yyyy HH:mm:ss.SSS");
        return simpleDateFormat.format(date);
    }

    public static String timeStamp(String string) {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        return simpleDateFormat.format(date);
    }

    public static void errMsg(String string) {
        SWTUtils.errMsg(null, string);
    }

    public static void errMsg(Shell shell, String string) {
        MessageDialog.openError((Shell)shell, (String)"Error", (String)string);
    }

    public static void errMsgAsync(String string) {
        SWTUtils.errMsgAsync(null, string);
    }

    public static void errMsgAsync(final Shell shell, final String string) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)shell, (String)"Error", (String)string);
            }
        });
    }

    public static void warnMsg(String string) {
        SWTUtils.warnMsg(null, string);
    }

    public static void warnMsg(Shell shell, String string) {
        MessageDialog.openWarning((Shell)shell, (String)"Warning", (String)string);
    }

    public static void warnMsgAsync(String string) {
        SWTUtils.warnMsgAsync(null, string);
    }

    public static void warnMsgAsync(final Shell shell, final String string) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openWarning((Shell)shell, (String)"Warning", (String)string);
            }
        });
    }

    public static void infoMsg(String string) {
        SWTUtils.infoMsg(null, string);
    }

    public static void infoMsg(Shell shell, String string) {
        MessageDialog.openInformation((Shell)shell, (String)"Information", (String)string);
    }

    public static void infoMsgAsync(String string) {
        SWTUtils.infoMsgAsync(null, string);
    }

    public static void infoMsgAsync(final Shell shell, final String string) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation((Shell)shell, (String)"Information", (String)string);
            }
        });
    }

    public static void excMsg(String string, Exception exception) {
        SWTUtils.excMsg(null, string, exception);
    }

    public static void excMsg(Shell shell, String string, Exception exception) {
        String string2 = String.valueOf(string) + LS + LS + "Exception: " + exception + LS + "Message: " + exception.getMessage();
        MessageDialog.openError((Shell)shell, (String)"Exception", (String)string2);
    }

    public static void excMsgAsync(String string, Exception exception) {
        SWTUtils.excMsgAsync(null, string, exception);
    }

    public static void excMsgAsync(final Shell shell, String string, Exception exception) {
        final String string2 = String.valueOf(string) + LS + LS + "Exception: " + exception + LS + "Message: " + exception.getMessage();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)shell, (String)"Exception", (String)string2);
            }
        });
    }

    public static void excTraceMsg(String string, Exception exception) {
        SWTUtils.excTraceMsg(null, string, exception);
    }

    public static void excTraceMsg(Shell shell, String string, Exception exception) {
        ExceptionMessageDialog.openException(shell, "Exception", string, exception);
    }

    public static void excTraceMsgAsync(String string, Exception exception) {
        SWTUtils.excTraceMsgAsync(null, string, exception);
    }

    public static void excTraceMsgAsync(final Shell shell, final String string, final Exception exception) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ExceptionMessageDialog.openException(shell, "Exception", string, exception);
            }
        });
    }

    public static String convertText(String string) {
        String string2 = Text.DELIMITER;
        if (string2.equals(LS)) {
            return string;
        }
        String string3 = "";
        char c = '\n';
        char c2 = '\r';
        char c3 = '\u0000';
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c4 = string.charAt(n2);
            char c5 = c4;
            string3 = c5 != c ? String.valueOf(string3) + c4 : (n2 > 0 ? ((c3 = string.charAt(n2 - 1)) == c2 ? String.valueOf(string3) + c4 : String.valueOf(string3) + string2) : String.valueOf(string3) + string2);
            ++n2;
        }
        return string3;
    }

    public static void createFileFromIFile(IFile iFile, InputStream inputStream, IProgressMonitor iProgressMonitor) throws CoreException {
        if (inputStream == null) {
            inputStream = new ByteArrayInputStream(new byte[0]);
        }
        try {
            IPath iPath = iFile.getFullPath();
            IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            int n = iPath.segmentCount();
            if (n > 2 && !iWorkspaceRoot.getFolder(iPath.removeLastSegments(1)).exists()) {
                int n2 = n - 2;
                while (n2 > 0) {
                    IFolder iFolder = iWorkspaceRoot.getFolder(iPath.removeLastSegments(n2));
                    if (!iFolder.exists()) {
                        iFolder.create(false, true, iProgressMonitor);
                    }
                    --n2;
                }
            }
            iFile.create(inputStream, false, iProgressMonitor);
        }
        catch (CoreException coreException) {
            if (coreException.getStatus().getCode() == 374) {
                iFile.refreshLocal(0, null);
            }
            throw coreException;
        }
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public static IPath getPath(IEditorInput iEditorInput) {
        IPath iPath = null;
        if (iEditorInput instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
            iPath = iFileEditorInput.getFile().getLocation();
        } else if (iEditorInput instanceof IPathEditorInput) {
            IPathEditorInput iPathEditorInput = (IPathEditorInput)iEditorInput;
            iPath = iPathEditorInput.getPath();
        } else if (iEditorInput instanceof IStorageEditorInput) {
            IStorageEditorInput iStorageEditorInput = (IStorageEditorInput)iEditorInput;
            try {
                iPath = iStorageEditorInput.getStorage().getFullPath();
            }
            catch (CoreException coreException) {}
        } else if (iEditorInput instanceof FileStoreEditorInput) {
            FileStoreEditorInput fileStoreEditorInput = (FileStoreEditorInput)iEditorInput;
            iPath = new Path(fileStoreEditorInput.getURI().getPath());
        }
        return iPath;
    }

    public static IFile getFile(IEditorInput iEditorInput) {
        IFile iFile = null;
        if (iEditorInput instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
            iFile = iFileEditorInput.getFile();
        } else if (iEditorInput instanceof IPathEditorInput) {
            IPathEditorInput iPathEditorInput = (IPathEditorInput)iEditorInput;
            IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            if (iWorkspaceRoot.getLocation().isPrefixOf(iPathEditorInput.getPath())) {
                iFile = ResourcesPlugin.getWorkspace().getRoot().getFile(iPathEditorInput.getPath());
            }
        } else if (iEditorInput instanceof IStorageEditorInput) {
            iFile = null;
        } else if (iEditorInput instanceof FileStoreEditorInput) {
            IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            FileStoreEditorInput fileStoreEditorInput = (FileStoreEditorInput)iEditorInput;
            URI uRI = fileStoreEditorInput.getURI();
            String string = uRI.getPath();
            if (uRI.getScheme().equals("file") && (uRI.getHost() == null || uRI.getHost().equals("localhost")) && string.startsWith(iWorkspaceRoot.getLocation().toOSString())) {
                iFile = iWorkspaceRoot.getFile((IPath)new Path(string));
            }
        }
        return iFile;
    }

    public static String getNameExtension(IEditorInput iEditorInput) {
        return SWTUtils.getPath(iEditorInput).getFileExtension();
    }

    public static void enableControlTree(Control control, boolean bl) {
        if (control == null) {
            return;
        }
        if (control instanceof Composite) {
            Control[] controlArray;
            Composite composite = (Composite)control;
            Control[] controlArray2 = controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control2 = controlArray2[n2];
                SWTUtils.enableControlTree(control2, bl);
                ++n2;
            }
        }
        control.setEnabled(bl);
    }

    public static BufferedImage convertToAWT(ImageData imageData) {
        Object object;
        ColorModel colorModel = null;
        PaletteData paletteData = imageData.palette;
        if (paletteData.isDirect) {
            colorModel = new DirectColorModel(imageData.depth, paletteData.redMask, paletteData.greenMask, paletteData.blueMask);
            BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(imageData.width, imageData.height), false, null);
            int n = 0;
            while (n < imageData.height) {
                int n2 = 0;
                while (n2 < imageData.width) {
                    int n3 = imageData.getPixel(n2, n);
                    RGB rGB = paletteData.getRGB(n3);
                    bufferedImage.setRGB(n2, n, rGB.red << 16 | rGB.green << 8 | rGB.blue);
                    ++n2;
                }
                ++n;
            }
            return bufferedImage;
        }
        RGB[] rGBArray = paletteData.getRGBs();
        byte[] byArray = new byte[rGBArray.length];
        byte[] byArray2 = new byte[rGBArray.length];
        byte[] byArray3 = new byte[rGBArray.length];
        int n = 0;
        while (n < rGBArray.length) {
            object = rGBArray[n];
            byArray[n] = (byte)((RGB)object).red;
            byArray2[n] = (byte)((RGB)object).green;
            byArray3[n] = (byte)((RGB)object).blue;
            ++n;
        }
        colorModel = imageData.transparentPixel != -1 ? new IndexColorModel(imageData.depth, rGBArray.length, byArray, byArray2, byArray3, imageData.transparentPixel) : new IndexColorModel(imageData.depth, rGBArray.length, byArray, byArray2, byArray3);
        BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(imageData.width, imageData.height), false, null);
        object = bufferedImage.getRaster();
        int[] nArray = new int[1];
        int n4 = 0;
        while (n4 < imageData.height) {
            int n5 = 0;
            while (n5 < imageData.width) {
                int n6;
                nArray[0] = n6 = imageData.getPixel(n5, n4);
                ((WritableRaster)object).setPixel(n5, n4, nArray);
                ++n5;
            }
            ++n4;
        }
        return bufferedImage;
    }

    public static ImageData convertToSWT(BufferedImage bufferedImage) {
        if (bufferedImage.getColorModel() instanceof DirectColorModel) {
            DirectColorModel directColorModel = (DirectColorModel)bufferedImage.getColorModel();
            PaletteData paletteData = new PaletteData(directColorModel.getRedMask(), directColorModel.getGreenMask(), directColorModel.getBlueMask());
            ImageData imageData = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), directColorModel.getPixelSize(), paletteData);
            int n = 0;
            while (n < imageData.height) {
                int n2 = 0;
                while (n2 < imageData.width) {
                    int n3 = bufferedImage.getRGB(n2, n);
                    int n4 = paletteData.getPixel(new RGB(n3 >> 16 & 0xFF, n3 >> 8 & 0xFF, n3 & 0xFF));
                    imageData.setPixel(n2, n, n4);
                    ++n2;
                }
                ++n;
            }
            return imageData;
        }
        if (bufferedImage.getColorModel() instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)bufferedImage.getColorModel();
            int n = indexColorModel.getMapSize();
            byte[] byArray = new byte[n];
            byte[] byArray2 = new byte[n];
            byte[] byArray3 = new byte[n];
            indexColorModel.getReds(byArray);
            indexColorModel.getGreens(byArray2);
            indexColorModel.getBlues(byArray3);
            RGB[] rGBArray = new RGB[n];
            int n5 = 0;
            while (n5 < rGBArray.length) {
                rGBArray[n5] = new RGB(byArray[n5] & 0xFF, byArray2[n5] & 0xFF, byArray3[n5] & 0xFF);
                ++n5;
            }
            PaletteData paletteData = new PaletteData(rGBArray);
            ImageData imageData = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), indexColorModel.getPixelSize(), paletteData);
            imageData.transparentPixel = indexColorModel.getTransparentPixel();
            WritableRaster writableRaster = bufferedImage.getRaster();
            int[] nArray = new int[1];
            int n6 = 0;
            while (n6 < imageData.height) {
                int n7 = 0;
                while (n7 < imageData.width) {
                    writableRaster.getPixel(n7, n6, nArray);
                    imageData.setPixel(n7, n6, nArray[0]);
                    ++n7;
                }
                ++n6;
            }
            return imageData;
        }
        return null;
    }

    public static int getTextWidth(Text text, int n) {
        GC gC = new GC((Drawable)text);
        FontMetrics fontMetrics = gC.getFontMetrics();
        int n2 = n * fontMetrics.getAverageCharWidth();
        gC.dispose();
        return n2;
    }

    public static IEditorInput createEditorInput(File file) {
        Path path = new Path(file.getAbsolutePath());
        IFile iFile = null;
        FileEditorInput fileEditorInput = null;
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (iWorkspaceRoot != null && path != null) {
            iFile = iWorkspaceRoot.getFileForLocation((IPath)path);
        }
        if (iFile != null) {
            fileEditorInput = new FileEditorInput(iFile);
        }
        if (fileEditorInput != null) {
            return fileEditorInput;
        }
        IFileStore iFileStore = null;
        String string = null;
        File file2 = file.getParentFile();
        if (file2 != null) {
            string = file2.getAbsolutePath();
        }
        if (string != null) {
            iFileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(string));
        }
        if (iFileStore != null) {
            iFileStore = iFileStore.getChild(file.getName());
        }
        if (iFileStore != null) {
            fileEditorInput = new FileStoreEditorInput(iFileStore);
        }
        if (fileEditorInput != null) {
            return fileEditorInput;
        }
        fileEditorInput = new PathEditorInput((IPath)path);
        return fileEditorInput;
    }

    public static boolean tryToRefreshProject(String string) {
        if (string == null) {
            return false;
        }
        Path path = new Path(string);
        IFile iFile = null;
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (iWorkspaceRoot != null && path != null) {
            iFile = iWorkspaceRoot.getFileForLocation((IPath)path);
        }
        if (iFile != null) {
            try {
                IProject iProject = iFile.getProject();
                iProject.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception exception) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public static boolean tryToOpenWorkspaceFileEditor(String string, String string2) {
        if (string == null) {
            return false;
        }
        Path path = new Path(string);
        IFile iFile = null;
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (iWorkspaceRoot != null && path != null) {
            iFile = iWorkspaceRoot.getFileForLocation((IPath)path);
        }
        if (iFile != null) {
            try {
                IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
                FileEditorInput fileEditorInput = new FileEditorInput(iFile);
                iWorkbenchPage.openEditor((IEditorInput)fileEditorInput, string2);
            }
            catch (Exception exception) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public static boolean tryToOpenExternalFileEditor(String string) {
        if (string == null) {
            return false;
        }
        File file = new File(string);
        if (!file.exists() || !file.isFile()) {
            return false;
        }
        try {
            IFileStore iFileStore = EFS.getLocalFileSystem().getStore(file.toURI());
            IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IDE.openEditorOnFileStore((IWorkbenchPage)iWorkbenchPage, (IFileStore)iFileStore);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }
}

