/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.toolbox;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class MenuAction
extends Action
implements IMenuCreator,
IPropertyChangeListener {
    private Menu fMenu;
    private List<IAction> actions;
    private Action lastAction;
    private String mainText;
    private boolean useTextOfAction;

    public MenuAction(String string) {
        this(string, false);
    }

    public MenuAction(String string, boolean bl) {
        super(string, 4);
        this.setMenuCreator(this);
        this.actions = new ArrayList<IAction>(7);
        this.useTextOfAction = bl;
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
        for (IAction iAction : this.actions) {
            iAction.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        this.actions.clear();
        this.lastAction = null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.lastAction = (Action)propertyChangeEvent.getSource();
        this.updateSelectedValue();
    }

    private void updateSelectedValue() {
        Action object = this.lastAction;
        if (object == null) {
            for (IAction stringBuilder : this.actions) {
                if (!stringBuilder.isChecked()) continue;
                object = stringBuilder;
                break;
            }
        }
        if (object != null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.mainText != null) {
                stringBuilder.append(this.mainText);
                stringBuilder.append("\n");
            }
            stringBuilder.append(object.getText());
            super.setToolTipText(stringBuilder.toString());
            if (this.useTextOfAction) {
                this.setText(object.getText());
            }
        }
    }

    public void setToolTipText(String string) {
        this.mainText = string;
        super.setToolTipText(string);
        this.updateSelectedValue();
    }

    public Menu getMenu(Menu menu) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(menu);
        for (IAction iAction : this.actions) {
            this.addActionToMenu(this.fMenu, iAction);
        }
        return this.fMenu;
    }

    public void add(IAction iAction) {
        this.actions.add(iAction);
        iAction.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public Menu getMenu(Control control) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(control);
        for (IAction iAction : this.actions) {
            this.addActionToMenu(this.fMenu, iAction);
        }
        return this.fMenu;
    }

    protected void addActionToMenu(Menu menu, IAction iAction) {
        ActionContributionItem actionContributionItem = new ActionContributionItem(iAction);
        actionContributionItem.fill(menu, -1);
    }

    public void run() {
        if (this.lastAction != null) {
            this.lastAction.run();
        }
    }

    void clear() {
        this.dispose();
    }

    public void setSelected(int n) {
        if (this.actions == null || n > this.actions.size() - 1) {
            return;
        }
        this.actions.get(n).setChecked(true);
    }
}

