/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.toolbox;

import fable.framework.toolbox.ControlField;
import fable.framework.toolbox.TypedText;
import org.eclipse.swt.widgets.Composite;

public class IntegerText
extends TypedText {
    protected Integer _fieldValue;
    protected Integer _MinValue;
    protected Integer _MaxValue;
    protected boolean _bMaxIsIncluded = false;
    protected boolean _bMinIsIncluded = false;

    public IntegerText(Composite composite, int n) {
        super(composite, n);
    }

    public IntegerText(Composite composite, int n, String string) {
        super(composite, n, string);
    }

    public IntegerText(Composite composite, int n, String string, int n2, int n3) {
        this(composite, n, string);
        this.setMinValue(n2, true);
        this.setMaxValue(n3, true);
    }

    public void setMaxValue(int n, boolean bl) {
        this._bMaxIsIncluded = bl;
        this._MaxValue = new Integer(n);
    }

    public void setMinValue(int n, boolean bl) {
        this._bMinIsIncluded = bl;
        this._MinValue = new Integer(n);
    }

    @Override
    public boolean checkValue(String string) {
        boolean bl = true;
        if (string != null && !string.equals("")) {
            this._errorMessage = "Field should contain an integer value ";
            bl = ControlField.isInteger(string);
            if (bl) {
                this._fieldValue = Integer.valueOf(string);
                if (this._MaxValue != null && this._MinValue != null) {
                    if (this._bMinIsIncluded && this._bMaxIsIncluded) {
                        bl = Float.compare(this._fieldValue.intValue(), this._MinValue.floatValue()) >= 0 && Float.compare(this._fieldValue.intValue(), this._MaxValue.floatValue()) <= 0;
                        this._errorMessage = String.valueOf(this._errorMessage) + "between " + this._MinValue + " and " + this._MaxValue;
                    } else if (!this._bMinIsIncluded && this._bMaxIsIncluded) {
                        bl = Float.compare(this._fieldValue.intValue(), this._MinValue.floatValue()) > 0 && Float.compare(this._fieldValue.intValue(), this._MaxValue.floatValue()) <= 0;
                        this._errorMessage = String.valueOf(this._errorMessage) + " greater than " + this._MinValue + " and less or equal to " + this._MaxValue;
                    } else if (this._bMinIsIncluded && !this._bMaxIsIncluded) {
                        bl = Float.compare(this._fieldValue.intValue(), this._MinValue.floatValue()) >= 0 && Float.compare(this._fieldValue.intValue(), this._MaxValue.floatValue()) < 0;
                        this._errorMessage = String.valueOf(this._errorMessage) + " greater or equal to " + this._MinValue + " and less than " + this._MaxValue;
                    } else if (!this._bMinIsIncluded && !this._bMaxIsIncluded) {
                        bl = Float.compare(this._fieldValue.intValue(), this._MinValue.floatValue()) > 0 && Float.compare(this._fieldValue.intValue(), this._MaxValue.floatValue()) < 0;
                        this._errorMessage = String.valueOf(this._errorMessage) + " greater than " + this._MinValue + " and less than " + this._MaxValue;
                    }
                } else if (this._MinValue != null && this._MaxValue == null) {
                    if (this._bMinIsIncluded) {
                        bl = Float.compare(this._fieldValue.intValue(), this._MinValue.floatValue()) >= 0;
                        this._errorMessage = String.valueOf(this._errorMessage) + " greater or equal to " + this._MinValue;
                    } else {
                        bl = Float.compare(this._fieldValue.intValue(), this._MinValue.floatValue()) > 0;
                        this._errorMessage = String.valueOf(this._errorMessage) + " greater than " + this._MinValue;
                    }
                } else if (this._MinValue == null && this._MaxValue != null) {
                    if (this._bMaxIsIncluded) {
                        bl = Float.compare(this._fieldValue.intValue(), this._MaxValue.floatValue()) <= 0;
                        this._errorMessage = String.valueOf(this._errorMessage) + " and less or equal to " + this._MaxValue;
                    } else {
                        bl = Float.compare(this._fieldValue.intValue(), this._MaxValue.floatValue()) < 0;
                        this._errorMessage = String.valueOf(this._errorMessage) + " less than " + this._MaxValue;
                    }
                }
            }
        } else if (this._isRequiredField) {
            bl = false;
        }
        return bl;
    }

    @Override
    protected String getErrorFormatDescription() {
        return this._errorMessage;
    }
}

