/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.toolbox;

import fable.framework.logging.FableLogger;
import fable.framework.toolbox.TypedText;
import org.eclipse.swt.widgets.Composite;
import org.slf4j.Logger;

public class FloatText
extends TypedText {
    protected Float fieldValue = null;
    protected Float minValue;
    protected Float maxValue;
    protected boolean maxIsIncluded = false;
    protected boolean minIsIncluded = false;
    private Logger logger;

    public FloatText(Composite composite, int n) {
        super(composite, n);
    }

    public FloatText(Composite composite, int n, String string) {
        super(composite, n, string);
        this.logger = FableLogger.getLogger();
    }

    public FloatText(Composite composite, int n, String string, float f, float f2) {
        this(composite, n, string);
        this.setMinValue(f, true);
        this.setMaxValue(f2, true);
    }

    public Float getValue() {
        return this.fieldValue;
    }

    public void setMaxValue(float f, boolean bl) {
        this.maxIsIncluded = bl;
        this.maxValue = new Float(f);
    }

    public void setMinValue(float f, boolean bl) {
        this.minIsIncluded = bl;
        this.minValue = new Float(f);
    }

    @Override
    public boolean set_Text(String string) {
        return super.set_Text(string);
    }

    @Override
    public String getText() {
        String string = this.getTextField().getText();
        return string;
    }

    @Override
    public boolean checkValue(String string) {
        boolean bl;
        block17: {
            bl = true;
            if (string != null && !string.equals("")) {
                this._errorMessage = "Field should contain a float value ";
                try {
                    this.fieldValue = Float.valueOf(string);
                    if (this.maxValue != null && this.minValue != null) {
                        if (this.minIsIncluded && this.maxIsIncluded) {
                            bl = Float.compare(this.fieldValue.floatValue(), this.minValue.floatValue()) >= 0 && Float.compare(this.fieldValue.floatValue(), this.maxValue.floatValue()) <= 0;
                            this._errorMessage = String.valueOf(this._errorMessage) + "between " + this.minValue + " and " + this.maxValue;
                        } else if (!this.minIsIncluded && this.maxIsIncluded) {
                            bl = Float.compare(this.fieldValue.floatValue(), this.minValue.floatValue()) > 0 && Float.compare(this.fieldValue.floatValue(), this.maxValue.floatValue()) <= 0;
                            this._errorMessage = String.valueOf(this._errorMessage) + " greater than " + this.minValue + " and less or equal to " + this.maxValue;
                        } else if (this.minIsIncluded && !this.maxIsIncluded) {
                            bl = Float.compare(this.fieldValue.floatValue(), this.minValue.floatValue()) >= 0 && Float.compare(this.fieldValue.floatValue(), this.maxValue.floatValue()) < 0;
                            this._errorMessage = String.valueOf(this._errorMessage) + " greater or equal to " + this.minValue + " and less than " + this.maxValue;
                        } else if (!this.minIsIncluded && !this.maxIsIncluded) {
                            bl = Float.compare(this.fieldValue.floatValue(), this.minValue.floatValue()) > 0 && Float.compare(this.fieldValue.floatValue(), this.maxValue.floatValue()) < 0;
                            this._errorMessage = String.valueOf(this._errorMessage) + " greater than " + this.minValue + " and less than " + this.maxValue;
                        }
                        break block17;
                    }
                    if (this.minValue != null && this.maxValue == null) {
                        if (this.minIsIncluded) {
                            bl = Float.compare(this.fieldValue.floatValue(), this.minValue.floatValue()) >= 0;
                            this._errorMessage = String.valueOf(this._errorMessage) + " greater or equal to " + this.minValue;
                        } else {
                            bl = Float.compare(this.fieldValue.floatValue(), this.minValue.floatValue()) > 0;
                            this._errorMessage = String.valueOf(this._errorMessage) + " greater than " + this.minValue;
                        }
                        break block17;
                    }
                    if (this.minValue != null || this.maxValue == null) break block17;
                    if (this.maxIsIncluded) {
                        bl = Float.compare(this.fieldValue.floatValue(), this.maxValue.floatValue()) <= 0;
                        this._errorMessage = String.valueOf(this._errorMessage) + " and less or equal to " + this.maxValue;
                        break block17;
                    }
                    bl = Float.compare(this.fieldValue.floatValue(), this.maxValue.floatValue()) < 0;
                    this._errorMessage = String.valueOf(this._errorMessage) + " less than " + this.maxValue;
                }
                catch (NumberFormatException numberFormatException) {
                    bl = false;
                    this.logger.error(numberFormatException.getMessage());
                }
            } else if (this._isRequiredField) {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    protected String getErrorFormatDescription() {
        return this._errorMessage;
    }

    public void setText(String string) {
        this.set_Text(string);
    }
}

