/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.toolbox;

import fable.framework.logging.FableLogger;
import fable.framework.toolbox.ExceptionMessageDialog;
import java.io.File;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

public class FableUtils {
    public static final String LS = System.getProperty("line.separator");

    public static String generateIDMessage(Object object, String string) {
        String string2;
        if (object == null) {
            return string;
        }
        if (object instanceof String) {
            string2 = (String)object;
        } else if (object instanceof Class) {
            try {
                string2 = ((Class)object).getName();
            }
            catch (Throwable throwable) {
                string2 = object.toString();
            }
        } else {
            try {
                string2 = object.getClass().getName();
            }
            catch (Throwable throwable) {
                string2 = object.toString();
            }
        }
        if (string2.length() == 0) {
            return string;
        }
        if (string == null) {
            return string2;
        }
        return String.valueOf(string2) + ": " + string;
    }

    public static void excTraceMsg(Object object, final String string, final Throwable throwable) {
        final String string2 = throwable instanceof Error ? "Error" : "Exception";
        String string3 = String.valueOf(string) + LS + LS + string2 + ": " + throwable + LS + "Message: " + throwable.getMessage();
        FableLogger.error(FableUtils.generateIDMessage(object, string3), throwable);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ExceptionMessageDialog.openException(null, string2, string, throwable);
            }
        });
    }

    public static void excMsg(Object object, String string, Throwable throwable) {
        final String string2 = throwable instanceof Error ? "Error" : "Exception";
        final String string3 = String.valueOf(string) + LS + LS + string2 + ": " + throwable + LS + "Message: " + throwable.getMessage();
        FableLogger.error(FableUtils.generateIDMessage(object, string3), throwable);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError(null, (String)string2, (String)string3);
            }
        });
    }

    public static void excNoTraceMsg(Object object, String string, Throwable throwable) {
        final String string2 = throwable instanceof Error ? "Error" : "Exception";
        final String string3 = String.valueOf(string) + LS + LS + string2 + ": " + throwable + LS + "Message: " + throwable.getMessage();
        FableLogger.error(FableUtils.generateIDMessage(object, string3));
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError(null, (String)string2, (String)string3);
            }
        });
    }

    public static void errMsg(Object object, final String string) {
        FableLogger.error(FableUtils.generateIDMessage(object, string));
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError(null, (String)"Error", (String)string);
            }
        });
    }

    public static void warnMsg(Object object, final String string) {
        FableLogger.warn(FableUtils.generateIDMessage(object, string));
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openWarning(null, (String)"Warning", (String)string);
            }
        });
    }

    public static void infoMsg(Object object, final String string) {
        FableLogger.info(FableUtils.generateIDMessage(object, string));
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation(null, (String)"Info", (String)string);
            }
        });
    }

    public static boolean confirmMsg(Object object, String string) {
        boolean bl = false;
        bl = MessageDialog.openConfirm(null, (String)"Confirm", (String)string);
        return bl;
    }

    public static String getShortName(String string) {
        File file = new File(string);
        if (file == null) {
            return null;
        }
        return file.getName();
    }

    public static String getExtension(File file) {
        return FableUtils.getExtension(file.getName());
    }

    public static String getExtension(String string) {
        String string2 = null;
        int n = string.lastIndexOf(46);
        if (n > 0 && n < string.length() - 1) {
            string2 = string.substring(n + 1).toLowerCase();
        }
        return string2;
    }

    public static String changeFileExtension(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        int n = string.lastIndexOf(".");
        if (n != -1) {
            return String.valueOf(string.substring(0, n)) + string2;
        }
        return String.valueOf(string) + string2;
    }

    public static int questionMsg(String string) {
        String[] stringArray = new String[]{"OK", "Cancel", "No"};
        MessageDialog messageDialog = new MessageDialog(null, "Question", null, string, 3, stringArray, 0);
        return messageDialog.open();
    }
}

