/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.imageprint;

import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;

public class PrintSettings {
    private static final String DEFAULT_UNITS_FORMAT = "%.3f";
    private String unitsFormat = "%.3f";
    private Units units = Units.INCH;
    private double left = 1.0;
    private double right = 1.0;
    private double top = 1.0;
    private double bottom = 1.0;
    private int verticalAlign = 128;
    private int horizontalAlign = 0x1000000;
    private Orientation orientation = Orientation.PORTRAIT;
    private PrinterData printerData = null;

    public PrintSettings clone() {
        PrintSettings printSettings = new PrintSettings();
        printSettings.setUnits(this.units);
        printSettings.setLeft(this.left);
        printSettings.setRight(this.right);
        printSettings.setTop(this.top);
        printSettings.setBottom(this.bottom);
        printSettings.setVerticalAlign(this.verticalAlign);
        printSettings.setHorizontalAlign(this.horizontalAlign);
        printSettings.setOrientation(this.orientation);
        printSettings.setPrinterData(this.getPrinterData());
        return printSettings;
    }

    public ValueWithUnits scaleToInches(ValueWithUnits valueWithUnits) {
        Units units = this.units;
        Units[] unitsArray = Units.values();
        int n = unitsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Units units2 = unitsArray[n2];
            if (units2.getName().equals(valueWithUnits.getUnitsName())) {
                units = units2;
                break;
            }
            ++n2;
        }
        return new ValueWithUnits(units.scaleToInches(valueWithUnits.getVal()), units.getName());
    }

    public ValueWithUnits scaleFromInches(ValueWithUnits valueWithUnits) {
        Units units = this.units;
        Units[] unitsArray = Units.values();
        int n = unitsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Units units2 = unitsArray[n2];
            if (units2.getName().equals(valueWithUnits.getUnitsName())) {
                units = units2;
                break;
            }
            ++n2;
        }
        return new ValueWithUnits(units.scaleFromInches(valueWithUnits.getVal()), Units.INCH.getName());
    }

    public ValueWithUnits parseUnitsString(String string) {
        String[] stringArray = string.trim().split("\\s+");
        if (stringArray.length == 0) {
            return null;
        }
        double d = 0.0;
        String string2 = this.units.getName();
        try {
            d = Double.parseDouble(stringArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            d = 0.0;
        }
        if (stringArray.length >= 2) {
            Units[] unitsArray = Units.values();
            int n = unitsArray.length;
            int n2 = 0;
            while (n2 < n) {
                Units units = unitsArray[n2];
                if (stringArray[1].toLowerCase().equals(units.getName())) {
                    string2 = units.getName();
                    break;
                }
                ++n2;
            }
        }
        return new ValueWithUnits(d, string2);
    }

    public String getUnitsName() {
        return this.units.getName();
    }

    public Units getUnits() {
        return this.units;
    }

    public void setUnits(Units units) {
        this.units = units;
    }

    public void setUnits(String string) {
        Units[] unitsArray = Units.values();
        int n = unitsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Units units = unitsArray[n2];
            if (units.getName().equals(string)) {
                this.units = units;
                return;
            }
            ++n2;
        }
        this.units = Units.INCH;
    }

    public double getLeft() {
        return this.left;
    }

    public void setLeft(double d) {
        this.left = d;
    }

    public String getLeftString() {
        return new ValueWithUnits(this.units.scaleFromInches(this.left), this.units.getName()).getString();
    }

    public void setLeftString(String string) {
        this.left = this.scaleToInches(this.parseUnitsString(string)).getVal();
    }

    public double getRight() {
        return this.right;
    }

    public void setRight(double d) {
        this.right = d;
    }

    public String getRightString() {
        return new ValueWithUnits(this.units.scaleFromInches(this.right), this.units.getName()).getString();
    }

    public void setRightString(String string) {
        this.right = this.scaleToInches(this.parseUnitsString(string)).getVal();
    }

    public double getTop() {
        return this.top;
    }

    public void setTop(double d) {
        this.top = d;
    }

    public String getTopString() {
        return new ValueWithUnits(this.units.scaleFromInches(this.top), this.units.getName()).getString();
    }

    public void setTopString(String string) {
        this.top = this.scaleToInches(this.parseUnitsString(string)).getVal();
    }

    public double getBottom() {
        return this.bottom;
    }

    public void setBottom(double d) {
        this.bottom = d;
    }

    public String getBottomString() {
        return new ValueWithUnits(this.units.scaleFromInches(this.bottom), this.units.getName()).getString();
    }

    public void setBottomString(String string) {
        this.bottom = this.scaleToInches(this.parseUnitsString(string)).getVal();
    }

    public int getVerticalAlign() {
        return this.verticalAlign;
    }

    public void setVerticalAlign(int n) {
        this.verticalAlign = n;
    }

    public int getHorizontalAlign() {
        return this.horizontalAlign;
    }

    public void setHorizontalAlign(int n) {
        this.horizontalAlign = n;
    }

    public String getUnitsFormat() {
        return this.unitsFormat;
    }

    public void setUnitsFormat(String string) {
        this.unitsFormat = string;
    }

    public void resetUnitsFormat() {
        this.unitsFormat = DEFAULT_UNITS_FORMAT;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }

    public void setOrientation(String string) {
        Orientation[] orientationArray = Orientation.values();
        int n = orientationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Orientation orientation = orientationArray[n2];
            if (orientation.getName().equals(string)) {
                this.orientation = orientation;
                return;
            }
            ++n2;
        }
        this.orientation = Orientation.DEFAULT;
    }

    public PrinterData getPrinterData() {
        if (this.printerData == null) {
            this.printerData = Printer.getDefaultPrinterData();
        }
        if (this.printerData == null) {
            this.printerData = Printer.getPrinterList() != null ? Printer.getPrinterList()[0] : null;
        }
        return this.printerData;
    }

    public void setPrinterData(PrinterData printerData) {
        this.printerData = printerData;
    }

    public static enum Orientation {
        DEFAULT("Default"),
        PORTRAIT("Portrait"),
        LANDSCAPE("Landscape");

        private final String name;

        private Orientation(String string2) {
            this.name = string2;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum Units {
        INCH("in", 1.0),
        CENTIMETER("cm", 0.39370078740157477),
        MILLIMETER("mm", 0.003937007874015748);

        private final String name;
        private final double scale;

        private Units(String string2, double d) {
            this.name = string2;
            this.scale = d;
        }

        public String getName() {
            return this.name;
        }

        public double getScale() {
            return this.scale;
        }

        public double scaleToInches(double d) {
            return d * this.scale;
        }

        public double scaleFromInches(double d) {
            return d / this.scale;
        }
    }

    public class ValueWithUnits {
        private double val;
        private String unitsName;

        ValueWithUnits(double d, String string) {
            this.val = d;
            this.unitsName = string;
        }

        public String getString() {
            return String.format(String.valueOf(PrintSettings.this.unitsFormat) + " %s", this.val, this.unitsName);
        }

        public double getVal() {
            return this.val;
        }

        public String getUnitsName() {
            return this.unitsName;
        }
    }
}

