/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.imageprint;

import fable.framework.imageprint.FableImagePrinter;
import fable.framework.imageprint.ImagePrintPreviewDialog;
import fable.framework.imageprint.ImagePrintSetupDialog;
import fable.framework.imageprint.ImagePrintUtils;
import fable.framework.imageprint.PrintSettings;
import fable.framework.toolbox.ImageSelection;
import fable.framework.toolbox.SWTUtils;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.image.BufferedImage;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

public class JLChartActions {
    JLChart chart;
    Display display;
    public Action printSetupAction;
    public Action printPreviewAction;
    public Action printAction;
    public Action copyAction;

    public JLChartActions(Display display, JLChart jLChart) {
        this.chart = jLChart;
        this.display = display;
        this.printSetupAction = new Action("Print Setup"){

            public void run() {
                Image image = JLChartActions.this.getSWTChartImage();
                if (image == null) {
                    return;
                }
                ImagePrintSetupDialog imagePrintSetupDialog = new ImagePrintSetupDialog(JLChartActions.this.display.getActiveShell(), image, FableImagePrinter.getSettings());
                PrintSettings printSettings = imagePrintSetupDialog.open();
                if (image != null && !image.isDisposed()) {
                    image.dispose();
                }
                if (printSettings != null) {
                    FableImagePrinter.setSettings(printSettings);
                }
            }
        };
        this.printPreviewAction = new Action("Print Preview"){

            public void run() {
                Image image = JLChartActions.this.getSWTChartImage();
                if (image == null) {
                    return;
                }
                ImagePrintPreviewDialog imagePrintPreviewDialog = new ImagePrintPreviewDialog(JLChartActions.this.display.getActiveShell(), image, FableImagePrinter.getSettings());
                PrintSettings printSettings = imagePrintPreviewDialog.open();
                if (image != null && !image.isDisposed()) {
                    image.dispose();
                }
                if (printSettings != null) {
                    FableImagePrinter.setSettings(printSettings);
                }
            }
        };
        this.printAction = new Action("Print"){

            public void run() {
                Image image = JLChartActions.this.getSWTChartImage();
                if (image == null) {
                    return;
                }
                ImagePrintUtils.dialogPrintImage(JLChartActions.this.display.getActiveShell(), image, JLChartActions.this.display.getDPI(), FableImagePrinter.getSettings());
                if (image != null && !image.isDisposed()) {
                    image.dispose();
                }
            }
        };
        this.copyAction = new Action("Copy"){

            public void run() {
                BufferedImage bufferedImage = JLChartActions.this.getAWTChartImage();
                if (bufferedImage == null) {
                    return;
                }
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new ImageSelection(bufferedImage), null);
            }
        };
    }

    public BufferedImage getAWTChartImage() {
        if (this.display == null || this.display.isDisposed() || this.chart == null) {
            return null;
        }
        int n = this.chart.getSize().width;
        int n2 = this.chart.getSize().height;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        if (bufferedImage == null) {
            return null;
        }
        Color color = this.chart.getBackground();
        this.chart.setBackground(Color.WHITE);
        this.chart.paint(bufferedImage.getGraphics());
        this.chart.setBackground(color);
        return bufferedImage;
    }

    public Image getSWTChartImage() {
        if (this.display == null || this.display.isDisposed() || this.chart == null) {
            return null;
        }
        BufferedImage bufferedImage = this.getAWTChartImage();
        if (bufferedImage == null) {
            return null;
        }
        ImageData imageData = SWTUtils.convertToSWT(bufferedImage);
        if (imageData == null) {
            return null;
        }
        return new Image((Device)this.display, imageData);
    }

    public JLChart getChart() {
        return this.chart;
    }

    public void setChart(JLChart jLChart) {
        this.chart = jLChart;
    }
}

