/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.imageprint;

import fable.framework.imageprint.ImagePrintSetupDialog;
import fable.framework.imageprint.ImagePrintUtils;
import fable.framework.imageprint.PrintSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class ImagePrintPreviewDialog
extends Dialog {
    private static final int CANVAS_BORDER = 10;
    private static final Point CANVAS_SIZE = new Point(425, 550);
    private Point canvasSize = CANVAS_SIZE;
    private PrintSettings settings;
    private Image image;
    private Canvas canvas;
    private Button landscapeButton;
    private Button portraitButton;
    private boolean success = false;

    public ImagePrintPreviewDialog(Shell shell, Image image, PrintSettings printSettings) {
        this(shell, 2144, image, printSettings);
    }

    public ImagePrintPreviewDialog(Shell shell, int n, Image image, PrintSettings printSettings) {
        super(shell, n);
        this.image = image != null ? new Image(image.getDevice(), image, 0) : null;
        this.settings = printSettings != null ? printSettings.clone() : new PrintSettings();
    }

    public PrintSettings open() {
        final Shell shell = new Shell(this.getParent(), this.getStyle() | 0x10);
        shell.setText("Print preview");
        shell.setLayout((Layout)new GridLayout(6, false));
        Composite composite = new Composite((Composite)shell, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        GridDataFactory.fillDefaults().applyTo((Control)composite);
        this.portraitButton = new Button(composite, 16);
        this.portraitButton.setText("Portrait");
        this.portraitButton.setToolTipText("Use Portrait for the preview");
        this.portraitButton.setSelection(this.settings.getOrientation() != PrintSettings.Orientation.LANDSCAPE);
        this.portraitButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImagePrintPreviewDialog.this.settings.setOrientation(PrintSettings.Orientation.PORTRAIT);
                ImagePrintPreviewDialog.this.canvas.redraw();
            }
        });
        this.landscapeButton = new Button(composite, 16);
        this.landscapeButton.setText("Landscape");
        this.landscapeButton.setToolTipText("Use Portrait for the preview");
        this.landscapeButton.setSelection(this.settings.getOrientation() == PrintSettings.Orientation.LANDSCAPE);
        this.landscapeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImagePrintPreviewDialog.this.settings.setOrientation(PrintSettings.Orientation.LANDSCAPE);
                ImagePrintPreviewDialog.this.canvas.redraw();
            }
        });
        Button button = new Button((Composite)shell, 8);
        button.setText("Print Setup");
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ImagePrintSetupDialog imagePrintSetupDialog = new ImagePrintSetupDialog(shell, ImagePrintPreviewDialog.this.image, ImagePrintPreviewDialog.this.settings);
                ImagePrintPreviewDialog.this.settings = imagePrintSetupDialog.open();
                ImagePrintPreviewDialog.this.setOrientation();
                ImagePrintPreviewDialog.this.canvas.redraw();
            }
        });
        button = new Button((Composite)shell, 8);
        button.setText("Select Printer");
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PrintDialog printDialog = new PrintDialog(shell);
                PrinterData printerData = printDialog.open();
                if (printerData == null) {
                    return;
                }
                ImagePrintPreviewDialog.this.settings.setPrinterData(printerData);
                ImagePrintPreviewDialog.this.canvas.redraw();
            }
        });
        button = new Button((Composite)shell, 8);
        button.setText("Print");
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ImagePrintUtils.dialogPrintImage(shell, ImagePrintPreviewDialog.this.image, shell.getDisplay().getDPI(), ImagePrintPreviewDialog.this.settings);
            }
        });
        button = new Button((Composite)shell, 8);
        button.setText("Cancel");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImagePrintPreviewDialog.this.success = false;
                shell.close();
            }
        });
        button = new Button((Composite)shell, 8);
        button.setText("OK");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImagePrintPreviewDialog.this.success = true;
                shell.close();
            }
        });
        this.canvas = new Canvas((Composite)shell, 2048);
        GridDataFactory.fillDefaults().grab(true, true).span(6, 1).hint(this.canvasSize).applyTo((Control)this.canvas);
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                ImagePrintPreviewDialog.this.paint(paintEvent);
            }
        });
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (shell.getDisplay().readAndDispatch()) continue;
            shell.getDisplay().sleep();
        }
        if (this.image != null && !this.image.isDisposed()) {
            this.image.dispose();
            this.image = null;
        }
        if (this.success) {
            return this.settings;
        }
        return null;
    }

    private void setOrientation() {
        boolean bl;
        boolean bl2 = bl = this.settings.getOrientation() != PrintSettings.Orientation.LANDSCAPE;
        if (this.portraitButton != null) {
            this.portraitButton.setSelection(bl);
        }
        if (this.landscapeButton != null) {
            this.landscapeButton.setSelection(!bl);
        }
    }

    private void paint(PaintEvent paintEvent) {
        GC gC = paintEvent.gc;
        Rectangle rectangle = this.canvas.getClientArea();
        rectangle.x += 10;
        rectangle.y += 10;
        rectangle.width -= 20;
        rectangle.height -= 20;
        if (this.settings.getPrinterData() != null) {
            ImagePrintUtils.paintPreview(gC, this.canvas, rectangle, this.image, this.settings);
        }
    }

    public Point getCanvasSize() {
        return this.canvasSize;
    }

    public void setCanvasSize(Point point) {
        this.canvasSize = point;
    }
}

