/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.jyconsole.ui;

import com.artenum.gui.tk.ToolBox;
import com.artenum.jyconsole.JyConsole;
import com.artenum.jyconsole.io.InteractiveCommandLine;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CompletionWindow
extends JWindow
implements KeyListener,
ListSelectionListener,
MouseMotionListener,
MouseListener,
FocusListener {
    private JList list;
    private MethodeModel model;
    private JyConsole console;
    private JScrollPane scroll;
    private InteractiveCommandLine cmdOrigine;
    private int maxHeight = -1;
    private JPanel resize;
    private Dimension size;

    public CompletionWindow(JyConsole jyConsole) {
        super(ToolBox.getParentFrame((Component)jyConsole));
        this.console = jyConsole;
        this.resize = new JPanel();
        this.resize.setMinimumSize(new Dimension(10, 10));
        this.resize.addMouseMotionListener(this);
        this.resize.addMouseListener(this);
        this.model = new MethodeModel();
        this.list = new JList(this.model);
        this.list.addFocusListener(this);
        this.list.addListSelectionListener(this);
        this.scroll = new JScrollPane(this.list, 22, 32);
        this.scroll.setCorner("LOWER_RIGHT_CORNER", this.resize);
        this.getContentPane().add(this.scroll);
        this.setSize(300, 100);
        this.list.addKeyListener(this);
        this.list.getInputMap().clear();
        this.scroll.getInputMap().clear();
        this.maxHeight = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        this.cmdOrigine = jyConsole.getInteractiveCommandLine();
    }

    public MethodeModel getModel() {
        return this.model;
    }

    public void showWindow() {
        Point point = this.console.getCompletionWindowLocation();
        if ((double)(point.y + this.getHeight()) > Toolkit.getDefaultToolkit().getScreenSize().getHeight()) {
            point.y = (int)(Toolkit.getDefaultToolkit().getScreenSize().getHeight() - (double)this.getHeight());
        }
        this.setLocation(point);
        this.setVisible(true);
        if (System.getProperty("os.name").toLowerCase().indexOf("linux") == -1) {
            this.showOnWindows();
        } else if (System.getProperty("java.vm.version").startsWith("1.4")) {
            this.showOnLinux();
        } else {
            this.showOnLinux15();
        }
    }

    private void showOnWindows() {
        if (this.list.getModel().getSize() > 0) {
            this.list.setSelectedIndex(0);
        } else {
            this.list.grabFocus();
        }
    }

    private void showOnLinux15() {
        if (this.list.getModel().getSize() > 0) {
            this.list.setSelectedIndex(0);
        }
        this.list.grabFocus();
    }

    private void showOnLinux() {
        for (int i = 0; i < 3; ++i) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (!CompletionWindow.this.list.hasFocus() || !CompletionWindow.this.hasFocus()) {
                        CompletionWindow.this.setVisible(true);
                        CompletionWindow.this.requestFocus();
                        CompletionWindow.this.list.grabFocus();
                        if (CompletionWindow.this.list.getModel().getSize() > 0) {
                            CompletionWindow.this.list.setSelectedIndex(0);
                        }
                    }
                }
            });
        }
    }

    private void selectMethodeWhichStartWith(String string) {
        this.model.setFilter(string);
        this.list.setSelectedIndex(0);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            String string = (String)this.list.getSelectedValue();
            if (this.cmdOrigine.askForDictionnary()) {
                if (this.cmdOrigine.getCompletionCmd().equals(this.cmdOrigine.getFilterCmd())) {
                    this.cmdOrigine.setCompletionCmd(string);
                } else {
                    this.cmdOrigine.setFilteredCmd(string);
                }
            } else if (string != null && string.toLowerCase().startsWith(this.cmdOrigine.getFilterCmd().toLowerCase()) && !string.equals(this.cmdOrigine.getFilterCmd())) {
                if (string.indexOf("(") == -1 || string.endsWith("()")) {
                    this.cmdOrigine.setFilteredCmd(string);
                } else {
                    this.cmdOrigine.setFilteredCmd(string.substring(0, string.lastIndexOf("(") + 1));
                }
            }
            this.setVisible(false);
            this.cmdOrigine.getFocus();
        } else if (keyEvent.getKeyCode() != 32) {
            if (keyEvent.getKeyCode() == 27) {
                this.setVisible(false);
                this.cmdOrigine.getFocus();
            } else if (keyEvent.getKeyCode() == 40) {
                if (this.model.getSize() > 0) {
                    this.list.setSelectedIndex(this.list.getSelectedIndex() % this.model.getSize());
                }
            } else if (keyEvent.getKeyCode() == 38) {
                if (this.model.getSize() > 0) {
                    this.list.setSelectedIndex((this.model.getSize() + this.list.getSelectedIndex()) % this.model.getSize());
                }
            } else if (keyEvent.getKeyCode() == 8) {
                if (this.cmdOrigine.getFilterCmd().length() > 0) {
                    this.cmdOrigine.backSpace();
                    this.selectMethodeWhichStartWith(this.cmdOrigine.getFilterCmd());
                } else {
                    this.setVisible(false);
                    this.cmdOrigine.getFocus();
                }
            } else if (keyEvent.getKeyChar() != '\uffff') {
                this.cmdOrigine.append("" + keyEvent.getKeyChar());
                this.selectMethodeWhichStartWith(this.cmdOrigine.getFilterCmd());
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.resize((int)(this.size.getWidth() + (double)mouseEvent.getX()), (int)(this.size.getHeight() + (double)mouseEvent.getY()));
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.validate();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.size = this.getSize();
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.setVisible(false);
    }

    public class MethodeModel
    extends AbstractListModel {
        private ArrayList data = new ArrayList();
        private ArrayList filteredData = new ArrayList();
        private String filter;

        public Object getElementAt(int n) {
            return this.filter != null ? this.filteredData.get(n) : this.data.get(n);
        }

        public int getSize() {
            return this.filter != null ? this.filteredData.size() : this.data.size();
        }

        public void setFilter(String string) {
            if (string == null || string != null && string.length() == 0) {
                this.filter = null;
            } else {
                this.filter = string;
                this.filteredData.clear();
                for (String string2 : this.data) {
                    if (!string2.toLowerCase().startsWith(string.toLowerCase())) continue;
                    this.filteredData.add(string2);
                }
            }
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public void updateData(Collection collection) {
            Object[] objectArray = collection.toArray();
            Arrays.sort(objectArray);
            this.data.clear();
            for (int i = 0; i < objectArray.length; ++i) {
                this.data.add(objectArray[i].toString());
            }
            this.setFilter(null);
        }

        public void updateData(Method[] methodArray) {
            int n;
            this.data.clear();
            for (int i = 0; i < methodArray.length; ++i) {
                StringBuffer stringBuffer = new StringBuffer(methodArray[i].getName());
                stringBuffer.append("( ");
                for (n = 0; n < methodArray[i].getParameterTypes().length; ++n) {
                    stringBuffer.append(" ");
                    stringBuffer.append(methodArray[i].getParameterTypes()[n].getName());
                    stringBuffer.append(" ,");
                }
                this.data.add(stringBuffer.substring(0, stringBuffer.length() - 1) + ")");
            }
            Object[] objectArray = this.data.toArray();
            Arrays.sort(objectArray);
            this.data.clear();
            for (n = 0; n < objectArray.length; ++n) {
                this.data.add(objectArray[n]);
            }
            this.setFilter(null);
        }
    }
}

