/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.actors.edna;

import java.util.Map;
import java.util.Properties;
import org.dawb.common.util.io.FileUtils;
import org.dawb.passerelle.actors.edna.AbstractEdnaPlugin;
import org.dawb.passerelle.common.message.IVariable;
import org.dawb.passerelle.common.message.Variable;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class ThumbnailImagePlugin
extends AbstractEdnaPlugin {
    private static final long serialVersionUID = -5053674282429774593L;

    public ThumbnailImagePlugin(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super("EDPluginExecThumbnailv10", compositeEntity, string);
    }

    protected String getInputTagName() {
        return "XSDataInputExecThumbnail";
    }

    protected String getSchemaLocation() {
        return "/execPlugins/plugins/EDPluginExecThumbnail-v1.0/datamodel/XSDataExecThumbnail.xsd";
    }

    protected String getPythonLocation() {
        return "/execPlugins/plugins/EDPluginExecThumbnail-v1.0/plugins/EDPluginExecThumbnailv10.py";
    }

    protected String getExampleOutputLocation() {
        return "/execPlugins/plugins/EDPluginExecThumbnail-v1.0/tests/data/XSDataResultThumbnail_reference.xml";
    }

    public String getExtendedInfo() {
        return "Create thumbnail image";
    }

    public String getDefaultInputXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        stringBuilder.append("<XSDataInputThumbnail>\n");
        stringBuilder.append("  <inputImagePath>\n");
        stringBuilder.append("    <path><value>${file_path}</value></path>\n");
        stringBuilder.append("  </inputImagePath>\n");
        stringBuilder.append("  <outputPath>\n");
        stringBuilder.append("    <path><value>${file_dir}</value></path>\n");
        stringBuilder.append("  </outputPath>\n");
        stringBuilder.append("  <levelsInvert><value>1</value></levelsInvert>");
        stringBuilder.append("  <levelsGamma><value>0.8</value></levelsGamma>");
        stringBuilder.append("  <thumbHeight><value>512</value></thumbHeight>");
        stringBuilder.append("  <levelsMax><value>1000</value></levelsMax>");
        stringBuilder.append("</XSDataInputThumbnail>\n");
        return stringBuilder.toString();
    }

    public Properties getDefaultOutputProperties() {
        Properties properties = new Properties();
        properties.put("file_dir", "");
        properties.put("file_path", "");
        properties.put("file_name", "");
        properties.put("thumbnail_output", "/");
        return properties;
    }

    protected void transformOutputValues(Map<String, String> map) {
        if (map.get("file_path") != null) {
            map.put("file_path", FileUtils.setExtension((String)map.get("file_path"), (String)"jpg"));
        }
        if (map.get("file_name") != null) {
            map.put("file_name", FileUtils.setExtension((String)map.get("file_name"), (String)"jpg"));
        }
    }

    protected void transformExampleValue(IVariable iVariable) {
        super.transformExampleValue(iVariable);
        if (!(iVariable instanceof Variable)) {
            return;
        }
        if ("file_path".equals(iVariable.getVariableName()) || "file_name".equals(iVariable.getVariableName())) {
            Variable variable = (Variable)iVariable;
            String string = FileUtils.setExtension((String)variable.getExampleValue().toString(), (String)"jpg");
            variable.setExampleValue((Object)string);
        }
    }
}

