/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.views;

import com.isencia.passerelle.workbench.model.editor.ui.editpart.ActorEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.RelationEditPart;
import java.util.List;
import org.dawb.common.ui.util.EclipseUtils;
import org.dawb.common.ui.util.GridUtils;
import org.dawb.passerelle.common.message.IVariable;
import org.dawb.passerelle.common.message.IVariableProvider;
import org.dawb.passerelle.common.message.Variable;
import org.dawb.passerelle.common.message.XPathVariable;
import org.dawb.passerelle.views.ActorValueLabelProvider;
import org.dawb.passerelle.views.ActorValueObject;
import org.dawb.passerelle.views.ActorValueUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.Page;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.Actor;

public class ActorValuePage
extends Page
implements ISelectionListener,
IPartListener {
    private static Logger logger = LoggerFactory.getLogger(ActorValuePage.class);
    protected CLabel label;
    protected SourceViewer sourceViewer;
    protected TableViewer tableViewer;
    protected TableViewerColumn inNameColumn;
    protected TableViewerColumn inValueColumn;
    protected TableViewerColumn outNameColumn;
    protected TableViewerColumn outValueColumn;
    protected StructuredSelection lastSelection;
    protected Composite container;

    public void createControl(Composite composite) {
        this.container = new Composite(composite, 0);
        this.container.setLayout((Layout)new GridLayout(1, false));
        GridUtils.removeMargins((Composite)this.container);
        this.container.setBackground(composite.getDisplay().getSystemColor(1));
        this.label = new CLabel(this.container, 16384);
        this.label.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.label.setBackground(composite.getDisplay().getSystemColor(1));
        this.sourceViewer = new SourceViewer(this.container, null, 776);
        this.sourceViewer.setEditable(false);
        this.sourceViewer.getTextWidget().setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableViewer = new TableViewer(this.container, 101120);
        this.tableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.createColumns(this.tableViewer);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setColumnProperties(new String[]{"Input Name", "Example Value", "Output Name", "Example Value"});
        this.getSite().getPage().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        this.getSite().getPage().addPartListener((IPartListener)this);
        try {
            this.updateSelection(EclipseUtils.getActivePage().getSelection());
        }
        catch (Throwable throwable) {}
        this.setTableView(false);
    }

    private void createColumns(TableViewer tableViewer) {
        this.inNameColumn = new TableViewerColumn(tableViewer, 16384, 0);
        this.inNameColumn.getColumn().setText("Input Name");
        this.inNameColumn.getColumn().setWidth(200);
        this.inNameColumn.setLabelProvider((CellLabelProvider)new ActorValueLabelProvider(0));
        this.inValueColumn = new TableViewerColumn(tableViewer, 16384, 1);
        this.inValueColumn.getColumn().setText("Example Value");
        this.inValueColumn.getColumn().setWidth(300);
        this.inValueColumn.setLabelProvider((CellLabelProvider)new ActorValueLabelProvider(1));
        this.outNameColumn = new TableViewerColumn(tableViewer, 16384, 2);
        this.outNameColumn.getColumn().setText("Output Name");
        this.outNameColumn.getColumn().setWidth(200);
        this.outNameColumn.setLabelProvider((CellLabelProvider)new ActorValueLabelProvider(2));
        this.outValueColumn = new TableViewerColumn(tableViewer, 16384, 3);
        this.outValueColumn.getColumn().setText("Example Value");
        this.outValueColumn.getColumn().setWidth(300);
        this.outValueColumn.setLabelProvider((CellLabelProvider)new ActorValueLabelProvider(3));
    }

    public Control getControl() {
        return this.container;
    }

    public void setFocus() {
        this.sourceViewer.getTextWidget().setFocus();
    }

    public void dispose() {
        super.dispose();
        this.getSite().getPage().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        this.getSite().getPage().removePartListener((IPartListener)this);
        this.lastSelection = null;
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        try {
            this.updateSelection(iSelection);
        }
        catch (Exception exception) {
            logger.error("Cannot update value", (Throwable)exception);
        }
    }

    protected void updateSelection(ISelection iSelection) throws Exception {
        if (iSelection instanceof StructuredSelection) {
            this.lastSelection = (StructuredSelection)iSelection;
            Object object = this.lastSelection.getFirstElement();
            boolean bl = this.updateObjectSelection(object);
            if (!bl) {
                this.clear();
            }
            this.sourceViewer.refresh();
            this.label.getParent().layout(new Control[]{this.label, this.sourceViewer.getTextWidget()});
            return;
        }
        this.clear();
    }

    protected void setTableView(boolean bl) {
        GridUtils.setVisible((Control)this.label, (!bl ? 1 : 0) != 0);
        GridUtils.setVisible((Control)this.sourceViewer.getControl(), (!bl ? 1 : 0) != 0);
        GridUtils.setVisible((Control)this.tableViewer.getControl(), (boolean)bl);
        this.label.getParent().layout(new Control[]{this.label, this.sourceViewer.getControl(), this.tableViewer.getControl()});
    }

    private void clear() {
        this.label.setText("");
        this.sourceViewer.getTextWidget().setText("");
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }

            public Object[] getElements(Object object) {
                return new ActorValueObject[0];
            }
        });
        this.tableViewer.setInput(new Object());
        this.tableViewer.refresh();
    }

    public void partActivated(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart == this) {
            try {
                this.updateSelection((ISelection)this.lastSelection);
            }
            catch (Throwable throwable) {}
        }
    }

    public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
    }

    public void partClosed(IWorkbenchPart iWorkbenchPart) {
    }

    public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
    }

    public void partOpened(IWorkbenchPart iWorkbenchPart) {
    }

    public boolean updateObjectSelection(Object object) throws Exception {
        if (object == null) {
            return true;
        }
        if (object instanceof XPathVariable) {
            this.setTableView(false);
            XPathVariable xPathVariable = (XPathVariable)object;
            this.label.setText("Example value of variable '" + xPathVariable.getVariableName() + "' with xpath '" + xPathVariable.getxPath() + "'");
            this.sourceViewer.getTextWidget().setText(xPathVariable.getExampleValue().toString());
            return true;
        }
        if (object instanceof Variable) {
            this.setTableView(false);
            Variable variable = (Variable)object;
            this.label.setText("Example value of '" + variable.getVariableName() + "':");
            this.sourceViewer.getTextWidget().setText(variable.getExampleValue().toString());
            return true;
        }
        if (object instanceof AbstractGraphicalEditPart) {
            this.setTableView(true);
            this.updateNamedObject((AbstractGraphicalEditPart)object);
            return true;
        }
        return false;
    }

    private void updateNamedObject(final AbstractGraphicalEditPart abstractGraphicalEditPart) throws Exception {
        Job job = new Job("Updating Actor Inputs and Outputs"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                if (abstractGraphicalEditPart instanceof ActorEditPart) {
                    Actor actor = ((ActorEditPart)abstractGraphicalEditPart).getActor();
                    if (actor instanceof IVariableProvider) {
                        IVariableProvider iVariableProvider = (IVariableProvider)actor;
                        ActorValuePage.this.updateInputsOutputs(iVariableProvider.getInputVariables(), iVariableProvider.getOutputVariables(), true);
                        return Status.OK_STATUS;
                    }
                } else if (abstractGraphicalEditPart instanceof RelationEditPart) {
                    Actor actor = ((ActorEditPart)((RelationEditPart)abstractGraphicalEditPart).getSource()).getActor();
                    List list = null;
                    if (actor instanceof IVariableProvider) {
                        IVariableProvider iVariableProvider = (IVariableProvider)actor;
                        list = iVariableProvider.getOutputVariables();
                    }
                    ActorValuePage.this.updateInputsOutputs(list, null, false);
                    return Status.OK_STATUS;
                }
                ActorValuePage.this.updateInputsOutputs(null, null, true);
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setUser(false);
        job.setPriority(20);
        job.schedule();
    }

    private void updateInputsOutputs(final List<IVariable> list, final List<IVariable> list2, final boolean bl) {
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (bl) {
                    ActorValuePage.this.inNameColumn.getColumn().setText("Input Name");
                    ActorValuePage.this.inNameColumn.getColumn().setWidth(200);
                    ActorValuePage.this.inValueColumn.getColumn().setWidth(300);
                    ActorValuePage.this.outNameColumn.getColumn().setWidth(200);
                    ActorValuePage.this.outNameColumn.getColumn().setResizable(false);
                    ActorValuePage.this.outValueColumn.getColumn().setWidth(300);
                    ActorValuePage.this.outValueColumn.getColumn().setResizable(false);
                } else {
                    ActorValuePage.this.inNameColumn.getColumn().setText("Wire Variable Name");
                    ActorValuePage.this.inNameColumn.getColumn().setWidth(200);
                    ActorValuePage.this.inValueColumn.getColumn().setWidth(300);
                    ActorValuePage.this.outNameColumn.getColumn().setWidth(0);
                    ActorValuePage.this.outNameColumn.getColumn().setResizable(false);
                    ActorValuePage.this.outValueColumn.getColumn().setWidth(0);
                    ActorValuePage.this.outValueColumn.getColumn().setResizable(false);
                }
                ActorValuePage.this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                    public void dispose() {
                    }

                    public void inputChanged(Viewer viewer, Object object, Object object2) {
                    }

                    public Object[] getElements(Object object) {
                        List<ActorValueObject> list3 = ActorValueUtils.getTableObjects(list, list2);
                        return list3.toArray(new ActorValueObject[list3.size()]);
                    }
                });
                ActorValuePage.this.tableViewer.setInput(new Object());
                ActorValuePage.this.tableViewer.refresh();
            }
        });
    }
}

