/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.views;

import org.dawb.passerelle.views.ActorValueObject;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

class ActorValueLabelProvider
extends ColumnLabelProvider {
    private int col;

    public ActorValueLabelProvider(int n) {
        this.col = n;
    }

    public Color getForeground(Object object) {
        if (this.col % 2 == 0) {
            return Display.getCurrent().getSystemColor(9);
        }
        return null;
    }

    public String getText(Object object) {
        ActorValueObject actorValueObject = (ActorValueObject)object;
        switch (this.col) {
            case 0: {
                return actorValueObject.getInputName();
            }
            case 1: {
                return this.getShortVersion(actorValueObject.getInputValue());
            }
            case 2: {
                return actorValueObject.getOutputName();
            }
            case 3: {
                return this.getShortVersion(actorValueObject.getOutputValue());
            }
        }
        return "";
    }

    private String getShortVersion(Object object) {
        if (object == null) {
            return null;
        }
        String string = object.toString().trim();
        if (string.indexOf(10) < 0) {
            return string;
        }
        string = string.substring(0, string.indexOf(10));
        return String.valueOf(string) + "...";
    }
}

