/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.jython;

import org.dawb.gda.extensions.jython.JythonInterpreterUtils;
import org.python.util.PythonInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.AtomicActor;
import ptolemy.actor.Manager;

public class ActorInterpreterUtils {
    private static Logger logger = LoggerFactory.getLogger(ActorInterpreterUtils.class);
    private static PythonInterpreter currentInterpreter;
    private static Manager currentManager;

    public static PythonInterpreter getInterpreterForRun(AtomicActor atomicActor) throws Exception {
        Manager manager = atomicActor.getManager();
        if (manager != currentManager) {
            currentManager = null;
            if (currentInterpreter != null) {
                currentInterpreter.cleanup();
            }
            currentInterpreter = null;
        }
        if (currentInterpreter == null) {
            logger.error("Creating new interpreter for " + manager.getFullName());
            currentInterpreter = JythonInterpreterUtils.getInterpreter();
            currentManager = manager;
        }
        return currentInterpreter;
    }
}

